/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.util.base;

import com.legacy.blue_skies.client.gui.container.MountInventoryContainer;
import com.legacy.blue_skies.entities.util.base.SkiesAnimalEntity;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class SkiesMountEntity
extends SkiesAnimalEntity
implements IInventoryChangedListener {
    private static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(SkiesMountEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(SkiesMountEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected boolean mountJumping;
    protected Inventory mountInventory;

    public SkiesMountEntity(EntityType<? extends SkiesMountEntity> type, World worldIn) {
        super(type, worldIn);
        this.initMountInventory();
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        super.func_213315_a(typeIn, this.func_175446_cd() ? Vector3d.field_186680_a : pos);
    }

    public boolean useTraditionalTravel() {
        return false;
    }

    public abstract int getMaxInventorySlots();

    public abstract Item getSaddleItem();

    public abstract Item getTameItem();

    public Inventory getMountInventory() {
        return this.mountInventory;
    }

    protected void initMountInventory() {
        Inventory inventory = this.mountInventory;
        this.mountInventory = new Inventory(this.getMaxInventorySlots());
        if (inventory != null) {
            inventory.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(inventory.func_70302_i_(), this.mountInventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.mountInventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.mountInventory.func_110134_a((IInventoryChangedListener)this);
    }

    public void func_76316_a(IInventory invBasic) {
        boolean prevSaddled = this.getSaddled();
        if (invBasic.func_70301_a(0).func_77973_b() == this.getSaddleItem() && !prevSaddled) {
            this.func_184185_a(SoundEvents.field_187726_cu, 0.5f, 1.0f);
            this.setSaddled(true);
        } else if (invBasic.func_70301_a(0).func_77973_b() != this.getSaddleItem()) {
            this.setSaddled(false);
        }
    }

    public void func_213352_e(Vector3d travelVectorIn) {
        if (this.useTraditionalTravel()) {
            super.func_213352_e(travelVectorIn);
            return;
        }
        if (this.func_82171_bF() && this.func_70089_S()) {
            Entity entity;
            Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
            if (entity instanceof PlayerEntity) {
                double d0;
                PlayerEntity player = (PlayerEntity)entity;
                this.field_70126_B = this.field_70177_z = entity.field_70177_z;
                this.field_70125_A = entity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70761_aq = this.field_70177_z;
                this.field_70759_as = this.field_70177_z;
                this.field_70138_W = 1.0f;
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                float forward = player.field_191988_bg;
                float strafe = player.field_70702_br;
                if (forward <= 0.0f) {
                    forward *= 0.25f;
                }
                if (this.func_184186_bw()) {
                    float f = (float)this.func_110148_a(Attributes.field_233821_d_).func_111126_e() * 0.225f;
                    this.func_70659_e(f);
                    super.func_213352_e(new Vector3d((double)strafe, 0.0, (double)forward));
                } else {
                    this.func_213317_d(Vector3d.field_186680_a);
                }
                boolean hasJumped = (Boolean)ObfuscationReflectionHelper.getPrivateValue(LivingEntity.class, (Object)player, (String)"field_70703_bu");
                if (hasJumped && this.field_70122_E) {
                    this.func_70664_aZ();
                }
                this.field_184618_aE = this.field_70721_aZ;
                double d1 = this.func_226277_ct_() - this.field_70169_q;
                float f1 = MathHelper.func_76133_a((double)(d1 * d1 + (d0 = this.func_226281_cx_() - this.field_70166_s) * d0)) * 4.0f;
                if (f1 > 1.0f) {
                    f1 = 1.0f;
                }
                this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_70138_W = 0.5f;
                this.field_70747_aH = 0.02f;
                super.func_213352_e(travelVectorIn);
            }
        } else {
            super.func_213352_e(travelVectorIn);
        }
    }

    public boolean func_82171_bF() {
        return this.getSaddled();
    }

    protected float func_175134_bD() {
        return this.func_184207_aI() ? 0.6f : super.func_175134_bD();
    }

    public float func_70689_ay() {
        return this.func_184207_aI() ? 0.25f : 0.3f;
    }

    @Override
    public Item getMainBreedingItem() {
        return this.getTameItem();
    }

    @Override
    public AgeableEntity createChild(AgeableEntity ageable) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Saddle", this.getSaddled());
        compound.func_74757_a("Tame", this.isTamed());
        if (!this.getMountInventory().func_70301_a(0).func_190926_b()) {
            compound.func_218657_a("SaddleItem", (INBT)this.getMountInventory().func_70301_a(0).func_77955_b(new CompoundNBT()));
        }
    }

    public void func_70020_e(CompoundNBT compound) {
        ItemStack itemstack;
        super.func_70020_e(compound);
        this.setSaddled(compound.func_74767_n("Saddle"));
        this.setTamed(compound.func_74767_n("Tame"));
        if (this.getSaddled() && (itemstack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("SaddleItem"))).func_77973_b() == this.getSaddleItem()) {
            this.getMountInventory().func_70299_a(0, itemstack);
        }
    }

    public boolean getSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.field_70180_af.func_187227_b(SADDLED, (Object)saddled);
    }

    public boolean isTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.field_70180_af.func_187227_b(TAMED, (Object)tamed);
    }

    protected void playTameEffect(boolean play) {
        BasicParticleType enumparticletypes = !play ? ParticleTypes.field_197601_L : ParticleTypes.field_197633_z;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)enumparticletypes, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 7) {
            this.playTameEffect(true);
        } else if (id == 6) {
            this.playTameEffect(false);
        } else {
            super.func_70103_a(id);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (!super.func_230254_b_(player, hand).func_226246_a_()) {
            ItemStack itemstack = player.func_184586_b(hand);
            if (itemstack.func_77973_b() == Items.field_151057_cb) {
                itemstack.func_111282_a_(player, (LivingEntity)this, hand);
                return ActionResultType.SUCCESS;
            }
            if (!player.func_213453_ef() && !this.func_184207_aI() && this.isTamed()) {
                if (!this.field_70170_p.field_72995_K) {
                    player.func_184220_m((Entity)this);
                }
                return ActionResultType.SUCCESS;
            }
            if (!this.func_70631_g_() && this.isTamed() && (itemstack.func_77973_b() == this.getSaddleItem() || player.func_213453_ef())) {
                if (player instanceof ServerPlayerEntity) {
                    SkiesMountEntity.openMountContainer((ServerPlayerEntity)player, this);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.FAIL;
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.getMountInventory() != null) {
            for (int i = 0; i < this.getMountInventory().func_70302_i_(); ++i) {
                ItemStack itemstack = this.getMountInventory().func_70301_a(i);
                if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
                this.func_199701_a_(itemstack);
            }
        }
    }

    public static void openMountContainer(ServerPlayerEntity player, SkiesMountEntity enderHorse) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((id, inventory, playerIn) -> new MountInventoryContainer(id, inventory, enderHorse), enderHorse.func_200200_C_()), buffer -> buffer.writeInt(enderHorse.func_145782_y()));
    }
}

