/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.util.base;

import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.BossTypePacket;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;

public abstract class SkiesBossEntity
extends SkiesMonsterEntity
implements ISkyBoss {
    protected static final DataParameter<Boolean> DUNGEON_SPAWNED = EntityDataManager.func_187226_a(SkiesBossEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.func_187226_a(SkiesBossEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> RESPAWNED = EntityDataManager.func_187226_a(SkiesBossEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Byte> DIFFICULTY_ID = EntityDataManager.func_187226_a(SkiesBossEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected BlockPos homePos;
    private final ServerBossInfo bossInfo = this.getNewBossInfo();

    public SkiesBossEntity(EntityType<? extends SkiesBossEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new DoNothingGoal());
    }

    public void func_213315_a(MoverType type, Vector3d vec) {
        if (this.getInvulTime() <= 0) {
            super.func_213315_a(type, vec);
        } else {
            super.func_213315_a(type, new Vector3d(0.0, vec.field_72448_b, 0.0));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DUNGEON_SPAWNED, (Object)false);
        this.field_70180_af.func_187214_a(INVULNERABILITY_TIME, (Object)0);
        this.field_70180_af.func_187214_a(RESPAWNED, (Object)false);
        this.field_70180_af.func_187214_a(DIFFICULTY_ID, (Object)1);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData flag = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (!this.field_70170_p.field_72995_K) {
            this.defaultSpawningRoutine(difficultyIn);
        }
        return flag;
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.readDefaultBossNBT(compound);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.writeDefaultBossNBT(compound);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.bossTick();
    }

    @Override
    public ServerBossInfo getBossInfo() {
        return this.bossInfo;
    }

    public void func_200203_b(ITextComponent name) {
        super.func_200203_b(name);
        this.getBossInfo().func_186739_a((ITextComponent)this.func_145748_c_().func_230531_f_().func_230529_a_(ISkyBoss.getDifficultyDecoration(this.getDifficultyID())));
    }

    public void func_184178_b(ServerPlayerEntity player) {
        PacketHandler.sendToClient(new BossTypePacket((byte)this.getBossType().getId()), player);
        super.func_184178_b(player);
        this.getBossInfo().func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.getBossInfo().func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_213392_I() {
        return true;
    }

    protected float func_70599_aP() {
        return 2.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
            return false;
        }
        if (source.func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76346_g();
            ItemStack stack = player.field_71071_by.func_70448_g();
            if (source.func_180136_u()) {
                return super.func_70097_a(source, amount);
            }
            if (stack.func_77973_b() == SkiesItems.debug_sword) {
                return false;
            }
            return super.func_70097_a(source, Math.min((float)this.getDamageCap(), amount));
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        this.onBossDeath(source);
    }

    @Override
    public void setHome(BlockPos pos) {
        this.homePos = pos;
    }

    @Override
    public BlockPos getHome() {
        if (!this.isDungeonSpawned() || this.homePos == null || this.homePos != null && this.homePos == BlockPos.field_177992_a) {
            return this.func_233580_cy_();
        }
        return this.homePos;
    }

    @Override
    public boolean isDungeonSpawned() {
        return (Boolean)this.field_70180_af.func_187225_a(DUNGEON_SPAWNED);
    }

    @Override
    public void setDungeonSpawned(boolean isDungeonSpawned) {
        this.field_70180_af.func_187227_b(DUNGEON_SPAWNED, (Object)isDungeonSpawned);
    }

    @Override
    public boolean isBossRespawned() {
        return (Boolean)this.field_70180_af.func_187225_a(RESPAWNED);
    }

    @Override
    public void setBossRespawned(boolean isRespawned) {
        this.field_70180_af.func_187227_b(RESPAWNED, (Object)isRespawned);
    }

    @Override
    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABILITY_TIME);
    }

    @Override
    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVULNERABILITY_TIME, (Object)time);
    }

    @Override
    public byte getDifficultyID() {
        return (Byte)this.field_70180_af.func_187225_a(DIFFICULTY_ID);
    }

    @Override
    public void setDifficultyID(byte id) {
        this.field_70180_af.func_187227_b(DIFFICULTY_ID, (Object)((byte)Math.min(3, id)));
    }

    public float getDistanceToPos(double x, double y, double z) {
        return EntityUtil.getDistanceToPos((Vector3i)this.func_233580_cy_(), (Vector3i)new BlockPos(x, y, z));
    }

    public float getDistanceToPos(BlockPos pos) {
        return EntityUtil.getDistanceToPos((Vector3i)this.func_233580_cy_(), (Vector3i)pos);
    }

    @Override
    public MonsterEntity getBoss() {
        return this;
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return SkiesBossEntity.this.getInvulTime() > 0;
        }
    }
}

