/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.projectile;

import com.legacy.blue_skies.client.particle.data.PoisonData;
import com.legacy.blue_skies.registries.SkiesEffects;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.util.EntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class VenomSpitEntity
extends LlamaSpitEntity {
    protected static final DataParameter<Boolean> DEADLY = EntityDataManager.func_187226_a(VenomSpitEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public VenomSpitEntity(EntityType<? extends VenomSpitEntity> type, World world) {
        super(type, world);
    }

    public VenomSpitEntity(World worldIn, LivingEntity spider) {
        this(worldIn, spider, true);
    }

    public VenomSpitEntity(World worldIn, LivingEntity spider, boolean spawnOffsetted) {
        this(SkiesEntityTypes.VENOM_SPIT, worldIn);
        super.func_212361_a((Entity)spider);
        if (spawnOffsetted) {
            this.func_70107_b(spider.func_226277_ct_() - (double)(spider.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(spider.field_70761_aq * ((float)Math.PI / 180))), spider.func_226278_cu_() + (double)spider.func_70047_e() - (double)0.1f, spider.func_226281_cx_() + (double)(spider.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(spider.field_70761_aq * ((float)Math.PI / 180))));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public VenomSpitEntity(World worldIn, double x, double y, double z, double xDir, double yDir, double zDir) {
        this(SkiesEntityTypes.VENOM_SPIT, worldIn);
        this.func_70107_b(x, y, z);
        for (int i = 0; i < 7; ++i) {
            double d0 = 0.4 + 0.1 * (double)i;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197602_M, x, y, z, xDir * d0, yDir, zDir * d0);
        }
        this.func_213293_j(xDir, yDir, zDir);
    }

    public VenomSpitEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(SkiesEntityTypes.VENOM_SPIT, world);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        for (int i = 0; i < 6; ++i) {
            float dx = (this.field_70146_Z.nextFloat() - 0.5f) / 7.0f;
            float dy = this.field_70146_Z.nextFloat() / 10.0f;
            float dz = (this.field_70146_Z.nextFloat() - 0.5f) / 7.0f;
            this.field_70170_p.func_195594_a((IParticleData)new PoisonData(false), (double)this.func_233580_cy_().func_177958_n() + 0.5, (double)((float)this.func_233580_cy_().func_177956_o() + 0.5f), (double)this.func_233580_cy_().func_177952_p() + 0.5, (double)dx, (double)dy, (double)dz);
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vector3d Vector3d2 = new Vector3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(Vector3d2);
        float f = MathHelper.func_76133_a((double)VenomSpitEntity.func_213296_b((Vector3d)Vector3d2));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)Vector3d2.field_72450_a, (double)z) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)Vector3d2.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        Entity owner = this.func_234616_v_();
        Entity target = result.func_216348_a();
        if (owner != null && target != null && !owner.func_184191_r(target)) {
            if (this.isDeadly()) {
                boolean attack = target.func_70097_a(EntityUtil.DamageSources.causeIndirectVenomDamage((Entity)this, owner), 3.0f);
                if (target instanceof LivingEntity && attack) {
                    int durration = 5 * Math.max(3, this.field_70170_p.func_175659_aa().func_151525_a() + 1);
                    int amplifier = this.field_70170_p.func_175659_aa().func_151525_a() / 2;
                    ((LivingEntity)target).func_195064_c(new EffectInstance(SkiesEffects.DEADLY_VENOM, durration, amplifier));
                }
                if (target instanceof PlayerEntity) {
                    ItemStack playerItem;
                    PlayerEntity playerentity = (PlayerEntity)result.func_216348_a();
                    ItemStack itemStack = playerItem = playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a;
                    if (!playerItem.func_190926_b() && playerItem.isShield((LivingEntity)playerentity)) {
                        playerentity.func_190777_m(true);
                        playerentity.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 60);
                        this.field_70170_p.func_72960_a((Entity)playerentity, (byte)30);
                    }
                }
            } else {
                boolean attack = target.func_70097_a(EntityUtil.DamageSources.causeIndirectVenomDamage((Entity)this, owner), 1.0f);
                if (target instanceof LivingEntity && attack) {
                    int durration = 20 * (this.field_70170_p.func_175659_aa().func_151525_a() + 3);
                    int amplifier = this.field_70170_p.func_175659_aa().func_151525_a() / 2;
                    ((LivingEntity)target).func_195064_c(new EffectInstance(Effects.field_76436_u, durration, amplifier));
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DEADLY, (Object)false);
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setDeadly(compound.func_74767_n("Deadly"));
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Deadly", this.isDeadly());
    }

    public boolean isDeadly() {
        return (Boolean)this.field_70180_af.func_187225_a(DEADLY);
    }

    public void setDeadly(boolean deadly) {
        this.field_70180_af.func_187227_b(DEADLY, (Object)deadly);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

