/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive;

import com.legacy.blue_skies.data.objects.SkiesEntityTags;
import com.legacy.blue_skies.entities.hostile.boss.StarlitCrusherEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntRootEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntWallEntity;
import com.legacy.blue_skies.entities.util.base.SkiesAnimalEntity;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class SnowOwlEntity
extends SkiesAnimalEntity
implements IFlyingAnimal {
    protected static final DataParameter<Boolean> HOSTILE = EntityDataManager.func_187226_a(SnowOwlEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    public BlockPos exitPos = null;

    public SnowOwlEntity(EntityType<? extends SnowOwlEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, false);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 1.0));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233822_e_, (double)0.4f).func_233815_a_(Attributes.field_233821_d_, (double)0.2f);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn);
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(true);
        flyingpathnavigator.func_192879_a(true);
        return flyingpathnavigator;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HOSTILE, (Object)false);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setOwlHostile(compound.func_74767_n("OwlHostile"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("OwlHostile", this.isOwlHostile());
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.6f;
    }

    public void func_70636_d() {
        float speed;
        super.func_70636_d();
        this.calculateFlapping();
        float f = speed = this.isFlying() ? 3.0f : 1.0f;
        if (this.isOwlHostile() && this.exitPos != null && this.exitPos != BlockPos.field_177992_a) {
            this.func_70661_as().func_75492_a((double)this.exitPos.func_177958_n(), (double)this.exitPos.func_177956_o(), (double)this.exitPos.func_177952_p(), (double)speed);
            if (EntityUtil.getDistanceToPos((Vector3i)this.func_233580_cy_(), (Vector3i)this.exitPos) < 2.0f) {
                this.exitPos = null;
            }
        } else if (this.func_70638_az() != null) {
            if (!this.func_70685_l((Entity)this.func_70638_az())) {
                this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), (double)speed);
            } else {
                this.func_70605_aq().func_75642_a(this.func_70638_az().func_226277_ct_(), this.func_70638_az().func_226278_cu_() + (double)this.func_70638_az().func_70047_e(), this.func_70638_az().func_226281_cx_(), (double)speed);
            }
        }
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(!this.field_70122_E && !this.func_184218_aH() ? 4 : -1) * 0.3);
        this.flapSpeed = MathHelper.func_76131_a((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vector3d vec3d = this.func_213322_ci();
        if (!this.field_70122_E && vec3d.field_72448_b < 0.0) {
            this.func_213317_d(vec3d.func_216372_d(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    @Override
    public AgeableEntity createChild(AgeableEntity ageable) {
        return null;
    }

    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 2.0f);
    }

    public ResourceLocation func_184647_J() {
        return this.isOwlHostile() ? LootTables.field_186419_a : this.func_200600_R().func_220348_g();
    }

    public SoundEvent func_184639_G() {
        return this.isOwlHostile() ? null : SkiesSounds.ENTITY_SNOW_OWL_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_SNOW_OWL_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_SNOW_OWL_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_192795_es, 0.15f, 1.0f);
    }

    protected float func_191954_d(float volume) {
        this.func_184185_a(SoundEvents.field_192796_et, 0.15f, 1.0f);
        return volume + this.flapSpeed / 2.0f;
    }

    protected boolean func_191957_ae() {
        return true;
    }

    protected float func_70647_i() {
        return EntityUtil.getSoundPitchWithStart(this.field_70146_Z, 1.0f);
    }

    protected float func_70599_aP() {
        return this.isOwlHostile() ? 1.0f : 1.7f;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_82167_n(Entity entityIn) {
        if (!(entityIn instanceof PlayerEntity) && !(entityIn instanceof EntWallEntity)) {
            super.func_82167_n(entityIn);
        }
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }

    public boolean isOwlHostile() {
        return (Boolean)this.field_70180_af.func_187225_a(HOSTILE);
    }

    public void setOwlHostile(boolean hostileIn) {
        if (hostileIn) {
            this.field_70728_aV = 0;
            this.field_70714_bg.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
            this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 2.0, true){

                protected double func_179512_a(LivingEntity attackTarget) {
                    return this.field_75441_b.func_213311_cf() * 3.5f * this.field_75441_b.func_213311_cf() * 3.5f + attackTarget.func_213311_cf();
                }
            });
            this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, StarlitCrusherEntity.class, 5.0f, 0.6, 1.0));
        } else {
            this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        }
        this.field_70180_af.func_187227_b(HOSTILE, (Object)hostileIn);
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn instanceof EntRootEntity) {
            return this.func_184191_r((Entity)((EntRootEntity)entityIn).getCaster());
        }
        if (entityIn.func_200600_R().func_220341_a(SkiesEntityTags.NATURE_ALLIES)) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return super.func_184191_r(entityIn) && entityIn != null && entityIn != this;
    }

    public static boolean spawnConditions(EntityType<? extends AnimalEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        BlockState block = world.func_180495_p(pos.func_177977_b());
        return (block.func_235714_a_((ITag)BlockTags.field_206952_E) || block.func_235714_a_((ITag)BlockTags.field_200031_h)) && world.func_226659_b_(pos, 0) > 8;
    }
}

