/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive;

import com.legacy.blue_skies.entities.util.base.SkiesMountEntity;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;

public class CrystalCamelEntity
extends SkiesMountEntity {
    private static final DataParameter<Boolean> CHESTED = EntityDataManager.func_187226_a(CrystalCamelEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public CrystalCamelEntity(EntityType<? extends CrystalCamelEntity> type, World world) {
        super((EntityType<? extends SkiesMountEntity>)type, world);
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{this.getTameItem()}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233821_d_, (double)0.15f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHESTED, (Object)false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Chested", this.hasChest());
        if (this.hasChest()) {
            ListNBT listnbt = new ListNBT();
            for (int i = 2; i < this.getMountInventory().func_70302_i_(); ++i) {
                ItemStack itemstack = this.getMountInventory().func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                CompoundNBT compoundnbt = new CompoundNBT();
                compoundnbt.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(compoundnbt);
                listnbt.add((Object)compoundnbt);
            }
            compound.func_218657_a("Items", (INBT)listnbt);
        }
    }

    @Override
    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setChested(compound.func_74767_n("Chested"));
        if (this.hasChest()) {
            ListNBT listnbt = compound.func_150295_c("Items", 10);
            this.initMountInventory();
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                int j = compoundnbt.func_74771_c("Slot") & 0xFF;
                if (j < 2 || j >= this.getMountInventory().func_70302_i_()) continue;
                this.getMountInventory().func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)compoundnbt));
            }
        }
    }

    public boolean hasChest() {
        return (Boolean)this.field_70180_af.func_187225_a(CHESTED);
    }

    public void setChested(boolean chested) {
        this.field_70180_af.func_187227_b(CHESTED, (Object)chested);
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_CRYSTAL_CAMEL_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_CRYSTAL_CAMEL_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_CRYSTAL_CAMEL_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SkiesSounds.ENTITY_CRYSTAL_CAMEL_STEP, 0.15f, 1.0f);
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == this.getTameItem();
    }

    public CrystalCamelEntity createChild(AgeableEntity ageable) {
        CrystalCamelEntity entitycamel = (CrystalCamelEntity)SkiesEntityTypes.CRYSTAL_CAMEL.func_200721_a(this.field_70170_p);
        entitycamel.setTamed(this.isTamed());
        return entitycamel;
    }

    public float func_213307_e(Pose pose) {
        return this.func_70631_g_() ? 1.0f : 2.3f;
    }

    public double func_70042_X() {
        return this.func_70631_g_() ? 0.3 : 1.6;
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!this.hasChest() && itemstack.func_77973_b().func_206844_a((ITag)Tags.Items.CHESTS) && !this.func_70631_g_() && this.isTamed()) {
            itemstack.func_111282_a_(player, (LivingEntity)this, hand);
            this.setChested(true);
            itemstack.func_190918_g(1);
            if (player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_191251_dB, SoundCategory.AMBIENT, 1.0f, 1.0f);
            }
            return ActionResultType.SUCCESS;
        }
        if (itemstack.func_77973_b() == this.getTameItem() && !this.isTamed()) {
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(5) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.playTameEffect(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    this.setTamed(true);
                } else {
                    this.playTameEffect(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            } else if (player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_191253_dD, SoundCategory.AMBIENT, 1.0f, 1.0f);
            }
            return ActionResultType.SUCCESS;
        }
        if (!player.func_213453_ef() && this.getSaddled() && this.func_184188_bt().size() < 2) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_184205_a((Entity)this, true);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((!this.func_70089_S() ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                if (i == 0) {
                    f = 0.2f;
                } else {
                    this.applyYawToEntity(passenger);
                    f = -0.6f;
                }
                if (passenger instanceof AnimalEntity) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vector3d vec3d = new Vector3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + vec3d.field_72450_a, this.func_226278_cu_() + (double)f1, this.func_226281_cx_() + vec3d.field_72449_c);
            if (passenger instanceof AnimalEntity && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((AnimalEntity)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @Override
    public float func_70689_ay() {
        return this.func_184207_aI() ? 0.15f : 0.3f;
    }

    @Override
    protected float func_175134_bD() {
        return this.func_184207_aI() ? 0.3f : super.func_175134_bD();
    }

    @Override
    public Item getSaddleItem() {
        return SkiesItems.camel_saddle;
    }

    @Override
    public Item getTameItem() {
        return SkiesItems.scalefruit;
    }

    @Override
    public int getMaxInventorySlots() {
        return 17;
    }
}

