/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss.summons;

import com.legacy.blue_skies.entities.hostile.boss.SummonerEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ArtificialGolemEntity;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class StrangeLightningEntity
extends Entity {
    private int lightningState;
    public long boltVertex;
    private int boltLivingTime;
    private final boolean effectOnly;
    @Nullable
    private ServerPlayerEntity caster;

    public StrangeLightningEntity(World worldIn) {
        super(SkiesEntityTypes.STRANGE_LIGHTNING, worldIn);
        this.field_70158_ak = true;
        this.lightningState = 2;
        this.boltVertex = this.field_70146_Z.nextLong();
        this.boltLivingTime = this.field_70146_Z.nextInt(3) + 1;
        this.effectOnly = false;
        Difficulty difficulty = worldIn.func_175659_aa();
        if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
            this.igniteBlocks(4);
        }
    }

    public StrangeLightningEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(world);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.WEATHER;
    }

    public void setCaster(@Nullable ServerPlayerEntity p_204809_1_) {
        this.caster = p_204809_1_;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.lightningState == 2) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187754_de, SoundCategory.WEATHER, 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.func_70106_y();
            } else if (this.lightningState < -this.field_70146_Z.nextInt(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                this.boltVertex = this.field_70146_Z.nextLong();
                this.igniteBlocks(0);
            }
        }
        if (this.lightningState >= 0 && !this.effectOnly) {
            List list = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.func_226277_ct_() - 3.0, this.func_226278_cu_() - 3.0, this.func_226281_cx_() - 3.0, this.func_226277_ct_() + 3.0, this.func_226278_cu_() + 6.0 + 3.0, this.func_226281_cx_() + 3.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity instanceof SummonerEntity || entity instanceof ArtificialGolemEntity) continue;
                entity.func_70097_a(EntityUtil.DamageSources.causeStrangeLightningDamage(this), 2.0f);
            }
        }
    }

    private void igniteBlocks(int extraIgnitions) {
        if (!this.effectOnly && !this.field_70170_p.field_72995_K) {
            BlockState blockstate = SkiesBlocks.blue_fire.func_176223_P();
            BlockPos blockpos = this.func_233580_cy_();
            if (this.field_70170_p.func_180495_p(blockpos).func_196958_f() && blockstate.func_196955_c((IWorldReader)this.field_70170_p, blockpos)) {
                this.field_70170_p.func_175656_a(blockpos, blockstate);
            }
            for (int i = 0; i < extraIgnitions; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1);
                if (!this.field_70170_p.func_180495_p(blockpos1).func_196958_f() || !blockstate.func_196955_c((IWorldReader)this.field_70170_p, blockpos1)) continue;
                this.field_70170_p.func_175656_a(blockpos1, blockstate);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0 * StrangeLightningEntity.func_184183_bd();
        return distance < d0 * d0;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

