/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss.summons;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.blocks.dungeon.SkyDecayingSpikeBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class DecayingSpikeEntity
extends FallingBlockEntity {
    public static final DataParameter<Boolean> DOWNWARD = EntityDataManager.func_187226_a(DecayingSpikeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private BlockState state = this.getDownwards() ? (BlockState)SkiesBlocks.decaying_spike.func_176223_P().func_206870_a((Property)SkyDecayingSpikeBlock.DOWNWARD, (Comparable)Boolean.valueOf(false)) : SkiesBlocks.decaying_spike.func_176223_P();
    private int timeExisted = 0;
    public boolean upward;
    private LivingEntity caster;
    private UUID casterUuid;

    public DecayingSpikeEntity(EntityType<? extends DecayingSpikeEntity> type, World worldIn) {
        super(SkiesEntityTypes.DECAYING_SPIKE, worldIn);
    }

    public DecayingSpikeEntity(World world, BlockPos pos, BlockState state, LivingEntity casterIn) {
        this(SkiesEntityTypes.DECAYING_SPIKE, world);
        this.field_70156_m = true;
        this.setCaster(casterIn);
        this.setState(state);
        this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
    }

    public DecayingSpikeEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(SkiesEntityTypes.DECAYING_SPIKE, world);
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.caster = caster;
        this.casterUuid = caster == null ? null : caster.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.field_70170_p.field_72995_K && (this.state == null || this.state == Blocks.field_150350_a.func_176223_P())) {
            this.state = this.field_70170_p.func_180495_p(this.func_233580_cy_());
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DOWNWARD, (Object)true);
    }

    public void func_70071_h_() {
        if (this.func_195054_l() == null) {
            this.func_70106_y();
            return;
        }
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        ++this.timeExisted;
        if (!this.func_189652_ae() || !this.upward) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        Block block = SkiesBlocks.decaying_spike;
        if (!this.field_70170_p.field_72995_K) {
            BlockPos blockpos1 = this.func_233580_cy_();
            if (!this.field_70122_E) {
                if (this.timeExisted > 100 && !this.field_70170_p.field_72995_K && (blockpos1.func_177956_o() < 1 || blockpos1.func_177956_o() > 256) || this.timeExisted > 600 || !this.getDownwards() && this.timeExisted >= 15) {
                    if (this.field_70170_p instanceof ServerWorld) {
                        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, SkiesBlocks.lunar_stone.func_176223_P()), this.func_226277_ct_(), this.func_226283_e_(0.6), this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
                    }
                    this.func_70106_y();
                }
            } else {
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos1);
                if (this.field_70170_p.func_175623_d(new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - (double)0.01f, this.func_226281_cx_())) && FallingBlock.func_185759_i((BlockState)this.field_70170_p.func_180495_p(new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - (double)0.01f, this.func_226281_cx_())))) {
                    this.field_70122_E = false;
                    return;
                }
                if (blockstate.func_177230_c() != Blocks.field_196603_bb) {
                    this.func_70106_y();
                    if (!(this.getCaster() instanceof PlayerEntity) || this.getCaster() instanceof PlayerEntity && !EntityUtil.isInDungeon(this.field_70170_p, blockpos1)) {
                        boolean flag2 = blockstate.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(this.field_70170_p, blockpos1, Direction.DOWN, ItemStack.field_190927_a, Direction.UP));
                        boolean flag3 = this.state.func_196955_c((IWorldReader)this.field_70170_p, blockpos1);
                        if (flag2 && flag3) {
                            if (this.state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && this.field_70170_p.func_204610_c(blockpos1).func_206886_c() == Fluids.field_204546_a) {
                                this.state = (BlockState)this.state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
                            }
                            this.field_70170_p.func_180501_a(blockpos1, this.state, 3);
                        }
                    } else if (this.field_70170_p instanceof ServerWorld) {
                        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, SkiesBlocks.lunar_stone.func_176223_P()), this.func_226277_ct_(), this.func_226283_e_(0.6), this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
                    }
                    if (block instanceof FallingBlock) {
                        ((FallingBlock)block).func_190974_b(this.field_70170_p, blockpos1, (FallingBlockEntity)this);
                    }
                }
            }
            if (this.func_213322_ci().func_82617_b() != 0.0) {
                ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()));
                for (Entity entity : list) {
                    this.damage(entity, 0.0f);
                }
            }
        }
        if (this.timeExisted > 100) {
            if (this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, SkiesBlocks.lunar_stone.func_176223_P()), this.func_226277_ct_(), this.func_226283_e_(0.6), this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
            }
            this.func_70106_y();
        }
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        int i = MathHelper.func_76123_f((float)(distance - 1.0f));
        if (i > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()));
            for (Entity entity : list) {
                this.damage(entity, 1.0f);
            }
        }
        return false;
    }

    private void damage(Entity hitEntityIn, float amp) {
        LivingEntity caster = this.getCaster();
        if (hitEntityIn.func_70089_S() && !hitEntityIn.func_190530_aW() && hitEntityIn != caster) {
            if (caster == null) {
                hitEntityIn.func_70097_a(EntityUtil.DamageSources.SPIKE, 5.0f + amp);
            } else {
                if (caster.func_184191_r(hitEntityIn)) {
                    return;
                }
                hitEntityIn.func_70097_a(EntityUtil.DamageSources.causeIndirectSpikeDamage((Entity)caster), 5.0f + amp);
            }
        }
    }

    public void setState(BlockState state) {
        this.state = state;
    }

    public BlockState func_195054_l() {
        return this.state;
    }

    public boolean getDownwards() {
        return (Boolean)this.field_70180_af.func_187225_a(DOWNWARD);
    }

    public void setDownwards(boolean downwardIn) {
        this.field_70180_af.func_187227_b(DOWNWARD, (Object)downwardIn);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setDownwards(compound.func_74767_n("Downward"));
        this.state = Block.func_196257_b((int)compound.func_74762_e("blockstateId"));
        this.casterUuid = compound.func_186857_a("OwnerUUID");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("Downward", this.getDownwards());
        compound.func_74768_a("blockstateId", Block.func_196246_j((BlockState)this.state));
        if (this.casterUuid != null) {
            compound.func_186854_a("OwnerUUID", this.casterUuid);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

