/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.blocks.misc.TrophyBlock;
import com.legacy.blue_skies.entities.hostile.boss.summons.ArtificialGolemEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.StrangeLightningEntity;
import com.legacy.blue_skies.entities.projectile.FluctuantSphereEntity;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import com.legacy.blue_skies.entities.util.base.SkiesIllagerBossEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.items.LootBagItem;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class SummonerEntity
extends SkiesIllagerBossEntity {
    public static final Predicate<ArtificialGolemEntity> NOT_RANGED = golem -> !golem.isRanged() && !golem.playerSpawned();
    public static final Predicate<ArtificialGolemEntity> IS_RANGED = golem -> golem.isRanged() && !golem.playerSpawned();
    public boolean golemsChanged = false;

    public SummonerEntity(EntityType<? extends SummonerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new SummonRangerGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new SummonGolemGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new SphereAttackGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new RegenGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70714_bg.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70714_bg.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(300));
        this.field_70714_bg.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 350.0).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233821_d_, 0.5);
    }

    @Override
    public double getBossHealth() {
        return 350.0 + (double)this.getExtraPlayers() * 200.0;
    }

    @Override
    public float getHealAmount() {
        return 40.0f;
    }

    @Override
    public LootBagItem getLootBag() {
        return SkiesItems.loot_bag_summoner;
    }

    @Override
    public TrophyBlock getTrophy() {
        return SkiesBlocks.summoner_trophy;
    }

    public boolean func_70687_e(EffectInstance effect) {
        return effect.func_188419_a() == Effects.field_188424_y || effect.func_188419_a() == Effects.field_76421_d ? false : super.func_70687_e(effect);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void healthParticles() {
        if (this.secondPhaseHealth()) {
            this.spawnParticles((IParticleData)SkiesParticles.BLUE_FLAME);
        } else {
            this.spawnParticles((IParticleData)ParticleTypes.field_197629_v);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.secondPhaseHealth() && !this.golemsChanged) {
            for (ArtificialGolemEntity golems : this.getGolemsInDungeonArea()) {
                golems.func_184185_a(SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_ACTIVATE, 0.7f, 1.0f);
                golems.setEnraged(true);
            }
            this.golemsChanged = true;
        } else if (!this.secondPhaseHealth() && this.golemsChanged) {
            for (ArtificialGolemEntity golems : this.getGolemsInDungeonArea()) {
                golems.func_184185_a(SkiesSounds.ENTITY_ARTIFICIAL_GOLEM_DEACTIVATE, 0.7f, 1.0f);
                golems.setEnraged(false);
            }
            this.golemsChanged = false;
        }
    }

    @Override
    public Pair<DyeColor, DyeColor> getFireworkColors() {
        return Pair.of((Object)DyeColor.PURPLE, (Object)DyeColor.LIME);
    }

    @Override
    public void invulnerableTick() {
        if (this.field_70170_p.field_72995_K) {
            double d0 = 0.05;
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197629_v, true, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.5, 0.0);
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197629_v, true, this.func_226277_ct_(), this.func_226278_cu_() + 4.0, this.func_226281_cx_(), d0, -0.4, d0);
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197629_v, true, this.func_226277_ct_(), this.func_226278_cu_() + 4.0, this.func_226281_cx_(), d0, -0.4, -d0);
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197629_v, true, this.func_226277_ct_(), this.func_226278_cu_() + 4.0, this.func_226281_cx_(), -d0, -0.4, d0);
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197629_v, true, this.func_226277_ct_(), this.func_226278_cu_() + 4.0, this.func_226281_cx_(), -d0, -0.4, -d0);
        }
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_SUMMONER_IDLE;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_SUMMONER_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_SUMMONER_HURT;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f + 0.9f;
    }

    protected float func_70599_aP() {
        return 1.5f;
    }

    @Override
    public BlockState getFloorState() {
        return SkiesBlocks.turquoise_stonebrick.func_176223_P();
    }

    @Override
    public BossInfo.Color getBossBarColor() {
        return BossInfo.Color.PURPLE;
    }

    public SoundEvent func_213654_dW() {
        return SkiesSounds.ENTITY_SUMMONER_CELEBRATE;
    }

    protected SoundEvent func_193086_dk() {
        return SkiesSounds.ENTITY_SUMMONER_CAST_SPELL;
    }

    @Override
    public SkiesDungeonType getBossType() {
        return SkiesDungeonType.BLINDING;
    }

    @Override
    public int getProgression() {
        return 1;
    }

    @Override
    public boolean isEverbrightBoss() {
        return true;
    }

    public List<ArtificialGolemEntity> getGolemsInDungeonArea() {
        if (this.getHome() == null) {
            return Lists.newArrayList();
        }
        return this.field_70170_p.func_175647_a(ArtificialGolemEntity.class, new AxisAlignedBB(this.getHome()).func_72314_b(35.0, 15.0, 35.0), NOT_RANGED);
    }

    public List<ArtificialGolemEntity> getRangedGolemsInDungeonArea() {
        if (this.getHome() == null) {
            return Lists.newArrayList();
        }
        return this.field_70170_p.func_175647_a(ArtificialGolemEntity.class, new AxisAlignedBB(this.getHome()).func_72314_b(35.0, 15.0, 35.0), IS_RANGED);
    }

    public int getMaxGolemsBasedOnPlayerCount() {
        return (this.getDifficultyID() >= ISkyBoss.Level.GOLD.getId() ? 4 : 3) + Math.min(4, this.getExtraPlayers());
    }

    public class RegenGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private SummonerEntity boss;

        public RegenGoal() {
            super(SummonerEntity.this);
            this.boss = SummonerEntity.this;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0 && this.boss.secondPhaseHealth();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected void func_190868_j() {
            int extraPlayers = Math.min(4, this.boss.getExtraPlayers());
            this.boss.func_195064_c(new EffectInstance(Effects.field_76428_l, (this.boss.getDifficultyID() == ISkyBoss.Level.BRONZE.getId() ? 10 : (this.boss.getDifficultyID() >= ISkyBoss.Level.PLATINUM.getId() ? 23 : (this.boss.getDifficultyID() >= ISkyBoss.Level.GOLD.getId() ? 21 : 20))) + extraPlayers * 5, 5, false, false));
        }

        protected int func_190867_m() {
            return 20;
        }

        protected int func_190869_f() {
            return 70;
        }

        protected int func_190872_i() {
            int extraPlayers = Math.min(7, this.boss.getExtraPlayers());
            return 340 + extraPlayers * 10;
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_REGEN;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.REGENERATION;
        }
    }

    class SummonRangerGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private SummonerEntity boss;

        private SummonRangerGoal() {
            super(SummonerEntity.this);
            this.boss = SummonerEntity.this;
        }

        public boolean func_75250_a() {
            List<ArtificialGolemEntity> golems = this.boss.getGolemsInDungeonArea();
            List<ArtificialGolemEntity> archers = this.boss.getRangedGolemsInDungeonArea();
            return super.func_75250_a() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0 && archers.isEmpty() && golems.size() <= 1;
        }

        protected int func_190869_f() {
            return 100;
        }

        protected int func_190872_i() {
            return 340;
        }

        protected void func_190868_j() {
            if (!(this.boss.field_70170_p instanceof IServerWorld)) {
                return;
            }
            ArrayList targets = new ArrayList();
            targets.addAll(this.boss.getPlayersInDungeonArea());
            for (int i = 0; i < 2; ++i) {
                BlockPos pos = this.boss.func_233580_cy_();
                if (this.boss.isDungeonSpawned()) {
                    pos = this.boss.getHome();
                }
                BlockPos spawnPos = new BlockPos(pos.func_177958_n() + -6 + this.boss.field_70146_Z.nextInt(12), pos.func_177956_o(), pos.func_177952_p() + -6 + this.boss.field_70146_Z.nextInt(12));
                ArtificialGolemEntity golem = new ArtificialGolemEntity(this.boss.field_70170_p, (LivingEntity)this.boss);
                golem.func_174828_a(spawnPos, 0.0f, 0.0f);
                golem.setRanged(true);
                golem.func_213386_a((IServerWorld)this.boss.field_70170_p, this.boss.field_70170_p.func_175649_E(spawnPos), SpawnReason.MOB_SUMMONED, null, null);
                golem.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.boss.getDifficultyID() >= ISkyBoss.Level.PLATINUM.getId() ? 25.0 : (this.boss.getDifficultyID() == ISkyBoss.Level.GOLD.getId() ? 20.0 : 10.0));
                golem.func_70606_j(golem.func_110138_aP());
                if (this.boss.func_70638_az() != null) {
                    golem.func_70624_b(this.boss.func_70638_az());
                }
                if (!targets.isEmpty()) {
                    PlayerEntity player = (PlayerEntity)targets.get(0);
                    golem.func_70624_b((LivingEntity)player);
                    targets.remove(0);
                } else if (!this.boss.getPlayersInDungeonArea().isEmpty()) {
                    golem.func_70624_b((LivingEntity)this.boss.getPlayersInDungeonArea().get(this.boss.field_70170_p.field_73012_v.nextInt(this.boss.getPlayersInDungeonArea().size())));
                } else if (this.boss.func_70638_az() != null) {
                    golem.func_70624_b(this.boss.func_70638_az());
                }
                golem.func_70624_b(this.boss.func_70638_az());
                this.boss.field_70170_p.func_217376_c((Entity)golem);
                if (!(this.boss.field_70170_p instanceof ServerWorld)) continue;
                for (int h = 0; h < 20; ++h) {
                    double dx = this.boss.field_70146_Z.nextGaussian() * 0.02;
                    double dy = this.boss.field_70146_Z.nextGaussian() * 0.02;
                    double dz = this.boss.field_70146_Z.nextGaussian() * 0.02;
                    ((ServerWorld)this.boss.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197598_I, golem.func_226277_ct_() + (double)(this.boss.field_70146_Z.nextFloat() * golem.func_213311_cf() * 2.0f) - (double)golem.func_213311_cf(), golem.func_226278_cu_() + (double)(this.boss.field_70146_Z.nextFloat() * golem.func_213302_cg()), golem.func_226281_cx_() + (double)(this.boss.field_70146_Z.nextFloat() * golem.func_213311_cf() * 2.0f) - (double)golem.func_213311_cf(), 1, dx, dy, dz, 0.0);
                }
            }
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_SUMMONING;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.SUMMON_RANGED_GOLEM;
        }
    }

    class SummonGolemGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private SummonerEntity boss;

        private SummonGolemGoal() {
            super(SummonerEntity.this);
            this.boss = SummonerEntity.this;
        }

        public boolean func_75250_a() {
            int i = this.boss.getGolemsInDungeonArea().size();
            if (i >= this.boss.getMaxGolemsBasedOnPlayerCount()) {
                return false;
            }
            return super.func_75250_a() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0 && this.boss.field_70146_Z.nextInt(8) + 1 > i;
        }

        protected int func_190869_f() {
            return 100;
        }

        protected int func_190872_i() {
            return 340;
        }

        protected void func_190868_j() {
            if (!(this.boss.field_70170_p instanceof IServerWorld)) {
                return;
            }
            ArrayList targets = new ArrayList();
            targets.addAll(this.boss.getPlayersInDungeonArea());
            int maxGolems = this.boss.getMaxGolemsBasedOnPlayerCount() - this.boss.getGolemsInDungeonArea().size();
            for (int i = 0; i < maxGolems; ++i) {
                BlockPos pos = this.boss.func_233580_cy_();
                if (this.boss.isDungeonSpawned()) {
                    pos = this.boss.getHome();
                }
                BlockPos spawnPos = new BlockPos(pos.func_177958_n() + -6 + this.boss.field_70146_Z.nextInt(12), pos.func_177956_o(), pos.func_177952_p() + -6 + this.boss.field_70146_Z.nextInt(12));
                ArtificialGolemEntity golem = new ArtificialGolemEntity(this.boss.field_70170_p, (LivingEntity)this.boss);
                golem.func_174828_a(spawnPos, 0.0f, 0.0f);
                golem.func_213386_a((IServerWorld)this.boss.field_70170_p, this.boss.field_70170_p.func_175649_E(spawnPos), SpawnReason.MOB_SUMMONED, null, null);
                if (this.boss.getDifficultyID() >= ISkyBoss.Level.GOLD.getId()) {
                    golem.func_110148_a(Attributes.field_233826_i_).func_111128_a(4.0);
                    double health = this.boss.getDifficultyID() >= ISkyBoss.Level.PLATINUM.getId() ? 18.0 : 14.0;
                    golem.func_110148_a(Attributes.field_233818_a_).func_111128_a(health);
                    golem.func_70606_j((float)health);
                }
                if (!targets.isEmpty()) {
                    PlayerEntity player = (PlayerEntity)targets.get(0);
                    golem.func_70624_b((LivingEntity)player);
                    targets.remove(0);
                } else if (!this.boss.getPlayersInDungeonArea().isEmpty()) {
                    golem.func_70624_b((LivingEntity)this.boss.getPlayersInDungeonArea().get(this.boss.field_70170_p.field_73012_v.nextInt(this.boss.getPlayersInDungeonArea().size())));
                } else if (this.boss.func_70638_az() != null) {
                    golem.func_70624_b(this.boss.func_70638_az());
                }
                golem.setEnraged(this.boss.secondPhaseHealth());
                this.boss.field_70170_p.func_217376_c((Entity)golem);
                if (!(this.boss.field_70170_p instanceof ServerWorld)) continue;
                for (int h = 0; h < 20; ++h) {
                    double dx = this.boss.field_70146_Z.nextGaussian() * 0.02;
                    double dy = this.boss.field_70146_Z.nextGaussian() * 0.02;
                    double dz = this.boss.field_70146_Z.nextGaussian() * 0.02;
                    ((ServerWorld)this.boss.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197598_I, golem.func_226277_ct_() + (double)(this.boss.field_70146_Z.nextFloat() * golem.func_213311_cf() * 2.0f) - (double)golem.func_213311_cf(), golem.func_226278_cu_() + (double)(this.boss.field_70146_Z.nextFloat() * golem.func_213302_cg()), golem.func_226281_cx_() + (double)(this.boss.field_70146_Z.nextFloat() * golem.func_213311_cf() * 2.0f) - (double)golem.func_213311_cf(), 1, dx, dy, dz, 0.0);
                }
            }
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_SUMMONING;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.SUMMON_GOLEM;
        }
    }

    class SphereAttackGoal
    extends SkiesIllagerBossEntity.UseBossSpellGoal {
        private SummonerEntity boss;

        private SphereAttackGoal() {
            super(SummonerEntity.this);
            this.boss = SummonerEntity.this;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.boss.isAwayFromPlayers() && this.boss.getInvulTime() <= 0;
        }

        protected int func_190869_f() {
            return this.boss.getDifficultyID() >= ISkyBoss.Level.GOLD.getId() ? 50 : 55;
        }

        protected int func_190872_i() {
            return 100;
        }

        protected void func_190868_j() {
            if (this.boss.func_70638_az() != null && this.boss.func_70638_az() instanceof LivingEntity) {
                LivingEntity target = this.boss.func_70638_az();
                double d0 = Math.min(target.func_226278_cu_(), this.boss.func_226278_cu_());
                double d1 = Math.max(target.func_226278_cu_(), this.boss.func_226278_cu_()) + 0.3;
                float f = (float)MathHelper.func_181159_b((double)(target.func_226281_cx_() - this.boss.func_226281_cx_()), (double)(target.func_226277_ct_() - this.boss.func_226277_ct_()));
                if ((double)this.boss.func_70032_d((Entity)target) < 5.0 || this.boss.field_70170_p.func_217366_a(this.boss.func_226277_ct_(), this.boss.func_226278_cu_(), this.boss.func_226281_cx_(), 5.0, true) != null && (double)this.boss.func_70032_d((Entity)this.boss.field_70170_p.func_217366_a(this.boss.func_226277_ct_(), this.boss.func_226278_cu_(), this.boss.func_226281_cx_(), 5.0, true)) < 5.0) {
                    for (int k = 0; k < 8; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                        this.spawnLightning(this.boss.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * 4.5, this.boss.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * 4.5, d0, d1, f2, 3);
                    }
                } else {
                    double x = this.boss.func_70638_az().func_226277_ct_() - this.boss.func_226277_ct_();
                    double y = this.boss.func_70638_az().func_174813_aQ().field_72338_b + (double)(this.boss.func_70638_az().func_213302_cg() / 2.0f) - (this.boss.func_226278_cu_() + (double)(this.boss.func_213302_cg() / 2.0f));
                    double z = this.boss.func_70638_az().func_226281_cx_() - this.boss.func_226281_cx_();
                    this.spawnSphere(x, y, z);
                }
            }
        }

        private void spawnSphere(double posX, double posY, double posZ) {
            LivingEntity target = this.boss.func_70638_az();
            if (target != null) {
                Vector3d lookVector = this.boss.func_70676_i(1.0f);
                FluctuantSphereEntity projectile = new FluctuantSphereEntity(this.boss.field_70170_p, (LivingEntity)this.boss, posX, posY, posZ);
                projectile.func_70107_b(this.boss.func_226277_ct_() + lookVector.field_72450_a * 1.0, this.boss.func_226278_cu_() + (double)(this.boss.func_213302_cg() / 2.0f) + (double)0.2f, this.boss.func_226281_cx_() + lookVector.field_72449_c * 1.0);
                projectile.field_70177_z = this.boss.field_70759_as;
                this.boss.field_70170_p.func_217376_c((Entity)projectile);
            }
        }

        private void spawnLightning(double posX, double posZ, double p_190876_5_, double posY, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(posX, posY, posZ);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState iblockstate;
                VoxelShape voxelshape;
                if (!this.boss.field_70170_p.func_175623_d(blockpos) || this.boss.field_70170_p.func_175623_d(blockpos.func_177977_b())) continue;
                if (!this.boss.field_70170_p.func_175623_d(blockpos) && (voxelshape = (iblockstate = this.boss.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)this.boss.field_70170_p, blockpos)) != null) {
                    d0 = voxelshape.func_197758_c(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
            if (flag) {
                StrangeLightningEntity bolt = new StrangeLightningEntity(this.boss.field_70170_p);
                bolt.func_70012_b(posX, (double)blockpos.func_177956_o() + d0, posZ, 0.0f, 0.0f);
                this.boss.field_70170_p.func_217376_c((Entity)bolt);
            }
        }

        protected SoundEvent func_190871_k() {
            return SkiesSounds.ENTITY_SUMMONER_PREPARE_ATTACK;
        }

        @Override
        protected SkiesIllagerBossEntity.BossSpellColor getSpellColor() {
            return SkiesIllagerBossEntity.BossSpellColor.SPHERE;
        }
    }
}

