/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.blocks.misc.TrophyBlock;
import com.legacy.blue_skies.data.objects.SkiesEntityTags;
import com.legacy.blue_skies.entities.hostile.SpewterEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntRootEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntWallEntity;
import com.legacy.blue_skies.entities.passive.SnowOwlEntity;
import com.legacy.blue_skies.entities.projectile.EntLeafEntity;
import com.legacy.blue_skies.entities.projectile.SpearEntity;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import com.legacy.blue_skies.entities.util.StarlitCrusherSpinSound;
import com.legacy.blue_skies.entities.util.StunnableLookController;
import com.legacy.blue_skies.entities.util.StunnedEntitySound;
import com.legacy.blue_skies.entities.util.base.SkiesBossEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.entities.util.interfaces.IStunnableMob;
import com.legacy.blue_skies.items.LootBagItem;
import com.legacy.blue_skies.items.tools.SkyAxeItem;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StarlitCrusherEntity
extends SkiesBossEntity
implements IStunnableMob {
    public static final Predicate<SnowOwlEntity> OWL_HOSTILE = owl -> owl.isOwlHostile();
    protected static final DataParameter<Boolean> ROOTED = EntityDataManager.func_187226_a(StarlitCrusherEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> TIME_STUNNED = EntityDataManager.func_187226_a(StarlitCrusherEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> SPIN_COOLDOWN = EntityDataManager.func_187226_a(StarlitCrusherEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> SPINNING = EntityDataManager.func_187226_a(StarlitCrusherEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int attackTimer;
    public int spinTimer;
    public int smashTimer;
    private int rootWaveCooldown;
    private int regrowWallsTimer;
    private int owlSpawnCooldown = 400;
    private int deathTicks;
    private int meleeCooldown;
    public byte rootingTime;
    public boolean canShake = false;
    public static Set<Item> SPEARS = ImmutableSet.of((Object)SkiesItems.bluebright_spear, (Object)SkiesItems.lunar_spear, (Object)SkiesItems.starlit_spear, (Object)SkiesItems.dusk_spear, (Object)SkiesItems.frostbright_spear, (Object)SkiesItems.maple_spear, (Object[])new Item[]{SkiesItems.cherry_spear, SkiesItems.soulbound_spear});
    @OnlyIn(value=Dist.CLIENT)
    private ISound stunSound;
    @OnlyIn(value=Dist.CLIENT)
    private ISound spinSound;

    public StarlitCrusherEntity(EntityType<? extends StarlitCrusherEntity> type, World worldIn) {
        super((EntityType<? extends SkiesBossEntity>)type, worldIn);
        this.field_70749_g = new StunnableLookController((MobEntity)this);
        this.field_70728_aV = 40;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false).func_190882_b(6000));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(2, (Goal)new GrowWoodenWallsGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new DirectRootAttackGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new SurroundingRootAttackGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new SmashGroundAttackGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new SpinAttackGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new SpewLeavesAttackGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new OwlSpawnAttackGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new SpewterSpawnAttackGoal());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ROOTED, (Object)false);
        this.field_70180_af.func_187214_a(TIME_STUNNED, (Object)0);
        this.field_70180_af.func_187214_a(SPIN_COOLDOWN, (Object)400);
        this.field_70180_af.func_187214_a(SPINNING, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 500.0).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233820_c_, 100.0);
    }

    @Override
    public double getBossHealth() {
        return 500.0 + (double)this.getExtraPlayers() * 150.0;
    }

    @Override
    public float getHealAmount() {
        return 30.0f;
    }

    @Override
    public LootBagItem getLootBag() {
        return SkiesItems.loot_bag_starlit_crusher;
    }

    @Override
    public TrophyBlock getTrophy() {
        return SkiesBlocks.starlit_crusher_trophy;
    }

    @Override
    public float getMaxReach() {
        return 4.15f;
    }

    @Override
    public void func_213315_a(MoverType type, Vector3d vec) {
        if (!this.isBossInvul() && !this.isStunned() && !this.isRooted() && this.func_70089_S()) {
            super.func_213315_a(type, vec);
        } else {
            super.func_213315_a(type, new Vector3d(0.0, vec.field_72448_b, 0.0));
        }
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (reason == SpawnReason.TRIGGERED && this.getHome() != null) {
            this.field_70170_p.func_175655_b(this.getHome(), false);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(this.getDifficultyID() >= ISkyBoss.Level.GOLD.getId() ? 12.0 : (this.getDifficultyID() == ISkyBoss.Level.SILVER.getId() ? 10.0 : 8.0));
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setRooted(compound.func_74767_n("IsRooted"));
        this.setStunTime(compound.func_74762_e("StunTime"));
        this.setSpinCooldown(compound.func_74762_e("SpinCooldown"));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsRooted", this.isRooted());
        compound.func_74768_a("StunTime", this.getStunTime());
        compound.func_74768_a("SpinCooldown", this.getSpinCooldown());
    }

    public boolean func_70687_e(EffectInstance effect) {
        return effect.func_188419_a() == Effects.field_188424_y || effect.func_188419_a() == Effects.field_76421_d ? false : super.func_70687_e(effect);
    }

    public void func_70624_b(LivingEntity living) {
        if (living == null) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            this.canShake = false;
        }
        super.func_70624_b(living);
    }

    @Override
    public void func_70071_h_() {
        double distanceToHome;
        super.func_70071_h_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.smashTimer > 0) {
            --this.smashTimer;
        }
        if (this.meleeCooldown > 0) {
            --this.meleeCooldown;
        }
        if (this.rootWaveCooldown > 0) {
            --this.rootWaveCooldown;
        }
        if (this.owlSpawnCooldown > 0 && this.getOwlsInDungeonArea().isEmpty()) {
            --this.owlSpawnCooldown;
        }
        this.spinTimer = this.isSpinning() ? ++this.spinTimer : 0;
        double d = distanceToHome = this.getHome() != null ? (double)this.getDistanceToPos(this.getHome()) : 0.0;
        if (this.func_70638_az() != null && this.getSpinCooldown() > 0 && !this.isStunned() && !this.isSpinning() && distanceToHome <= 5.0) {
            this.setSpinCooldown(this.getSpinCooldown() - 1);
        }
        if (this.getWallsInDungeonArea(5.0).size() < 4 && this.regrowWallsTimer > 0) {
            --this.regrowWallsTimer;
        }
        if (this.func_175446_cd() || !this.func_70089_S()) {
            return;
        }
        if (this.isStunned()) {
            this.setStunTime(this.getStunTime() - 1);
            if (this.getStunTime() == 1) {
                this.regrowWallsTimer = 0;
            }
        } else if (!this.isBossInvul()) {
            double distanceForPlayer;
            double d2 = distanceForPlayer = this.getWallsInDungeonArea(5.0).size() < 4 ? 2.75 : 2.1;
            if (!this.field_70170_p.field_72995_K) {
                if (this.meleeCooldown <= 0 && this.field_70173_aa > 20) {
                    for (LivingEntity living : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(distanceForPlayer), this.canSeeAndAttackPredicate())) {
                        this.func_70652_k((Entity)living);
                        if (!this.isSpinning()) {
                            this.meleeCooldown = 20;
                        }
                        if (this.func_70638_az() != null) continue;
                        this.func_70624_b(living);
                    }
                }
                if ((this.func_70638_az() == null || this.isSecondPhase() && this.getSpinCooldown() > 0 || !this.isSecondPhase()) && (this.getWallsInDungeonArea(5.0).size() >= 4 || this.getWallsInDungeonArea(5.0).isEmpty())) {
                    if (distanceToHome > 5.0) {
                        this.func_70661_as().func_75492_a((double)this.getHome().func_177958_n(), (double)this.getHome().func_177956_o(), (double)this.getHome().func_177952_p(), 1.5);
                    } else if (distanceToHome > 0.5) {
                        this.func_70605_aq().func_75642_a((double)((float)this.getHome().func_177958_n() + 0.5f), (double)this.getHome().func_177956_o(), (double)((float)this.getHome().func_177952_p() + 0.5f), 1.0);
                    }
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null) {
            this.setSpinCooldown(400);
            this.setSpinning(false);
        }
        if (this.isRooted() && this.field_70173_aa % 40 == 0) {
            if (this.func_110143_aJ() >= this.func_110138_aP() && this.owlSpawnCooldown > 0) {
                this.setRooted(false);
            }
            if (this.getDifficultyID() != ISkyBoss.Level.PLATINUM.getId() && this.field_70146_Z.nextFloat() < 0.3f || this.getDifficultyID() == ISkyBoss.Level.PLATINUM.getId()) {
                this.func_70691_i(this.field_70146_Z.nextInt(2) + 1);
                this.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_HEAL, 0.8f, 1.0f);
            }
        }
        if (!(this.field_70170_p.field_72995_K || this.func_70638_az() == null || EntityPredicates.field_233583_f_.test(this.func_70638_az()) && this.func_70638_az().func_70089_S())) {
            this.func_70624_b(null);
        }
        if (this.isSpinning() && this.field_70170_p instanceof ServerWorld) {
            for (int i = 0; i < 2; ++i) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197598_I, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1, this.func_174813_aQ().func_216364_b() / 4.0, 0.1, this.func_174813_aQ().func_216362_d() / 4.0, 0.05);
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b())), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 3, this.func_174813_aQ().func_216364_b() / 4.0, 0.1, this.func_174813_aQ().func_216362_d() / 4.0, 0.05);
            }
        }
    }

    @Override
    public void invulnerableTick() {
        super.invulnerableTick();
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)SkiesParticles.FALLING_LEAF, this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() + (double)0.1f, this.func_226281_cx_(), 1, this.func_174813_aQ().func_216364_b() / 2.0, (double)0.1f, this.func_174813_aQ().func_216362_d() / 2.0, 0.05);
        }
    }

    protected void func_70609_aI() {
        if (this.isStunned()) {
            this.setStunned(false);
        }
        boolean flag = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e);
        for (EntWallEntity walls : this.getWallsInDungeonArea(5.0)) {
            walls.playDamageEffect();
            walls.func_70106_y();
        }
        for (SpewterEntity spewters : this.getSpewtersInDungeonArea()) {
            spewters.func_70656_aK();
            spewters.func_70106_y();
        }
        for (SnowOwlEntity owls : this.getOwlsInDungeonArea()) {
            owls.func_70656_aK();
            owls.func_70106_y();
        }
        ++this.deathTicks;
        if (this.deathTicks < 19) {
            super.func_70609_aI();
        }
        this.field_70759_as += 0.0f;
        this.field_70759_as += 0.0f;
        this.field_70125_A += 0.0f;
        float money = this.field_70728_aV;
        if (this.deathTicks > 30 && this.deathTicks % 5 == 0 && flag) {
            this.dropExperience(MathHelper.func_76141_d((float)(money * 0.08f)));
        }
        if (this.deathTicks >= 100 && !this.field_70170_p.field_72995_K) {
            if (this.deathTicks >= 120) {
                if (this.isDungeonSpawned() && this.getHome() != null && this.getHome() != BlockPos.field_177992_a) {
                    this.field_70170_p.func_175656_a(this.getHome(), SkiesBlocks.potted_starlit_sapling.func_176223_P());
                } else {
                    this.field_70170_p.func_175656_a(this.func_233580_cy_(), SkiesBlocks.potted_starlit_sapling.func_176223_P());
                }
                this.func_70106_y();
            }
            if (this.deathTicks % 2 == 0) {
                for (int i = 0; i < 20; ++i) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)9);
                }
            }
        }
        if (this.deathTicks % 5 == 0 && this.field_70170_p instanceof ServerWorld) {
            for (int i = 0; i < 4; ++i) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, SkiesBlocks.starlit_log.func_176223_P()), this.func_226277_ct_(), this.func_226278_cu_() + (double)0.1f, this.func_226281_cx_(), 40, this.func_174813_aQ().func_216364_b() / 4.0, this.func_174813_aQ().func_216360_c() / 4.0, this.func_174813_aQ().func_216362_d() / 4.0, 0.05);
            }
        }
    }

    private void dropExperience(int amount) {
        while (amount > 0) {
            int i = ExperienceOrbEntity.func_70527_a((int)amount);
            amount -= i;
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), i));
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public void func_174812_G() {
        for (EntWallEntity walls : this.getWallsInDungeonArea(5.0)) {
            walls.playDamageEffect();
            walls.func_70106_y();
        }
        for (SpewterEntity spewters : this.getSpewtersInDungeonArea()) {
            spewters.func_70656_aK();
            spewters.func_70106_y();
        }
        for (SnowOwlEntity owls : this.getOwlsInDungeonArea()) {
            owls.func_70656_aK();
            owls.func_70106_y();
        }
        this.func_70106_y();
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.isRooted() || this.isStunned() ? 1.3f : 2.3f;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn instanceof PlayerEntity) {
            ItemStack playerItem;
            PlayerEntity playerentity = (PlayerEntity)entityIn;
            ItemStack itemStack = playerItem = playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a;
            if (!playerItem.func_190926_b() && playerItem.isShield((LivingEntity)playerentity) && !this.isStunned()) {
                if (playerentity instanceof ServerPlayerEntity) {
                    playerItem.func_96631_a(this.field_70146_Z.nextInt(5) + 5, this.field_70146_Z, (ServerPlayerEntity)playerentity);
                }
                playerentity.func_190777_m(true);
                playerentity.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 800);
                this.field_70170_p.func_72960_a((Entity)playerentity, (byte)30);
            }
        }
        if (!this.isSpinning()) {
            this.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_ATTACK, 1.0f, 1.0f);
            this.attackTimer = 10;
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
            entityIn.func_213293_j(this.func_70676_i(1.0f).func_82615_a() * 3.0, 0.5, this.func_70676_i(1.0f).func_82616_c() * 3.0);
        } else {
            entityIn.func_213293_j(this.func_70676_i(1.0f).func_82615_a() * 5.0, 0.5, this.func_70676_i(1.0f).func_82616_c() * 5.0);
        }
        return super.func_70652_k(entityIn);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        ItemStack stack;
        if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, amount);
        }
        if (this.getInvulTime() > 0 || this.isSpinning() || !source.func_180136_u() && this.getWallsInDungeonArea(5.0).size() >= 4) {
            return false;
        }
        if (this.field_70737_aN <= 0 && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)SkiesParticles.FALLING_LEAF, this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() + (double)0.1f, this.func_226281_cx_(), 60, this.func_174813_aQ().func_216364_b() / 2.0, (double)0.1f, this.func_174813_aQ().func_216362_d() / 2.0, 0.05);
        }
        if (!this.field_70170_p.field_72995_K && this.getWallsInDungeonArea(5.0).size() < 4 && this.field_70173_aa > 140 && source.func_76352_a() && source.func_76364_f() instanceof SpearEntity) {
            if (!this.isStunned()) {
                this.setStunned(true);
                this.setRooted(false);
                return super.func_70097_a(source, Math.min(this.func_110143_aJ(), amount / 2.0f));
            }
            return super.func_70097_a(source, amount * 0.3f);
        }
        if (source.func_180136_u() || !(source.func_76364_f() instanceof PlayerEntity) || !(source.func_76346_g() instanceof PlayerEntity)) {
            ItemStack stack2;
            if (source.func_76346_g() instanceof PlayerEntity && (stack2 = ((LivingEntity)source.func_76346_g()).func_184614_ca()).func_77973_b() == Items.field_196180_eI) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }
        if (source.func_76364_f() instanceof LivingEntity && (stack = ((LivingEntity)source.func_76364_f()).func_184614_ca()).func_77973_b() instanceof SkyAxeItem) {
            if (this.isStunned()) {
                return super.func_70097_a(source, amount);
            }
            return super.func_70097_a(source, amount * 0.3f);
        }
        if (source.func_76364_f() instanceof PlayerEntity) {
            ((PlayerEntity)source.func_76364_f()).func_146105_b((ITextComponent)new TranslationTextComponent("gui.blue_skies.tooltip.invalid_ent_weapon"), true);
        }
        return super.func_70097_a(source, Math.min(5.0f, amount * 0.1f));
    }

    protected SoundEvent func_184639_G() {
        return this.isStunned() ? null : SkiesSounds.ENTITY_STARLIT_CRUSHER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_STARLIT_CRUSHER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        this.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_DEATH, this.func_70599_aP(), 1.0f);
        return null;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        if (this.isStunned() || this.isSpinning() || this.isRooted()) {
            return;
        }
        this.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_STEP, 0.25f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 4: {
                if (!this.isSpinning()) {
                    this.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_ATTACK, 1.0f, 1.0f);
                }
                this.attackTimer = 10;
                break;
            }
            case 5: {
                this.smashTimer = 21;
                break;
            }
            case 6: {
                this.owlSpawnCooldown = 400;
                this.canShake = false;
                break;
            }
            case 7: {
                this.canShake = true;
                break;
            }
            case 8: {
                this.canShake = false;
                break;
            }
            case 9: {
                this.spawnParticles((IParticleData)ParticleTypes.field_197598_I);
                break;
            }
            case 10: {
                this.playStunSound();
            }
            case 11: {
                this.playSpinSound();
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public void func_233627_a_(float strength, double x, double z) {
    }

    public void func_70024_g(double x, double y, double z) {
    }

    public boolean isRooted() {
        return (Boolean)this.field_70180_af.func_187225_a(ROOTED);
    }

    public void setRooted(boolean rooted) {
        if (rooted) {
            this.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_ROOT, this.func_70599_aP(), this.func_70647_i());
        }
        this.field_70180_af.func_187227_b(ROOTED, (Object)rooted);
    }

    @Override
    public boolean isStunned() {
        return this.getStunTime() > 0;
    }

    public void setStunned(boolean stunned) {
        this.setStunned(stunned, 120);
    }

    public void setStunned(boolean stunned, int time) {
        if (stunned) {
            this.setSpinning(false);
            this.setStunTime(time);
            this.field_70170_p.func_72960_a((Entity)this, (byte)10);
            for (PlayerEntity players : this.getPlayersInDungeonArea()) {
                players.func_184602_cy();
                SPEARS.forEach(spear -> players.func_184811_cZ().func_185145_a(spear, time * 3));
            }
        } else {
            this.setStunTime(0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playStunSound() {
        if (!this.func_174814_R()) {
            SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
            if (this.stunSound == null || this.stunSound != null && !soundHandler.func_215294_c(this.stunSound)) {
                this.stunSound = new StunnedEntitySound((LivingEntity)this, SkiesSounds.ENTITY_STARLIT_CRUSHER_STUNNED, this.func_70599_aP());
                soundHandler.func_147682_a(this.stunSound);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playSpinSound() {
        if (!this.func_174814_R()) {
            SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
            if (this.spinSound == null || this.spinSound != null && !soundHandler.func_215294_c(this.spinSound)) {
                this.spinSound = new StarlitCrusherSpinSound(this, SkiesSounds.ENTITY_STARLIT_CRUSHER_SPIN, this.func_70599_aP());
                soundHandler.func_147682_a(this.spinSound);
            }
        }
    }

    public int getStunTime() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_STUNNED);
    }

    public void setStunTime(int time) {
        if (time <= 0) {
            this.meleeCooldown = 15;
        }
        this.field_70180_af.func_187227_b(TIME_STUNNED, (Object)time);
    }

    public int getSpinCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(SPIN_COOLDOWN);
    }

    public void setSpinCooldown(int time) {
        this.field_70180_af.func_187227_b(SPIN_COOLDOWN, (Object)time);
    }

    public boolean isSpinning() {
        return (Boolean)this.field_70180_af.func_187225_a(SPINNING);
    }

    public void setSpinning(boolean spin) {
        if (spin != this.isSpinning() && spin && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)11);
        }
        this.spinTimer = 0;
        this.field_70180_af.func_187227_b(SPINNING, (Object)spin);
    }

    public int getDeathTicks() {
        return this.deathTicks;
    }

    public boolean canWallsGoUp() {
        double distance = this.getWallsInDungeonArea(5.0).size() < 4 ? 4.1 : 3.6;
        PlayerEntity closePlayer = this.field_70170_p.func_217366_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), distance, true);
        return !this.isSpinning() && this.getHome() != null && (double)this.getDistanceToPos(this.getHome()) <= 1.5 && (closePlayer != null && !this.func_70685_l((Entity)closePlayer) || closePlayer == null || closePlayer != null && this.func_70685_l((Entity)closePlayer));
    }

    public boolean func_241849_j(Entity entityIn) {
        return StarlitCrusherEntity.canCollideWithEntity((Entity)this, entityIn);
    }

    public static boolean canCollideWithEntity(Entity currentEntity, Entity collidingEntity) {
        return (collidingEntity.func_241845_aY() || collidingEntity.func_70104_M()) && !currentEntity.func_184223_x(collidingEntity) && !collidingEntity.func_184191_r(currentEntity);
    }

    public boolean func_241845_aY() {
        return this.func_70089_S();
    }

    public List<EntWallEntity> getWallsInDungeonArea(double distance) {
        if (!this.field_70170_p.field_72995_K && this.getHome() != null && this.getHome() != BlockPos.field_177992_a) {
            return this.field_70170_p.func_217357_a(EntWallEntity.class, new AxisAlignedBB((double)this.getHome().func_177958_n() - distance, (double)this.getHome().func_177956_o() - 1.0, (double)this.getHome().func_177952_p() - distance, (double)this.getHome().func_177958_n() + distance, (double)this.getHome().func_177956_o() + 10.0, (double)this.getHome().func_177952_p() + distance));
        }
        return ImmutableList.of();
    }

    public List<EntRootEntity> getRootsInDungeonArea(double distance) {
        if (!this.field_70170_p.field_72995_K && this.getHome() != null && this.getHome() != BlockPos.field_177992_a) {
            return this.field_70170_p.func_217357_a(EntRootEntity.class, new AxisAlignedBB((double)this.getHome().func_177958_n() - distance, (double)this.getHome().func_177956_o() - 1.0, (double)this.getHome().func_177952_p() - distance, (double)this.getHome().func_177958_n() + distance, (double)this.getHome().func_177956_o() + 10.0, (double)this.getHome().func_177952_p() + distance));
        }
        return ImmutableList.of();
    }

    public List<SnowOwlEntity> getOwlsInDungeonArea() {
        double distance = 20.0;
        if (!this.field_70170_p.field_72995_K && this.getHome() != null && this.getHome() != BlockPos.field_177992_a) {
            return this.field_70170_p.func_175647_a(SnowOwlEntity.class, new AxisAlignedBB((double)this.getHome().func_177958_n() - distance, (double)this.getHome().func_177956_o() - 1.0, (double)this.getHome().func_177952_p() - distance, (double)this.getHome().func_177958_n() + distance, (double)this.getHome().func_177956_o() + 15.0, (double)this.getHome().func_177952_p() + distance), OWL_HOSTILE);
        }
        return ImmutableList.of();
    }

    public List<SpewterEntity> getSpewtersInDungeonArea() {
        double distance = 10.0;
        if (!this.field_70170_p.field_72995_K && this.getHome() != null && this.getHome() != BlockPos.field_177992_a) {
            return this.field_70170_p.func_217357_a(SpewterEntity.class, new AxisAlignedBB((double)this.getHome().func_177958_n() - distance, (double)this.getHome().func_177956_o() - 1.0, (double)this.getHome().func_177952_p() - distance, (double)this.getHome().func_177958_n() + distance, (double)this.getHome().func_177956_o() + 10.0, (double)this.getHome().func_177952_p() + distance));
        }
        return ImmutableList.of();
    }

    @Override
    public BossInfo.Color getBossBarColor() {
        return BossInfo.Color.GREEN;
    }

    @Override
    public SkiesDungeonType getBossType() {
        return SkiesDungeonType.NATURE;
    }

    @Override
    public int getProgression() {
        return 2;
    }

    @Override
    public boolean isEverbrightBoss() {
        return true;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn instanceof EntRootEntity) {
            return this.func_184191_r((Entity)((EntRootEntity)entityIn).getCaster());
        }
        if (entityIn.func_200600_R().func_220341_a(SkiesEntityTags.NATURE_ALLIES)) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return super.func_184191_r(entityIn) && entityIn != null && entityIn != this;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_210500_b(ITag<Fluid> fluidTag, double p_210500_2_) {
        return this.isDungeonSpawned() ? false : super.func_210500_b(fluidTag, p_210500_2_);
    }

    public void spawnRoots(double xPos, double zPos, double minimumY, double yPos, float rotationIn, int warmupDelay) {
        BlockPos blockpos = new BlockPos(xPos, yPos, zPos);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_224755_d((IBlockReader)this.field_70170_p, blockpos1, Direction.UP)) continue;
            if (this.field_70170_p.func_175623_d(blockpos) && !(voxelshape = (blockstate1 = this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b()) {
                d0 = voxelshape.func_197758_c(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)minimumY) - 1);
        if (flag && this.field_70170_p.func_226664_a_(new AxisAlignedBB(blockpos)) && (this.getDifficultyID() != ISkyBoss.Level.BRONZE.getId() || this.getDifficultyID() == ISkyBoss.Level.BRONZE.getId() && this.field_70170_p.field_73012_v.nextFloat() < 0.7f)) {
            this.field_70170_p.func_217376_c((Entity)new EntRootEntity(this.field_70170_p, xPos, (double)blockpos.func_177956_o() + d0, zPos, rotationIn, warmupDelay, (LivingEntity)this, this.isSecondPhase()));
        }
    }

    public void spawnLeaf(LivingEntity target) {
        double d0 = target.func_226277_ct_();
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 2.0f);
        double d2 = target.func_226281_cx_();
        this.spawnLeafAtPos(new Vector3i(d0, d1, d2));
    }

    public void spawnLeafAtPos(Vector3i pos) {
        EntLeafEntity leaf = new EntLeafEntity(SkiesEntityTypes.ENT_LEAF, (LivingEntity)this, this.field_70170_p);
        leaf.func_70107_b(this.func_226277_ct_() - (double)(this.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180))), this.func_226278_cu_() + (double)this.func_70047_e() + 1.0, this.func_226281_cx_() + (double)(this.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180))));
        double d0 = (double)pos.func_177958_n() - this.func_226277_ct_();
        double d1 = (double)pos.func_177956_o() - leaf.func_226278_cu_();
        double d2 = (double)pos.func_177952_p() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        leaf.func_70186_c(d0, d1 + (double)f, d2, 1.0f, 10.0f);
        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SkiesSounds.ENTITY_STARLIT_CRUSHER_FLING_LEAF, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        this.field_70170_p.func_217376_c((Entity)leaf);
    }

    public void checkAndSpawnSpewters() {
        BlockPos pos;
        SpewterEntity spewter;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        BlockPos home = this.getHome();
        if (this.getSpewtersInSpot(home.func_177982_a(8, 0, 8)).isEmpty()) {
            spewter = new SpewterEntity((EntityType<? extends SpewterEntity>)SkiesEntityTypes.SPEWTER, this.field_70170_p);
            pos = home.func_177982_a(8, 0, 8);
            spewter.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.field_70170_p.func_217376_c((Entity)spewter);
            spewter.func_70656_aK();
            spewter.func_184185_a(SkiesSounds.ENTITY_SPEWTER_GROW, 1.0f, this.func_70647_i());
            spewter.setGrown(true);
        }
        if (this.getSpewtersInSpot(home.func_177982_a(-8, 0, -8)).isEmpty()) {
            spewter = new SpewterEntity((EntityType<? extends SpewterEntity>)SkiesEntityTypes.SPEWTER, this.field_70170_p);
            pos = home.func_177982_a(-8, 0, -8);
            spewter.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.field_70170_p.func_217376_c((Entity)spewter);
            spewter.func_70656_aK();
            spewter.func_184185_a(SkiesSounds.ENTITY_SPEWTER_GROW, 1.0f, this.func_70647_i());
            spewter.setGrown(true);
        }
        if (this.getSpewtersInSpot(home.func_177982_a(8, 0, -8)).isEmpty()) {
            spewter = new SpewterEntity((EntityType<? extends SpewterEntity>)SkiesEntityTypes.SPEWTER, this.field_70170_p);
            pos = home.func_177982_a(8, 0, -8);
            spewter.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.field_70170_p.func_217376_c((Entity)spewter);
            spewter.func_70656_aK();
            spewter.func_184185_a(SkiesSounds.ENTITY_SPEWTER_GROW, 1.0f, this.func_70647_i());
            spewter.setGrown(true);
        }
        if (this.getSpewtersInSpot(home.func_177982_a(-8, 0, 8)).isEmpty()) {
            spewter = new SpewterEntity((EntityType<? extends SpewterEntity>)SkiesEntityTypes.SPEWTER, this.field_70170_p);
            pos = home.func_177982_a(-8, 0, 8);
            spewter.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.field_70170_p.func_217376_c((Entity)spewter);
            spewter.func_70656_aK();
            spewter.func_184185_a(SkiesSounds.ENTITY_SPEWTER_GROW, 1.0f, this.func_70647_i());
            spewter.setGrown(true);
        }
    }

    public List<SpewterEntity> getSpewtersInSpot(BlockPos pos) {
        return this.field_70170_p.func_217357_a(SpewterEntity.class, new AxisAlignedBB(pos).func_186662_g(1.0));
    }

    class SpewterSpawnAttackGoal
    extends Goal {
        private final StarlitCrusherEntity boss;
        private int chargeTime;

        public SpewterSpawnAttackGoal() {
            this.boss = StarlitCrusherEntity.this;
        }

        public boolean func_75250_a() {
            return this.boss.getSpewtersInDungeonArea().size() <= 2 && this.boss.isRooted() && !this.boss.isSpinning() && this.boss.canWallsGoUp() && !this.boss.isStunned() && this.boss.func_70638_az() != null && !this.boss.isStunned() && !this.boss.isBossInvul() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.regrowWallsTimer > 0;
        }

        public boolean func_75253_b() {
            return this.boss.func_70638_az() != null && this.chargeTime > 0 && !this.boss.isStunned() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.regrowWallsTimer > 0;
        }

        public void func_75249_e() {
            this.boss.randomizeAttackTarget(this.boss.field_70146_Z.nextBoolean());
            this.chargeTime = 60;
            this.boss.field_70170_p.func_72960_a((Entity)this.boss, (byte)7);
            this.boss.canShake = true;
        }

        public void func_75246_d() {
            World world = this.boss.field_70170_p;
            this.boss.func_70671_ap().func_75651_a((Entity)this.boss.func_70638_az(), 30.0f, 30.0f);
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            if (this.chargeTime == 20) {
                this.boss.checkAndSpawnSpewters();
            } else if (this.chargeTime == 1) {
                world.func_72960_a((Entity)this.boss, (byte)8);
                this.boss.canShake = false;
            }
        }
    }

    class OwlSpawnAttackGoal
    extends Goal {
        private final StarlitCrusherEntity boss;
        private int chargeTime;
        protected List<BlockPos> outsidePos;
        private BlockPos posToExitAt;

        public OwlSpawnAttackGoal() {
            this.boss = StarlitCrusherEntity.this;
            this.outsidePos = new ArrayList<BlockPos>();
        }

        public boolean func_75250_a() {
            return this.boss.getOwlsInDungeonArea().isEmpty() && this.boss.owlSpawnCooldown <= 0 && !this.boss.isSpinning() && this.boss.canWallsGoUp() && !this.boss.isStunned() && this.boss.func_70638_az() != null && !this.boss.isStunned() && !this.boss.isBossInvul() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.regrowWallsTimer > 0;
        }

        public boolean func_75253_b() {
            return this.boss.func_70638_az() != null && this.chargeTime > 0 && !this.boss.isStunned() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.regrowWallsTimer > 0;
        }

        public void func_75249_e() {
            this.outsidePos.clear();
            for (int i = 0; i < 4; ++i) {
                this.outsidePos.add(this.boss.getHome().func_177967_a(Direction.func_176731_b((int)i), 7).func_177981_b(8));
            }
            this.boss.randomizeAttackTarget(this.boss.field_70146_Z.nextBoolean());
            this.chargeTime = 80;
            this.boss.setRooted(true);
            this.boss.field_70170_p.func_72960_a((Entity)this.boss, (byte)7);
            this.boss.canShake = true;
            this.boss.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_PREPARE_OWLS, 2.0f, 1.0f);
        }

        public void func_75246_d() {
            World world = this.boss.field_70170_p;
            this.boss.func_70671_ap().func_75651_a((Entity)this.boss.func_70638_az(), 30.0f, 30.0f);
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            if (this.chargeTime == 20) {
                PlayerEntity closestPlayer = this.boss.field_70170_p.func_217362_a((Entity)this.boss, 30.0);
                if (closestPlayer != null && !closestPlayer.func_184812_l_() && !closestPlayer.func_175149_v()) {
                    this.posToExitAt = EntityUtil.getClosestPosInList(closestPlayer.func_233580_cy_(), this.outsidePos);
                }
                ArrayList targets = new ArrayList();
                targets.addAll(this.boss.getPlayersInDungeonArea());
                for (int i = 0; i < this.getMaxOwlsBasedOnPlayerCount(); ++i) {
                    SnowOwlEntity owl = (SnowOwlEntity)SkiesEntityTypes.SNOW_OWL.func_200721_a(world);
                    owl.setOwlHostile(true);
                    owl.func_70107_b(this.boss.func_226277_ct_() + (double)(this.boss.func_213311_cf() / 2.0f), this.boss.func_226278_cu_() + (double)this.boss.func_213302_cg() + 0.5, this.boss.func_226281_cx_() + (double)(this.boss.func_213311_cf() / 2.0f));
                    owl.func_213317_d(owl.func_213322_ci().func_72441_c(0.0, (double)0.4f, 0.0));
                    owl.func_110148_a(Attributes.field_233819_b_).func_111128_a(25.0);
                    owl.func_110148_a(Attributes.field_233818_a_).func_111128_a(12.0);
                    if (!targets.isEmpty()) {
                        PlayerEntity player = (PlayerEntity)targets.get(0);
                        owl.func_70624_b((LivingEntity)player);
                        targets.remove(0);
                    } else if (!this.boss.getPlayersInDungeonArea().isEmpty()) {
                        owl.func_70624_b((LivingEntity)this.boss.getPlayersInDungeonArea().get(world.field_73012_v.nextInt(this.boss.getPlayersInDungeonArea().size())));
                    } else if (this.boss.func_70638_az() != null) {
                        owl.func_70624_b(this.boss.func_70638_az());
                    }
                    owl.exitPos = this.posToExitAt != null ? this.posToExitAt : null;
                    world.func_217376_c((Entity)owl);
                }
                this.boss.func_184185_a(SoundEvents.field_187638_cR, this.boss.func_70599_aP(), EntityUtil.getSoundPitchWithStart(this.boss.field_70170_p.field_73012_v, 0.6f));
                this.boss.checkAndSpawnSpewters();
            } else if (this.chargeTime == 1) {
                world.func_72960_a((Entity)this.boss, (byte)6);
                this.boss.canShake = false;
                this.boss.owlSpawnCooldown = 400;
            }
        }

        public int getMaxOwlsBasedOnPlayerCount() {
            int difficultyAmp = this.boss.getDifficultyID() == ISkyBoss.Level.SILVER.getId() ? 4 : (this.boss.getDifficultyID() >= ISkyBoss.Level.GOLD.getId() ? 5 : 3);
            int extraPlayers = Math.max(0, this.boss.getPlayersInDungeonArea().size() - 1);
            return difficultyAmp + extraPlayers;
        }
    }

    class SpewLeavesAttackGoal
    extends Goal {
        private final StarlitCrusherEntity boss;
        private int chargeTime;

        public SpewLeavesAttackGoal() {
            this.boss = StarlitCrusherEntity.this;
        }

        public boolean func_75250_a() {
            return this.boss.getSpinCooldown() <= 0 && !this.boss.isSecondPhase() && this.boss.func_70638_az() != null && !this.boss.isStunned() && !this.boss.isBossInvul() && this.boss.regrowWallsTimer <= 0 && !this.boss.getWallsInDungeonArea(15.0).isEmpty();
        }

        public boolean func_75253_b() {
            return this.boss.getSpinCooldown() <= 0 && this.boss.func_70638_az() != null && !this.boss.isStunned() && this.chargeTime > 0;
        }

        public void func_75249_e() {
            for (EntWallEntity walls : this.boss.getWallsInDungeonArea(5.0)) {
                walls.playDamageEffect();
                walls.func_70106_y();
            }
            this.chargeTime = 260;
            this.boss.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_PREPARE_SPIN, this.boss.func_70599_aP(), this.boss.func_70647_i());
        }

        public void func_75246_d() {
            this.boss.func_70671_ap().func_75651_a((Entity)this.boss.func_70638_az(), 30.0f, 30.0f);
            if (!this.boss.isSpinning()) {
                this.boss.setSpinning(true);
            } else {
                if (this.boss.field_70173_aa % 2 == 0) {
                    LivingEntity target = this.boss.func_70638_az();
                    this.boss.spawnLeaf(target);
                    for (Direction dir : DirectionUtil.HORIZONTAL) {
                        this.boss.spawnLeafAtPos((Vector3i)this.boss.getHome().func_177967_a(dir, 10).func_177981_b(2));
                    }
                }
                if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
            }
            if (this.chargeTime == 1) {
                this.boss.setSpinCooldown(400);
                this.boss.setStunned(true, 80);
            }
        }
    }

    class SpinAttackGoal
    extends Goal {
        private final StarlitCrusherEntity boss;
        protected List<BlockPos> outsidePos;
        private int chargeTime;
        private BlockPos posToExitAt;

        public SpinAttackGoal() {
            this.boss = StarlitCrusherEntity.this;
            this.outsidePos = new ArrayList<BlockPos>();
        }

        public boolean func_75250_a() {
            if (this.boss.getDifficultyID() != ISkyBoss.Level.PLATINUM.getId() && this.boss.regrowWallsTimer > 0 && !this.boss.getWallsInDungeonArea(15.0).isEmpty()) {
                return false;
            }
            return this.boss.getSpinCooldown() <= 0 && this.boss.isSecondPhase() && this.boss.func_70638_az() != null && !this.boss.isStunned() && !this.boss.isBossInvul();
        }

        public boolean func_75253_b() {
            return this.boss.getSpinCooldown() <= 0 && this.boss.func_70638_az() != null && !this.boss.isStunned() && this.chargeTime > 0;
        }

        public void func_75249_e() {
            this.outsidePos.clear();
            this.outsidePos.addAll(EntityUtil.createDiamondOffsetsFromPos(this.boss.getHome(), 7));
            PlayerEntity closestPlayer = this.boss.field_70170_p.func_217362_a((Entity)this.boss, 30.0);
            if (closestPlayer != null && !closestPlayer.func_184812_l_() && !closestPlayer.func_175149_v()) {
                this.posToExitAt = EntityUtil.getClosestPosInList(closestPlayer.func_233580_cy_(), this.outsidePos);
                this.boss.func_70624_b((LivingEntity)closestPlayer);
            }
            this.chargeTime = 300;
            if (this.boss.isRooted()) {
                this.boss.setRooted(false);
            }
            if (this.boss.owlSpawnCooldown < 100) {
                this.boss.owlSpawnCooldown = 100;
            }
        }

        public void func_75246_d() {
            BlockPos spinStartPos = this.boss.getHome() != null && this.posToExitAt != null ? this.posToExitAt : this.boss.func_233580_cy_();
            this.boss.func_70671_ap().func_75651_a((Entity)this.boss.func_70638_az(), 30.0f, 30.0f);
            double distance = this.boss.getDistanceToPos(spinStartPos);
            if (this.chargeTime >= 270) {
                if (this.chargeTime == 300) {
                    this.boss.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_PREPARE_HAMMER, 1.0f, 1.0f);
                    this.boss.smashTimer = 21;
                    this.boss.field_70170_p.func_72960_a((Entity)this.boss, (byte)5);
                }
                if (this.chargeTime == 285) {
                    this.boss.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_HAMMER_SMASH, this.boss.func_70599_aP(), 1.0f);
                    for (EntWallEntity walls : this.boss.getWallsInDungeonArea(5.0)) {
                        walls.playDamageEffect();
                        walls.func_70106_y();
                    }
                }
                --this.chargeTime;
                return;
            }
            if (!this.boss.isSpinning()) {
                if (distance > 3.0) {
                    this.boss.func_70661_as().func_75492_a((double)spinStartPos.func_177958_n(), (double)spinStartPos.func_177956_o(), (double)spinStartPos.func_177952_p(), 2.0);
                }
                if (distance <= 3.0) {
                    this.boss.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_PREPARE_SPIN, this.boss.func_70599_aP(), this.boss.func_70647_i());
                    this.boss.setSpinning(true);
                }
            } else {
                float spinSpeed;
                float f = this.boss.getDifficultyID() == ISkyBoss.Level.PLATINUM.getId() ? 1.65f : (spinSpeed = this.boss.getDifficultyID() == ISkyBoss.Level.GOLD.getId() ? 1.55f : 1.45f);
                if (this.boss.func_70685_l((Entity)this.boss.func_70638_az())) {
                    this.boss.func_70605_aq().func_75642_a(this.boss.func_70638_az().func_226277_ct_(), this.boss.func_70638_az().func_226278_cu_(), this.boss.func_70638_az().func_226281_cx_(), (double)spinSpeed);
                } else {
                    this.boss.func_70661_as().func_75492_a(this.boss.func_70638_az().func_226277_ct_(), this.boss.func_70638_az().func_226278_cu_(), this.boss.func_70638_az().func_226281_cx_(), (double)spinSpeed);
                }
                if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
            }
            if (this.chargeTime == 1) {
                this.boss.setSpinCooldown(800);
                this.boss.setStunned(true, 100);
                this.posToExitAt = null;
            }
        }
    }

    class SmashGroundAttackGoal
    extends Goal {
        private final StarlitCrusherEntity boss;
        private int chargeTime;

        public SmashGroundAttackGoal() {
            this.boss = StarlitCrusherEntity.this;
        }

        public boolean func_75250_a() {
            return !this.boss.isStunned() && this.boss.func_70638_az() != null && !this.boss.isStunned() && !this.boss.isBossInvul() && this.boss.regrowWallsTimer > 0 && this.boss.getWallsInDungeonArea(5.0).size() < 4 && !this.boss.getWallsInDungeonArea(5.0).isEmpty();
        }

        public boolean func_75253_b() {
            return this.boss.canWallsGoUp() && this.boss.func_70638_az() != null && this.chargeTime > 0 && !this.boss.isStunned() && this.boss.regrowWallsTimer > 0;
        }

        public void func_75249_e() {
            this.boss.randomizeAttackTarget(this.boss.field_70146_Z.nextBoolean());
            this.chargeTime = 110;
            if (this.boss.isRooted()) {
                this.boss.setRooted(false);
            }
        }

        public void func_75246_d() {
            World world = this.boss.field_70170_p;
            this.boss.func_70671_ap().func_75651_a((Entity)this.boss.func_70638_az(), 30.0f, 30.0f);
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            if (this.chargeTime >= 20) {
                if (this.chargeTime < 100 && this.chargeTime % 20 == 0) {
                    AxisAlignedBB hitbox = this.boss.func_174813_aQ().func_72314_b(15.0, 0.0, 15.0);
                    this.boss.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_HAMMER_SMASH, 1.0f, this.boss.func_70647_i());
                    if (world instanceof ServerWorld) {
                        for (int i = 0; i < 20; ++i) {
                            ((ServerWorld)world).func_195598_a((IParticleData)SkiesParticles.CRUSHER_DUST, this.boss.func_226277_ct_(), this.boss.func_226278_cu_(), this.boss.func_226281_cx_(), 10, 0.0, 0.0, 0.0, 0.05);
                            ((ServerWorld)world).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, SkiesBlocks.nature_stone.func_176223_P()), this.boss.func_226277_ct_(), this.boss.func_226278_cu_(), this.boss.func_226281_cx_(), 20, hitbox.func_216364_b() / 4.0, 0.1, hitbox.func_216362_d() / 4.0, 0.05);
                        }
                    }
                    for (Entity entity : world.func_72839_b((Entity)this.boss, hitbox)) {
                        LivingEntity living;
                        if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).func_233570_aj_() || !(living.func_110148_a(Attributes.field_233820_c_).func_111126_e() < 1.0) || !living.func_70097_a(EntityUtil.DamageSources.causeSlamDamage((Entity)this.boss), 3.0f)) continue;
                        living.func_213293_j(living.func_213322_ci().func_82615_a(), 0.7, living.func_213322_ci().func_82616_c());
                        if (!(living instanceof PlayerEntity)) continue;
                        ((PlayerEntity)living).field_70133_I = true;
                    }
                }
                if (this.chargeTime % 20 == 13) {
                    this.boss.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_PREPARE_HAMMER, 1.0f, 1.0f);
                    this.boss.smashTimer = 21;
                    world.func_72960_a((Entity)this.boss, (byte)5);
                }
            }
        }
    }

    class GrowWoodenWallsGoal
    extends Goal {
        private final StarlitCrusherEntity boss;
        private int chargeTime;

        public GrowWoodenWallsGoal() {
            this.boss = StarlitCrusherEntity.this;
        }

        public boolean func_75250_a() {
            if (this.boss.getSpinCooldown() <= 0) {
                return false;
            }
            return this.boss.canWallsGoUp() && !this.boss.isStunned() && this.boss.func_70638_az() != null && !this.boss.isBossInvul() && (this.boss.regrowWallsTimer <= 0 || this.boss.getWallsInDungeonArea(5.0).isEmpty());
        }

        public boolean func_75253_b() {
            if (this.boss.isSecondPhase() && this.boss.getSpinCooldown() <= 0) {
                return false;
            }
            return this.boss.canWallsGoUp() && this.boss.func_70638_az() != null && this.chargeTime > 0 && !this.boss.isStunned();
        }

        public void func_75249_e() {
            this.boss.randomizeAttackTarget(this.boss.field_70146_Z.nextBoolean());
            for (SnowOwlEntity owl : this.boss.getOwlsInDungeonArea()) {
                owl.func_70656_aK();
                owl.func_70106_y();
            }
            this.chargeTime = 20;
            this.boss.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_PREPARE_LARGE_GROWTH, this.boss.func_70599_aP(), this.boss.func_70647_i());
        }

        public void func_75246_d() {
            World world = this.boss.field_70170_p;
            this.boss.func_70671_ap().func_75651_a((Entity)this.boss.func_70638_az(), 30.0f, 30.0f);
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            if (!world.field_72995_K && this.chargeTime == 1) {
                BlockPos home = this.boss.getHome();
                if (!this.boss.getWallsInDungeonArea(5.0).isEmpty()) {
                    for (EntWallEntity walls : this.boss.getWallsInDungeonArea(5.0)) {
                        walls.func_70606_j(walls.func_110138_aP());
                    }
                }
                if (this.getWallsInSpot(home.func_177982_a(3, 0, 0)).isEmpty()) {
                    EntWallEntity wallx = new EntWallEntity(world, home.func_177958_n() + 3, home.func_177956_o(), home.func_177952_p(), (LivingEntity)this.boss);
                    wallx.setFacingZ(false);
                    wallx.func_70606_j(wallx.func_110138_aP());
                    world.func_217376_c((Entity)wallx);
                    wallx.func_184185_a(SkiesSounds.ENTITY_STARLIT_WALL_GROW, 1.0f, this.boss.func_70647_i());
                }
                if (this.getWallsInSpot(home.func_177982_a(-3, 0, 0)).isEmpty()) {
                    EntWallEntity wallx2 = new EntWallEntity(world, home.func_177958_n() - 3, home.func_177956_o(), home.func_177952_p(), (LivingEntity)this.boss);
                    wallx2.setFacingZ(false);
                    wallx2.func_70606_j(wallx2.func_110138_aP());
                    world.func_217376_c((Entity)wallx2);
                    wallx2.func_184185_a(SkiesSounds.ENTITY_STARLIT_WALL_GROW, 1.0f, this.boss.func_70647_i());
                }
                if (this.getWallsInSpot(home.func_177982_a(0, 0, 3)).isEmpty()) {
                    EntWallEntity wallz = new EntWallEntity(world, home.func_177958_n(), home.func_177956_o(), home.func_177952_p() + 3, (LivingEntity)this.boss);
                    wallz.setFacingZ(true);
                    wallz.func_70606_j(wallz.func_110138_aP());
                    world.func_217376_c((Entity)wallz);
                    wallz.func_184185_a(SkiesSounds.ENTITY_STARLIT_WALL_GROW, 1.0f, this.boss.func_70647_i());
                }
                if (this.getWallsInSpot(home.func_177982_a(0, 0, -3)).isEmpty()) {
                    EntWallEntity wallz2 = new EntWallEntity(world, home.func_177958_n(), home.func_177956_o(), home.func_177952_p() - 3, (LivingEntity)this.boss);
                    wallz2.setFacingZ(true);
                    wallz2.func_70606_j(wallz2.func_110138_aP());
                    world.func_217376_c((Entity)wallz2);
                    wallz2.func_184185_a(SkiesSounds.ENTITY_STARLIT_WALL_GROW, 1.0f, this.boss.func_70647_i());
                }
                this.boss.regrowWallsTimer = 100;
            }
        }

        public List<EntWallEntity> getWallsInSpot(BlockPos pos) {
            return this.boss.field_70170_p.func_217357_a(EntWallEntity.class, new AxisAlignedBB(pos).func_186662_g(1.0));
        }
    }

    class SurroundingRootAttackGoal
    extends Goal {
        private final StarlitCrusherEntity boss;
        private int chargeTime;

        public SurroundingRootAttackGoal() {
            this.boss = StarlitCrusherEntity.this;
        }

        public boolean func_75250_a() {
            return !this.boss.isSpinning() && this.boss.canWallsGoUp() && !this.boss.isStunned() && this.boss.func_70638_az() != null && !this.boss.isStunned() && !this.boss.isBossInvul() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.rootWaveCooldown <= 0 && this.boss.regrowWallsTimer > 0;
        }

        public boolean func_75253_b() {
            return this.boss.canWallsGoUp() && this.boss.func_70638_az() != null && this.chargeTime > 0 && !this.boss.isStunned() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.regrowWallsTimer > 0;
        }

        public void func_75249_e() {
            List playersInDungeon = this.boss.getPlayersInDungeonArea();
            for (PlayerEntity players : playersInDungeon) {
                if (players == this.boss.func_70638_az() || !this.boss.field_70146_Z.nextBoolean() || playersInDungeon.size() <= 1 || players.func_184812_l_() || players.func_175149_v()) continue;
                this.boss.func_70624_b((LivingEntity)players);
            }
            this.chargeTime = 100;
        }

        public void func_75246_d() {
            World world = this.boss.field_70170_p;
            this.boss.func_70671_ap().func_75651_a((Entity)this.boss.func_70638_az(), 30.0f, 30.0f);
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            LivingEntity livingentity = this.boss.func_70638_az();
            double d0 = Math.min(livingentity.func_226278_cu_(), this.boss.func_226278_cu_());
            double d1 = Math.max(livingentity.func_226278_cu_(), this.boss.func_226278_cu_()) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(livingentity.func_226281_cx_() - this.boss.func_226281_cx_()), (double)(livingentity.func_226277_ct_() - this.boss.func_226277_ct_()));
            switch (this.chargeTime) {
                case 80: {
                    double distance = 5.5;
                    int amount = 16;
                    for (int k = 0; k < amount; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / (float)amount + 9.05f;
                        this.boss.spawnRoots(this.boss.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * distance + (double)(world.field_73012_v.nextInt(2) - 1), this.boss.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * distance + (double)(world.field_73012_v.nextInt(2) - 1), d0, d1, f2, 3);
                    }
                    break;
                }
                case 60: {
                    double distance = 7.5;
                    int amount = 20;
                    for (int k = 0; k < amount; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / (float)amount + 9.05f;
                        this.boss.spawnRoots(this.boss.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * distance + (double)(world.field_73012_v.nextInt(2) - 1), this.boss.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * distance + (double)(world.field_73012_v.nextInt(2) - 1), d0, d1, f2, 3);
                    }
                    break;
                }
                case 40: {
                    double distance = 9.5;
                    int amount = 24;
                    for (int k = 0; k < amount; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / (float)amount + 9.05f;
                        this.boss.spawnRoots(this.boss.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * distance + (double)(world.field_73012_v.nextInt(2) - 1), this.boss.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * distance + (double)(world.field_73012_v.nextInt(2) - 1), d0, d1, f2, 3);
                    }
                    break;
                }
                case 20: {
                    double distance = 11.5;
                    int amount = 28;
                    for (int k = 0; k < amount; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / (float)amount + 9.05f;
                        this.boss.spawnRoots(this.boss.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * distance + (double)(world.field_73012_v.nextInt(2) - 1), this.boss.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * distance + (double)(world.field_73012_v.nextInt(2) - 1), d0, d1, f2, 3);
                    }
                    break;
                }
            }
            if (this.chargeTime == 1) {
                this.boss.rootWaveCooldown = 40;
            }
        }
    }

    class DirectRootAttackGoal
    extends Goal {
        private final StarlitCrusherEntity boss;
        private int chargeTime;

        public DirectRootAttackGoal() {
            this.boss = StarlitCrusherEntity.this;
        }

        public boolean func_75250_a() {
            return this.boss.owlSpawnCooldown > 0 && this.boss.getOwlsInDungeonArea().isEmpty() && !this.boss.isSpinning() && this.boss.canWallsGoUp() && !this.boss.isStunned() && this.boss.func_70638_az() != null && !this.boss.isBossInvul() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.regrowWallsTimer > 0;
        }

        public boolean func_75253_b() {
            return this.boss.owlSpawnCooldown > 0 && this.boss.getOwlsInDungeonArea().isEmpty() && this.boss.func_70638_az() != null && this.chargeTime > 0 && !this.boss.isStunned() && this.boss.getWallsInDungeonArea(5.0).size() >= 4 && this.boss.regrowWallsTimer > 0;
        }

        public void func_75249_e() {
            List playersInDungeon = this.boss.getPlayersInDungeonArea();
            for (PlayerEntity players : playersInDungeon) {
                if (players == this.boss.func_70638_az() || !this.boss.field_70146_Z.nextBoolean() || playersInDungeon.size() <= 1 || players.func_184812_l_() || players.func_175149_v()) continue;
                this.boss.func_70624_b((LivingEntity)players);
            }
            this.chargeTime = 160;
            this.boss.func_184185_a(SkiesSounds.ENTITY_STARLIT_CRUSHER_PREPARE_SMALL_GROWTH, 2.0f, this.boss.func_70647_i());
        }

        public void func_75246_d() {
            this.boss.func_70671_ap().func_75651_a((Entity)this.boss.func_70638_az(), 30.0f, 30.0f);
            if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            if (this.chargeTime >= 70 && this.chargeTime % 10 == 0) {
                if (!(this.boss.func_70638_az() instanceof PlayerEntity)) {
                    LivingEntity livingentity = this.boss.func_70638_az();
                    double d0 = Math.min(livingentity.func_226278_cu_(), this.boss.func_226278_cu_());
                    double d1 = Math.max(livingentity.func_226278_cu_(), this.boss.func_226278_cu_()) + 1.0;
                    float f = (float)MathHelper.func_181159_b((double)(livingentity.func_226281_cx_() - this.boss.func_226281_cx_()), (double)(livingentity.func_226277_ct_() - this.boss.func_226277_ct_()));
                    for (int l = 0; l < 16; ++l) {
                        double d2 = 1.25 * (double)(l + 3);
                        int j = 1 * l;
                        this.boss.spawnRoots(this.boss.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, this.boss.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j);
                    }
                }
                if (!this.boss.getPlayersInDungeonArea().isEmpty()) {
                    for (PlayerEntity players : this.boss.getPlayersInDungeonArea()) {
                        double d0 = Math.min(players.func_226278_cu_(), this.boss.func_226278_cu_());
                        double d1 = Math.max(players.func_226278_cu_(), this.boss.func_226278_cu_()) + 1.0;
                        float f = (float)MathHelper.func_181159_b((double)(players.func_226281_cx_() - this.boss.func_226281_cx_()), (double)(players.func_226277_ct_() - this.boss.func_226277_ct_()));
                        for (int l = 0; l < 16; ++l) {
                            double d2 = 1.25 * (double)(l + 3);
                            int j = 1 * l;
                            this.boss.spawnRoots(this.boss.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, this.boss.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j);
                        }
                    }
                }
            }
        }
    }

    public static enum EntLegPosition {
        NONE,
        SPINNING,
        ROOTED,
        STUNNED,
        DYING;


        public static EntLegPosition getEntPosition(StarlitCrusherEntity ent) {
            if (ent.getDeathTicks() > 0) {
                return DYING;
            }
            if (ent.isSpinning()) {
                return SPINNING;
            }
            if (ent.isRooted()) {
                return ROOTED;
            }
            if (ent.isStunned()) {
                return STUNNED;
            }
            return NONE;
        }
    }
}

