/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.passive.CrogreEntity;
import com.legacy.blue_skies.entities.projectile.VenomSpitEntity;
import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEffects;
import com.legacy.blue_skies.registries.SkiesSounds;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class VenomSpiderEntity
extends SkiesMonsterEntity
implements IRangedAttackMob {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(VenomSpiderEntity.class, (IDataSerializer)DataSerializers.field_187191_a);

    public VenomSpiderEntity(EntityType<? extends VenomSpiderEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (Goal)new SpiderMeleeAttackGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new RangedAttackGoal(this, 0.0, 40, 20.0f){

            public boolean func_75250_a() {
                VenomSpiderEntity spider = VenomSpiderEntity.this;
                LivingEntity target = spider.func_70638_az();
                if (target == null) {
                    return false;
                }
                return target.func_70032_d((Entity)spider) >= 5.0f && super.func_75250_a();
            }

            public boolean func_75253_b() {
                VenomSpiderEntity spider = VenomSpiderEntity.this;
                LivingEntity target = spider.func_70638_az();
                if (target == null) {
                    return false;
                }
                return target.func_70032_d((Entity)spider) >= 5.0f && super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new SpiderTargetGoal<PlayerEntity>(this, PlayerEntity.class));
        this.field_70715_bh.func_75776_a(3, new SpiderTargetGoal<IronGolemEntity>(this, IronGolemEntity.class));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, CrogreEntity.class, 8.0f, 1.0, 1.0));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 22.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233819_b_, 20.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Effect effect;
        if (spawnDataIn == null) {
            spawnDataIn = new SpiderEntity.GroupData();
            if (worldIn.func_175659_aa() == Difficulty.HARD && worldIn.func_201674_k().nextFloat() < 0.1f * difficultyIn.func_180170_c()) {
                ((SpiderEntity.GroupData)spawnDataIn).func_111104_a(worldIn.func_201674_k());
            }
        }
        if (spawnDataIn instanceof SpiderEntity.GroupData && (effect = ((SpiderEntity.GroupData)spawnDataIn).field_188478_a) != null) {
            this.func_195064_c(new EffectInstance(effect, Integer.MAX_VALUE));
        }
        return spawnDataIn;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new ClimberPathNavigator((MobEntity)this, worldIn);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
    }

    public double getMountedYOffset() {
        return this.func_213302_cg() * 0.5f;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return 0.0f;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        boolean randomBoolean = this.field_70170_p.func_72896_J() ? true : this.field_70146_Z.nextBoolean();
        return randomBoolean && super.func_213380_a(worldIn, spawnReasonIn);
    }

    protected SoundEvent func_184639_G() {
        return SkiesSounds.ENTITY_VENOM_SPIDER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_VENOM_SPIDER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_VENOM_SPIDER_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        return potioneffectIn.func_188419_a() == Effects.field_76436_u ? false : (potioneffectIn.func_188419_a() == SkiesEffects.DEADLY_VENOM ? false : super.func_70687_e(potioneffectIn));
    }

    public void func_213295_a(BlockState stateIn, Vector3d motionVec) {
        if (stateIn.func_177230_c() != Blocks.field_196553_aF && stateIn.func_177230_c() != SkiesBlocks.spider_webbing) {
            super.func_213295_a(stateIn, motionVec);
        }
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        VenomSpitEntity venom = new VenomSpitEntity(this.field_70170_p, (LivingEntity)this);
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - venom.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        venom.func_70186_c(d0, d1 + (double)f, d2, 1.5f, 5.0f);
        this.func_184185_a(SkiesSounds.ENTITY_VENOM_SPIDER_SPIT, 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        this.field_70170_p.func_217376_c((Entity)venom);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int durration = 20 * (Math.min(2, this.field_70170_p.func_175659_aa().func_151525_a()) + 3);
                int amplifier = this.field_70170_p.func_175659_aa().func_151525_a() / 2;
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, durration, amplifier));
            }
            return true;
        }
        return false;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.65f;
    }

    static class SpiderTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public SpiderTargetGoal(VenomSpiderEntity spider, Class<T> classTarget) {
            super((MobEntity)spider, classTarget, true);
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }

        public void func_75246_d() {
            super.func_75246_d();
        }
    }

    static class SpiderMeleeAttackGoal
    extends MeleeAttackGoal {
        public SpiderMeleeAttackGoal(VenomSpiderEntity spider) {
            super((CreatureEntity)spider, 1.0, true);
        }

        public boolean func_75250_a() {
            LivingEntity target = this.field_75441_b.func_70638_az();
            if (target == null) {
                return false;
            }
            return target.func_70032_d((Entity)this.field_75441_b) < 5.0f && super.func_75250_a();
        }

        public boolean func_75253_b() {
            LivingEntity target = this.field_75441_b.func_70638_az();
            if (target == null) {
                return false;
            }
            return target.func_70032_d((Entity)this.field_75441_b) < 5.0f && super.func_75253_b();
        }

        public void func_75246_d() {
            super.func_75246_d();
            LivingEntity target = this.field_75441_b.func_70638_az();
            if (target.func_70032_d((Entity)this.field_75441_b) >= 5.0f) {
                this.func_75251_c();
            }
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }
}

