/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.client.particle.StarFlareParticle;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.LogicUtil;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.AmbientEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FrostSpiritEntity
extends AmbientEntity {
    private BlockPos spawnPosition;
    public float wingRotation;
    public float destPos;
    public float prevDestPos;
    public float prevWingRotation;
    protected int ticksUntilFlap;

    public FrostSpiritEntity(EntityType<? extends FrostSpiritEntity> type, World world) {
        super(type, world);
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SkiesSounds.ENTITY_FROST_SPIRIT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SkiesSounds.ENTITY_FROST_SPIRIT_DEATH;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 3.0);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    protected void func_184231_a(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public float func_213307_e(Pose pose) {
        return this.func_213302_cg() / 2.0f;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1)) {
            this.spawnPosition = null;
        }
        if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_218137_a((IPosition)this.func_213303_ch(), 2.0)) {
            this.spawnPosition = new BlockPos((int)this.func_226277_ct_() + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.func_226278_cu_() + this.field_70146_Z.nextInt(6) - 2, (int)this.func_226281_cx_() + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
        }
        double d0 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.func_226277_ct_();
        double d1 = (double)this.spawnPosition.func_177956_o() + 0.1 - this.func_226278_cu_();
        double d2 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.func_226281_cx_();
        Vector3d vec3d = this.func_213322_ci();
        Vector3d vec3d1 = vec3d.func_72441_c((Math.signum(d0) * 0.5 - vec3d.field_72450_a) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3d.field_72448_b) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3d.field_72449_c) * (double)0.1f);
        this.func_213317_d(vec3d1);
        float f = (float)(MathHelper.func_181159_b((double)vec3d1.field_72449_c, (double)vec3d1.field_72450_a) * 57.2957763671875) - 90.0f;
        float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
        this.field_191988_bg = 1.0f;
        this.field_70177_z += f1;
    }

    public void updateWingRotation() {
        if (!this.field_70122_E) {
            this.ticksUntilFlap = this.ticksUntilFlap == 0 ? 25 : --this.ticksUntilFlap;
        }
        this.prevWingRotation = this.wingRotation;
        this.prevDestPos = this.destPos;
        this.destPos = (float)((double)this.destPos + 0.2);
        this.destPos = FrostSpiritEntity.minMax(0.01f, 1.0f, this.destPos);
        this.wingRotation += 1.233f;
    }

    public static float minMax(float min, float max, float value) {
        return Math.min(max, Math.max(min, value));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextFloat() < 0.5f) {
            this.spawnParticles();
        }
        this.updateWingRotation();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        double offset = 0.2;
        double x = LogicUtil.plusOrMinus(this.func_226277_ct_(), offset, this.field_70146_Z);
        double y = LogicUtil.plusOrMinus(this.func_226278_cu_(), offset, this.field_70146_Z);
        double z = LogicUtil.plusOrMinus(this.func_226281_cx_(), offset, this.field_70146_Z);
        double motion = 0.025;
        double dx = LogicUtil.plusOrMinus(motion, this.field_70146_Z);
        double dy = LogicUtil.plusOrMinus(motion, this.field_70146_Z);
        double dz = LogicUtil.plusOrMinus(motion, this.field_70146_Z);
        this.field_70170_p.func_195594_a((IParticleData)StarFlareParticle.dyeToRGB(DyeColor.WHITE), x, y, z, dx, dy, dz);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70173_aa < 7) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }
}

