/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.ai;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;

public class NonCreatureAttackGoal
extends Goal {
    protected final MobEntity mob;
    protected int attackTick;
    private final double speedTowardsTarget;
    private final boolean longMemory;
    private Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    protected final int attackInterval = 20;
    private long lastCanUseCheck;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;

    public NonCreatureAttackGoal(MobEntity creature, double speedIn, boolean useLongMemory) {
        this.mob = creature;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        long i = this.mob.field_70170_p.func_82737_E();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.mob.func_70638_az();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.func_70089_S()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.path = this.mob.func_70661_as().func_75494_a((Entity)livingentity, 0);
                this.delayCounter = 4 + this.mob.func_70681_au().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.mob.func_70661_as().func_75494_a((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.mob.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_174813_aQ().field_72338_b, livingentity.func_226281_cx_());
    }

    public boolean func_75253_b() {
        LivingEntity livingentity = this.mob.func_70638_az();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.func_70089_S()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.mob.func_70661_as().func_75500_f();
        }
        if (!this.mob.func_213389_a(livingentity.func_233580_cy_())) {
            return false;
        }
        return !(livingentity instanceof PlayerEntity) || !livingentity.func_175149_v() && !((PlayerEntity)livingentity).func_184812_l_();
    }

    public void func_75249_e() {
        this.mob.func_70661_as().func_75484_a(this.path, this.speedTowardsTarget);
        this.mob.func_213395_q(true);
        this.delayCounter = 0;
    }

    public void func_75251_c() {
        LivingEntity livingentity = this.mob.func_70638_az();
        if (!EntityPredicates.field_188444_d.test(livingentity)) {
            this.mob.func_70624_b((LivingEntity)null);
        }
        this.mob.func_213395_q(false);
        this.mob.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        LivingEntity livingentity = this.mob.func_70638_az();
        this.mob.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
        double d0 = this.mob.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_174813_aQ().field_72338_b, livingentity.func_226281_cx_());
        --this.delayCounter;
        if ((this.longMemory || this.mob.func_70635_at().func_75522_a((Entity)livingentity)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingentity.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.mob.func_70681_au().nextFloat() < 0.05f)) {
            this.targetX = livingentity.func_226277_ct_();
            this.targetY = livingentity.func_174813_aQ().field_72338_b;
            this.targetZ = livingentity.func_226281_cx_();
            this.delayCounter = 4 + this.mob.func_70681_au().nextInt(7);
            if (this.canPenalize) {
                PathPoint finalPathPoint;
                this.delayCounter += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.mob.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.mob.func_70661_as().func_75505_d().func_75870_c()) != null && livingentity.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.delayCounter += 10;
            } else if (d0 > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.mob.func_70661_as().func_75497_a((Entity)livingentity, this.speedTowardsTarget)) {
                this.delayCounter += 15;
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        this.checkAndPerformAttack(livingentity, d0);
    }

    protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
        double d0 = this.getAttackReachSqr(enemy);
        if (distToEnemySqr <= d0 && this.attackTick <= 0) {
            this.attackTick = 20;
            this.mob.func_184609_a(Hand.MAIN_HAND);
            this.mob.func_70652_k((Entity)enemy);
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.mob.func_213311_cf() * 2.0f * this.mob.func_213311_cf() * 2.0f + attackTarget.func_213311_cf();
    }
}

