/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.ai;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.registries.SkiesVillagers;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class NightwatcherRobGoal
extends Goal {
    private final VillagerEntity villager;
    private final double speed;
    private VillagerEntity targetVillager;
    private int taskID = 0;
    private Vector3d awayVec = null;
    private List<UUID> robbedVilagers = Lists.newArrayList();
    private int robbingDelay = 0;

    public NightwatcherRobGoal(VillagerEntity creatureIn, double speedIn) {
        this.speed = speedIn;
        this.villager = creatureIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void func_75249_e() {
        VillagerEntity target;
        AxisAlignedBB radiusCheck = new AxisAlignedBB(this.villager.func_233580_cy_()).func_72314_b(35.0, 5.0, 35.0);
        List entityList = this.villager.field_70170_p.func_175674_a((Entity)this.villager, radiusCheck, entity -> entity instanceof VillagerEntity && ((VillagerEntity)entity).func_70608_bn());
        if (!entityList.isEmpty() && this.robbingDelay <= 0 && !this.robbedVilagers.contains((target = (VillagerEntity)entityList.get(this.villager.field_70170_p.field_73012_v.nextInt(entityList.size()))).func_110124_au())) {
            this.targetVillager = target;
        }
    }

    public void func_75246_d() {
        if (this.robbingDelay > 0) {
            --this.robbingDelay;
        }
        if (this.villager.field_70170_p.func_72935_r() && !this.robbedVilagers.isEmpty()) {
            this.robbedVilagers.clear();
        }
        if (this.targetVillager != null && !this.targetVillager.func_70089_S()) {
            this.targetVillager = null;
            this.awayVec = null;
            this.taskID = 0;
        }
        if (this.targetVillager != null && this.targetVillager.func_70608_bn()) {
            if (this.taskID <= 0) {
                double distance = EntityUtil.getDistanceToPos((Vector3i)this.villager.func_233580_cy_(), (Vector3i)this.targetVillager.func_233580_cy_());
                if (distance < 1.0) {
                    this.robbedVilagers.add(this.targetVillager.func_110124_au());
                    this.villager.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
                    this.taskID = 1;
                }
                if (this.taskID <= 0) {
                    if (distance < 3.0) {
                        this.villager.func_70605_aq().func_75642_a(this.targetVillager.func_226277_ct_(), this.targetVillager.func_226278_cu_(), this.targetVillager.func_226281_cx_(), this.speed);
                    } else {
                        this.villager.func_70661_as().func_75497_a((Entity)this.targetVillager, this.speed);
                    }
                    this.villager.func_70671_ap().func_75651_a((Entity)this.targetVillager, 40.0f, 40.0f);
                }
            } else if (this.taskID == 1) {
                if (this.awayVec == null) {
                    this.awayVec = this.villager.func_213375_cj().func_218207_c(MemoryModuleType.field_220942_c) != null && this.villager.func_213375_cj().func_218207_c(MemoryModuleType.field_220942_c).isPresent() ? Vector3d.func_237489_a_((Vector3i)((GlobalPos)this.villager.func_213375_cj().func_218207_c(MemoryModuleType.field_220942_c).get()).func_218180_b()) : RandomPositionGenerator.func_75461_b((CreatureEntity)this.villager, (int)20, (int)7, (Vector3d)this.targetVillager.func_213303_ch());
                } else {
                    BlockPos blockPos = new BlockPos(this.awayVec);
                    if (EntityUtil.getDistanceToPos((Vector3i)this.villager.func_233580_cy_(), (Vector3i)blockPos) > 1.0f) {
                        this.villager.func_70661_as().func_75492_a(this.awayVec.field_72450_a, this.awayVec.field_72448_b, this.awayVec.field_72449_c, (double)0.7f);
                    } else {
                        this.targetVillager = null;
                        this.awayVec = null;
                        this.taskID = 0;
                    }
                }
            }
        }
    }

    public boolean func_75250_a() {
        if (this.villager.func_213700_eh().func_221130_b() != SkiesVillagers.NIGHTWATCHER) {
            return false;
        }
        return EntityUtil.isVillagerWorkTime(this.villager);
    }

    public boolean func_75253_b() {
        return this.targetVillager != null && this.taskID < 2 && EntityUtil.isVillagerWorkTime(this.villager) && this.villager.func_213700_eh().func_221130_b() == SkiesVillagers.NIGHTWATCHER && super.func_75253_b();
    }
}

