/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesConfiguredCarvers;
import com.legacy.blue_skies.registries.SkiesConfiguredFeatures;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageBiomes;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.data.BiomeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public class SkiesBiomeProv
extends BiomeProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = BlueSkies.LOGGER;
    protected static Map<ResourceLocation, Biome> BIOMES = new HashMap<ResourceLocation, Biome>();
    private final DataGenerator generator;

    public SkiesBiomeProv(DataGenerator generator) {
        super(generator);
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) {
        Makers.init();
        LOGGER.info("Starting Blue Skies biome gen");
        Path path = this.generator.func_200391_b();
        for (Map.Entry<ResourceLocation, Biome> entry : BIOMES.entrySet()) {
            Path path1 = SkiesBiomeProv.createPath(path, entry.getKey());
            Biome biome = entry.getValue();
            Function function = JsonOps.INSTANCE.withEncoder((Encoder)Biome.field_235051_b_);
            try {
                Optional optional = ((DataResult)function.apply(() -> biome)).result();
                if (optional.isPresent()) {
                    IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)((JsonElement)optional.get()), (Path)path1);
                    continue;
                }
                LOGGER.error("Couldn't serialize biome {}", (Object)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save biome {}", (Object)path1, (Object)ioexception);
            }
        }
    }

    private static Path createPath(Path pathIn, ResourceLocation locationIn) {
        Path path = pathIn.resolve("data/" + locationIn.func_110624_b() + "/worldgen/biome/" + locationIn.func_110623_a() + ".json");
        System.out.println(path.toString());
        return path;
    }

    public static class Makers {
        protected static final int BRIGHT_FOLIAGE_COLOR = 7059637;
        protected static final int DAWN_FOLIAGE_COLOR = 12485859;

        public static void init() {
            for (Biome b : ForgeRegistries.BIOMES) {
                if (b.getRegistryName() == null || !b.getRegistryName().func_110624_b().equals("blue_skies")) continue;
                BIOMES.put(b.getRegistryName(), b);
            }
        }

        public static Biome calmingSkies() {
            int grassColor = 0xFFFFFF;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 9684223;
            float depth = 1.3f;
            float scale = 0.2f;
            float temp = 0.3f;
            float downfall = 0.0f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.STARDUST_RAM, 8, 2, 4));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.AZULFO, 6, 4, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.DIOPHYDE_PROWLER, 1, 1, 2));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.TURQUOISE_GRASS_SURFACE_BUILDER);
            builder.func_242516_a(SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructureFeature());
            builder.func_242516_a(SkiesStructures.BLUE_SKIES_VILLAGE.getStructureFeature(SkiesVillageBiomes.CALMING_SKIES.toString()));
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CALMING_SKIES_BLUEBRIGHT_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CALMING_SKIES_STARLIT_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_NOISE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.POLAR_POSY_3);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRITTLEBUSH_3);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CALMING_SKIES_CAVE_DRIPSTONE);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addBrightLakes(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addBrightFlowers(builder);
            SkiesConfiguredFeatures.addFalsiteOre(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome brightlands() {
            int grassColor = 14016767;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 9684223;
            float depth = 1.8f;
            float scale = 0.5f;
            float temp = 0.0f;
            float downfall = 0.8f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.STARDUST_RAM, 8, 2, 4));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.REINDEER, 4, 2, 3));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.AZULFO, 6, 4, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.CRYNOCEROUS, 1, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.DIOPHYDE_PROWLER, 1, 1, 2));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.TURQUOISE_GRASS_SURFACE_BUILDER);
            builder.func_242516_a(SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructureFeature());
            builder.func_242516_a(SkiesStructures.BLUE_SKIES_VILLAGE.getStructureFeature(SkiesVillageBiomes.BRIGHTLANDS.toString()));
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRIGHTLANDS_FALLEN_LOG);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRIGHTLANDS_STARLIT_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SNOWBLOOM_2);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CHILLWEED_3);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_3);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.BRIGHTLANDS_CAVE_GRASS);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.BRIGHTLANDS_GIANT_CAVE_ICICLE);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.BRIGHTLANDS_CAVE_WALL);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addEmeraldOre(builder, true);
            SkiesConfiguredFeatures.addBrightLakes(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addBrightFlowers(builder);
            SkiesConfiguredFeatures.addSprings(builder, false);
            return new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome slushlands() {
            int grassColor = 12119807;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 7252691;
            float depth = -0.2f;
            float scale = 0.1f;
            float temp = 0.5f;
            float downfall = 0.0f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.STARDUST_RAM, 8, 2, 4));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.AZULFO, 6, 4, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.SHRUMPTY, 2, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.COARSE_TURQUOISE_SURFACE_BUILDER);
            builder.func_242516_a(SkiesStructures.BUNKER.getStructureFeature());
            builder.func_242516_a(SkiesStructures.BLUE_SKIES_VILLAGE.getStructureFeature(SkiesVillageBiomes.SLUSHLANDS.toString()));
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SLUSHLANDS_LARGE_SNOWCAP_MUSHROOM);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SLUSHLANDS_SNOWCAP_MUSHROOM);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SLUSHLANDS_CHILLED_LILY);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.PATCHY_SNOW);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TALL_TURQUOISE_GRASS_NOISE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRITTLEBUSH_5);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SNOWCAP_PINHEAD_8);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_5);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.SLUSHLANDS_CAVE_WALL);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SLUSHLANDS_CAVE_BLUEBRIGHT_VINE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SLUSHLANDS_CAVE_PINHEAD);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addFalsiteOre(builder);
            SkiesConfiguredFeatures.addVentiumOre(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome frostbittenForest(boolean isClearing) {
            int grassColor = 13288447;
            int foliageColor = 7059637;
            int waterColor = 6583020;
            int waterFogColor = 6583020;
            int skyColor = 6654717;
            float depth = 1.1f;
            float scale = 0.0f;
            float temp = 0.0f;
            float downfall = 0.0f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.SNOW_OWL, 6, 2, 2));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.DIOPHYDE_PROWLER, 1, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.TURQUOISE_GRASS_SURFACE_BUILDER);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.FROSTBITTEN_FOREST_BUSH);
            if (isClearing) {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.FROSTBITTEN_FOREST_SMALL_FROSTBRIGHT_TREE);
            } else {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.FROSTBITTEN_FOREST_FROSTBRIGHT_TREE);
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.FROSTBITTEN_FOREST_BLUEBRIGHT_TREE);
            }
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SNOWBLOOM_2);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRITTLEBUSH_5);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CHILLWEED_5);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_5);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.FROSTBITTEN_FOREST_CAVE_FROSTBRIGHT_VINE);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.FROSTBITTEN_FOREST_CAVE_GRASS);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.FROSTBITTEN_FOREST_CAVE_WALL);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addBrightLakes(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addBrightFlowers(builder);
            SkiesConfiguredFeatures.addBrightDoubleGrass(builder);
            SkiesConfiguredFeatures.addVentiumOre(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome peekingOcean(boolean isDeep, boolean isBrumbleForest) {
            int grassColor = 0xFFFFFF;
            int foliageColor = 7059637;
            int waterColor = isDeep ? 4672964 : 6583020;
            int waterFogColor = isDeep ? 4672964 : 6583020;
            int skyColor = 9684223;
            float depth = isDeep ? -1.8f : -1.0f;
            float scale = 0.1f;
            float temp = 0.2f;
            float downfall = 0.4f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            double fishCost = 0.05;
            double fishBudget = 1.0;
            spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_203780_j, 15, 3, 6));
            spawns.func_242573_a(EntityType.field_203780_j, fishCost, fishBudget);
            spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(SkiesEntityTypes.JELLY_DRIFTER, 5, 1, 3));
            spawns.func_242573_a(SkiesEntityTypes.JELLY_DRIFTER, fishCost, fishBudget);
            spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(SkiesEntityTypes.GRITTLE_FLATFISH, 5, 2, 3));
            spawns.func_242573_a(SkiesEntityTypes.GRITTLE_FLATFISH, fishCost, fishBudget);
            spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(SkiesEntityTypes.MUNICIPAL_MONKFISH, 15, 3, 6));
            spawns.func_242573_a(SkiesEntityTypes.MUNICIPAL_MONKFISH, fishCost, fishBudget);
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 25, 2, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.WHISTLESHELL_CRAB, 20, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.SECLAM, 10, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.TURQUOISE_GRASS_SURFACE_BUILDER);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_5);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.PEEKING_OCEAN_BRUMBLE);
            if (isBrumbleForest) {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRUMBLE_FOREST_BRUMBLE_VINE);
            } else {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.PEEKING_OCEAN_SEA_MOSS);
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.PEEKING_OCEAN_BRUMBLE_VINE);
                builder.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SkiesConfiguredFeatures.PEEKING_OCEAN_SPIKE);
            }
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.PEEKING_OCEAN_CAVE_MOSS_CARPET);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.PEEKING_OCEAN_CAVE_DENSE_MOSS_WALL);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.PEEKING_OCEAN_CAVE_MOSS_WALL);
            SkiesConfiguredFeatures.addFalsiteOre(builder);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredCarvers.addOceanCarvers(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addVentiumOre(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome middayShore() {
            int grassColor = 12373759;
            int foliageColor = 7059637;
            int waterColor = 6583020;
            int waterFogColor = 6583020;
            int skyColor = 10994416;
            float depth = 0.0f;
            float scale = 0.025f;
            float temp = 0.3f;
            float downfall = 0.4f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.WHISTLESHELL_CRAB, 20, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.MIDNIGHT_SAND_SURFACE_BUILDER);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_5);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.MIDDAY_BAYHOP_6);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addFalsiteOre(builder);
            SkiesConfiguredFeatures.addVentiumOre(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome snowCoveredPines() {
            int grassColor = 14016767;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 9684223;
            float depth = 1.5f;
            float scale = 0.1f;
            float temp = 0.0f;
            float downfall = 0.8f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.STARDUST_RAM, 8, 2, 4));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.REINDEER, 4, 2, 3));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.AZULFO, 6, 4, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.CRYNOCEROUS, 1, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.DIOPHYDE_PROWLER, 1, 1, 2));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.TURQUOISE_GRASS_SURFACE_BUILDER);
            builder.func_242516_a(SkiesStructures.NATURE_DUNGEON.getStructureFeature());
            builder.func_242516_a(SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructureFeature());
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SNOW_COVERED_PINES_STARLIT_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SNOWBLOOM_2);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRITTLEBUSH_3);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CHILLWEED_3);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_2);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SNOW_COVERED_PINES_CAVE_STARLIT_VINE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SNOW_COVERED_PINES_WALL_MOONSTONE);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.SNOW_COVERED_PINES_CAVE_WALL);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addBrightLakes(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addBrightFlowers(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome briskMeadow() {
            int grassColor = 0xFFFFFF;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 9684223;
            float depth = 1.2f;
            float scale = 0.0f;
            float temp = 0.3f;
            float downfall = 0.0f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.STARDUST_RAM, 5, 2, 4));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.AZULFO, 8, 4, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.DIOPHYDE_PROWLER, 1, 1, 2));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.TURQUOISE_GRASS_SURFACE_BUILDER);
            builder.func_242516_a(SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructureFeature());
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRISK_MEADOW_BLUEBRIGHT_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRISK_MEADOW_BUSH);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRISK_MEADOW_FLOWER);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BREWBERRY_3);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_8);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.BRISK_MEADOW_CAVE_WALL_STONE_RIMESTONE);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.BRISK_MEADOW_CAVE_WALL_RIMESTONE_STONE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BRISK_MEADOW_CAVE_FROSE);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addBrightLakes(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addFalsiteOre(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235244_a_(new ParticleEffectAmbience((IParticleData)SkiesParticles.BRISK_PETAL, 0.012f)).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome polarHighland() {
            int grassColor = 11657944;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 7252691;
            float depth = 1.4f;
            float scale = 0.1f;
            float temp = 0.3f;
            float downfall = 0.0f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.STARDUST_RAM, 5, 2, 4));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.AZULFO, 8, 4, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.DIOPHYDE_PROWLER, 2, 1, 2));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.POLARGEIST, 1, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.COARSE_TURQUOISE_SURFACE_BUILDER);
            builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, SkiesConfiguredFeatures.POLAR_HIGHLAND_ROCK);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.POLAR_HIGHLAND_BLUEBRIGHT_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_NOISE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.POLAR_POSY_6);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.TURQUOISE_GRASS_5);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.POLAR_HIGHLAND_CAVE_WALL_TARATITE);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.POLAR_HIGHLAND_CAVE_GRASS);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.POLAR_HIGHLAND_CAVE_POSY);
            SkiesConfiguredFeatures.addDefaultBrightOres(builder);
            SkiesConfiguredFeatures.addBrightLakes(builder);
            SkiesConfiguredFeatures.addFreezeTopLayer(builder);
            SkiesConfiguredFeatures.addGeneralBrightFeatures(builder);
            SkiesConfiguredFeatures.addBrightFlowers(builder);
            SkiesConfiguredFeatures.addFalsiteOre(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome unorthodoxValley() {
            int grassColor = 14843647;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 9471171;
            float depth = 0.5f;
            float scale = 1.8f;
            float temp = 1.3f;
            float downfall = 0.3f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.COSMIC_FOX, 6, 1, 2));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.SHADE_MONITOR, 8, 2, 3));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.EMBERBACK, 7, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.LUNAR_GRASS_SURFACE_BUILDER);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.UNORTHODOX_VALLEY_DUSK_LUNAR_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.UNORTHODOX_VALLEY_CRESCENT_FRUIT_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.NIGHTCRESS_2);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_5);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.UNORTHODOX_VALLEY_CAVE_DRIPSTONE);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredFeatures.addEmeraldOre(builder, false);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addDawnLakes(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addSprings(builder, true);
            SkiesConfiguredFeatures.addDawnFlowers(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome shadedWoodlands() {
            int grassColor = 13151691;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 0;
            float depth = 0.1f;
            float scale = 0.1f;
            float temp = 1.1f;
            float downfall = 0.3f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.AMBIENT, new MobSpawnInfo.Spawners(SkiesEntityTypes.FIREFLY, 10, 3, 5));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.COSMIC_FOX, 5, 4, 4));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.SHADE_MONITOR, 8, 2, 3));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.NYCTOFLY, 5, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.LUNAR_GRASS_SURFACE_BUILDER);
            builder.func_242516_a(SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructureFeature());
            builder.func_242516_a(SkiesStructures.BLUE_SKIES_VILLAGE.getStructureFeature(SkiesVillageBiomes.SHADED_WOODLANDS.toString()));
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SHADED_WOODLANDS_LARGE_DUSK_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_MUCKWEED_NOISE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.BANEFUL_MUSHROOM_5);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_MUCKWEED_20);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SHADED_WOODLANDS_FLOWER);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SHADED_WOODLANDS_CAVE_DUSK_VINE);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.SHADED_WOODLANDS_CAVE_WALL);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addDawnLakes(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addDawnDoubleGrass(builder);
            SkiesConfiguredFeatures.addSprings(builder, true);
            return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235241_a_(SkiesSounds.AMBIENT_SHADED_WOODLANDS_LOOP).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome crystalDunes(boolean hasSpikes) {
            int grassColor = 0xFFA3FF;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 15784896;
            float depth = 0.125f;
            float scale = 0.05f;
            float temp = 1.7f;
            float downfall = 0.3f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.CRYSTAL_CAMEL, 5, 2, 3));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.SHADE_MONITOR, 2, 2, 3));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.EMBERBACK, 7, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.CRYSTAL_SAND_SURFACE_BUILDER);
            builder.func_242516_a(SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructureFeature());
            if (!hasSpikes) {
                builder.func_242516_a(SkiesStructures.BLUE_SKIES_VILLAGE.getStructureFeature(SkiesVillageBiomes.CRYSTAL_DUNES.toString()));
            }
            builder.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SkiesConfiguredFeatures.CRYSTAL_DUNES_MOONSTONE_SPIKE);
            if (hasSpikes) {
                builder.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SkiesConfiguredFeatures.CRYSTAL_DUNES_LARGE_MOONSTONE_SPIKE);
            }
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LIGHT_CRYSTALLIZED_GRASS_2);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CRYSTAL_FLOWER_2);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_5);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRYSTAL_DUNES_CAVE_MOONSTONE_CRYSTAL);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRYSTAL_DUNES_CAVE_GRASS);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CRYSTAL_DUNES_CAVE_WALL_MOONSTONE);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addDawnLakes(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addHorizoniteOre(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome risingCreek() {
            int grassColor = 14843647;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 9471171;
            float depth = -0.5f;
            float scale = 0.0f;
            float temp = 1.3f;
            float downfall = 0.3f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            double fishCost = 0.05;
            double fishBudget = 1.0;
            spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_203778_ae, 5, 1, 5));
            spawns.func_242573_a(EntityType.field_203778_ae, fishCost, fishBudget);
            spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(SkiesEntityTypes.CHARSCALE_MOKI, 5, 3, 5));
            spawns.func_242573_a(SkiesEntityTypes.CHARSCALE_MOKI, fishCost, fishBudget);
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.INFESTED_SWARMER, 5, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.COARSE_LUNAR_SURFACE_BUILDER);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.RISING_CREEK_MOONLIT_WATER_LILY);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.MUCKWEED_5);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addDawnFlowers(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome moonlitReservoir() {
            int grassColor = 9269656;
            int foliageColor = 12485859;
            int waterColor = 4354427;
            int waterFogColor = 4354427;
            int skyColor = 8687555;
            float depth = -0.225f;
            float scale = 0.05f;
            float temp = 1.3f;
            float downfall = 0.3f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.CROGRE, 8, 1, 2));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.SHADE_MONITOR, 4, 1, 2));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.NYCTOFLY, 5, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            double fishCost = 0.05;
            double fishBudget = 1.0;
            spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_203778_ae, 5, 1, 5));
            spawns.func_242573_a(EntityType.field_203778_ae, fishCost, fishBudget);
            spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(SkiesEntityTypes.CHARSCALE_MOKI, 5, 3, 5));
            spawns.func_242573_a(SkiesEntityTypes.CHARSCALE_MOKI, fishCost, fishBudget);
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.MOONLIT_RESERVOIR_SURFACE_BUILDER);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.MOONLIT_RESERVOIR_DUSK_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.MOONLIT_RESERVOIR_GLIMMER_REEDS);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.MOONLIT_RESERVOIR_MOONLIT_WATER_LILY);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUCENTROOT_2);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_MUCKWEED_NOISE);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.MOONLIT_RESERVOIR_CAVE_GRASS);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.MOONLIT_RESERVOIR_CAVE_WALL);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addDawnFlowers(builder);
            SkiesConfiguredFeatures.addDawnDoubleGrass(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235241_a_(SkiesSounds.AMBIENT_MOONLIT_RESERVOIR_LOOP).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome crystalRoughs() {
            int grassColor = 13155070;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 14350335;
            float depth = 0.125f;
            float scale = 0.05f;
            float temp = 1.7f;
            float downfall = 0.0f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.CRYSTAL_CAMEL, 2, 2, 3));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.SHADE_MONITOR, 8, 1, 2));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.EMBERBACK, 7, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.CRYSTAL_ROUGHS_SURFACE_BUILDER);
            builder.func_242516_a(SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructureFeature());
            builder.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SkiesConfiguredFeatures.CRYSTAL_ROUGHS_LUNAR_TREE);
            builder.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SkiesConfiguredFeatures.CRYSTAL_ROUGHS_CRYSTALIZED_TREE);
            builder.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SkiesConfiguredFeatures.CRYSTAL_ROUGHS_SHORT_MOONSTONE_SPIKE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CRYSTAL_FLOWER_2);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_5);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CRYSTALLIZED_GRASS_5);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRYSTAL_ROUGHS_CAVE_GRASS);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addDawnLakes(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addHorizoniteOre(builder);
            SkiesConfiguredFeatures.addSprings(builder, true);
            return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome sunsetMapleForest() {
            int grassColor = 15829434;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 15770516;
            float depth = 0.1f;
            float scale = 0.1f;
            float temp = 1.5f;
            float downfall = 0.3f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.COSMIC_FOX, 5, 1, 2));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.SHADE_MONITOR, 8, 2, 3));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.SLIV, 2, 2, 3));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.EMBERBACK, 7, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.LUNAR_GRASS_SURFACE_BUILDER);
            builder.func_242516_a(SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructureFeature());
            builder.func_242516_a(SkiesStructures.POISON_DUNGEON.getStructureFeature());
            builder.func_242516_a(SkiesStructures.BLUE_SKIES_VILLAGE.getStructureFeature(SkiesVillageBiomes.SUNSET_MAPLE_FOREST.toString()));
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SUNSET_MAPLE_FOREST_MAPLE_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_7);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.FLARE_FLORET_BLAZE_BUD_LUCENTROOT_4);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SUNSET_MAPLE_FOREST_CAVE_WALL_SUNSTONE);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.SUNSET_MAPLE_FOREST_CAVE_MAGMA);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SUNSET_MAPLE_FOREST_CAVE_MAPLE_VINE);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addDawnLakes(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addHorizoniteOre(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome searingGrassland() {
            int grassColor = 15829396;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 15766676;
            float depth = 0.1f;
            float scale = 0.0f;
            float temp = 1.6f;
            float downfall = 0.1f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.COSMIC_FOX, 5, 1, 2));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.SHADE_MONITOR, 8, 2, 3));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.SLIV, 2, 2, 3));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.EMBERBACK, 7, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.LUNAR_GRASS_SURFACE_BUILDER);
            builder.func_242516_a(SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructureFeature());
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SEARING_GRASSLAND_BUSH);
            builder.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, SkiesConfiguredFeatures.SEARING_GRASSLAND_ROCK);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.FLARE_FLORET_BLAZE_BUD_LUCENTROOT_5);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_7);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.SEARING_GRASSLAND_CAVE_WALL_SUNSTONE);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.SEARING_GRASSLAND_CAVE_MAGMA);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.SEARING_GRASSLAND_CAVE_WALL);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addDawnLakes(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            SkiesConfiguredFeatures.addHorizoniteOre(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235244_a_(new ParticleEffectAmbience((IParticleData)SkiesParticles.SEARING_SMOKE, 0.01f)).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        public static Biome crescentOrchard(boolean isLake) {
            int grassColor = 12025574;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 15774612;
            float depth = isLake ? -0.6f : 0.1f;
            float scale = isLake ? 0.0f : 0.1f;
            float temp = 1.3f;
            float downfall = 0.3f;
            MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
            if (isLake) {
                double fishCost = 0.05;
                double fishBudget = 1.0;
                spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(SkiesEntityTypes.CHARSCALE_MOKI, 5, 3, 5));
                spawns.func_242573_a(SkiesEntityTypes.CHARSCALE_MOKI, fishCost, fishBudget);
            } else {
                spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.COSMIC_FOX, 5, 1, 2));
                spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(SkiesEntityTypes.SHADE_MONITOR, 8, 2, 3));
            }
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder().func_242517_a(SkiesBiomes.SurfaceBuilders.LUNAR_GRASS_SURFACE_BUILDER);
            if (!isLake) {
                builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CRESCENT_ORCHARD_CRESCENT_FRUIT_TREE);
            }
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.CRESCENT_ORCHARD_CRESCENT_FRUIT_TREE);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.NIGHTCRESS_2);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SkiesConfiguredFeatures.LUNAR_GRASS_4);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_GRASS);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_DIRT);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_BLOOM);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_NIGHTCRESS);
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, SkiesConfiguredFeatures.CRESCENT_ORCHARD_CAVE_LUCENTROOT);
            SkiesConfiguredFeatures.addDawnFlowers(builder);
            SkiesConfiguredFeatures.addDefaultDawnOres(builder);
            SkiesConfiguredCarvers.addDawnCarvers(builder);
            SkiesConfiguredFeatures.addDawnLakes(builder);
            SkiesConfiguredFeatures.addGeneralDawnFeatures(builder);
            return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.NONE).func_205421_a(depth).func_205420_b(scale).func_205414_c(temp).func_205417_d(downfall).func_235097_a_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).func_235238_a_()).func_242458_a(spawns.func_242577_b()).func_242457_a(builder.func_242508_a()).func_242455_a();
        }

        protected static BiomeAmbience.Builder createAmbienceBuilder(int grassColor, int foliageColor, int waterColor, int waterFogColor, int skyColor) {
            return new BiomeAmbience.Builder().func_235239_a_(12638463).func_242539_d(Makers.calcDefaultSkyColor(0.3f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_242541_f(grassColor).func_242540_e(foliageColor).func_235246_b_(waterColor).func_235248_c_(waterFogColor).func_242539_d(skyColor);
        }

        private static int calcDefaultSkyColor(float chance) {
            float thirdChance = chance / 3.0f;
            thirdChance = MathHelper.func_76131_a((float)thirdChance, (float)-1.0f, (float)1.0f);
            return MathHelper.func_181758_c((float)(0.62222224f - thirdChance * 0.05f), (float)(0.5f + thirdChance * 0.1f), (float)1.0f);
        }
    }
}

