/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.providers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.crafting.ToolRecipe;
import com.legacy.blue_skies.data.objects.SkiesItemTags;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesRecipes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.triggers.UsedAlchemyTableTrigger;
import com.legacy.blue_skies.triggers.UsedToolboxTrigger;
import com.legacy.blue_skies.util.StringUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.BlockPredicate;
import net.minecraft.advancements.criterion.ChangeDimensionTrigger;
import net.minecraft.advancements.criterion.ConsumeItemTrigger;
import net.minecraft.advancements.criterion.EnterBlockTrigger;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ImpossibleTrigger;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.KilledTrigger;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.advancements.criterion.PositionTrigger;
import net.minecraft.advancements.criterion.RightClickBlockWithItemTrigger;
import net.minecraft.advancements.criterion.SummonedEntityTrigger;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import org.apache.logging.log4j.Logger;

public class SkiesAdvancementProv
implements IDataProvider {
    private static final Logger LOGGER = BlueSkies.makeLogger(SkiesAdvancementProv.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final List<Consumer<Consumer<Advancement>>> advancements = ImmutableList.of((Object)new BlueSkiesAdvancements());

    public SkiesAdvancementProv(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> advancement = a -> {
            if (!set.add(a.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + a.func_192067_g());
            }
            Path path1 = SkiesAdvancementProv.getPath(path, a);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)a.func_192075_a().func_200273_b(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        for (Consumer<Consumer<Advancement>> adv : this.advancements) {
            adv.accept(advancement);
        }
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Blue Skies Advancements";
    }

    private class BlueSkiesAdvancements
    implements Consumer<Consumer<Advancement>> {
        private String section = "";

        private BlueSkiesAdvancements() {
        }

        @Override
        public void accept(Consumer<Advancement> consumer) {
            this.toolRecipes(consumer);
            Advancement root = this.builder((IItemProvider)SkiesItems.multi_portal_item, "root", BlueSkies.locate("textures/block/dungeon/blinding_stone.png"), FrameType.TASK, false, false, false).func_200270_a(IRequirementsStrategy.field_223215_b_).func_200275_a("enter_everbright", (ICriterionInstance)this.changeDim(SkiesDimensions.everbrightKey())).func_200275_a("enter_everdawn", (ICriterionInstance)this.changeDim(SkiesDimensions.everdawnKey())).func_203904_a(consumer, BlueSkies.find("root"));
            Advancement thinkingPortals = this.builder((IItemProvider)SkiesItems.zeal_lighter, "thinking_with_portals", FrameType.TASK, true, true, false).func_203905_a(root).func_200275_a("enter_everbright", (ICriterionInstance)this.changeDim(SkiesDimensions.everbrightKey())).func_200275_a("enter_everdawn", (ICriterionInstance)this.changeDim(SkiesDimensions.everdawnKey())).func_203904_a(consumer, BlueSkies.find("thinking_with_portals"));
            Advancement moonstoneShard = this.builder((IItemProvider)SkiesItems.moonstone_shard, "get_moonstone_shard", FrameType.TASK, true, true, false).func_203905_a(thinkingPortals).func_200275_a("obtain_moonstone_shard", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{SkiesItems.moonstone_shard})).func_203904_a(consumer, BlueSkies.find("get_moonstone_shard"));
            Advancement enterBlindingDungeon = this.enterAnyStructure(this.builder((IItemProvider)SkiesBlocks.bright_blinding_keystone, "enter_blinding_dungeon", FrameType.GOAL, true, true, false).func_203905_a(thinkingPortals).func_200270_a(IRequirementsStrategy.field_223215_b_), (List<Structure<?>>)ImmutableList.of((Object)SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure(), (Object)SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure())).func_203904_a(consumer, BlueSkies.find("enter_blinding_dungeon"));
            Advancement keys = this.builder((IItemProvider)SkiesItems.blinding_key, "keys", FrameType.TASK, true, true, false).func_203905_a(enterBlindingDungeon).func_200275_a("obtain_key", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{SkiesItems.blinding_key})).func_203904_a(consumer, BlueSkies.find("keys"));
            Advancement regrowth = this.builder((IItemProvider)SkiesBlocks.cherry_sapling, "regrowth", FrameType.TASK, true, true, false).func_203905_a(keys).func_200275_a("have_sapling", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{SkiesBlocks.cherry_sapling})).func_203904_a(consumer, BlueSkies.find("regrowth"));
            Advancement cherryPie = this.builder((IItemProvider)SkiesBlocks.cherry_pie, "blue_sky_pie", FrameType.GOAL, true, true, false).func_203905_a(regrowth).func_200275_a("have_pie", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{SkiesBlocks.cherry_pie})).func_203904_a(consumer, BlueSkies.find("blue_sky_pie"));
            this.setSection("everbright");
            Advancement enterBright = this.builder((IItemProvider)SkiesBlocks.everbright_portal, "enter", FrameType.TASK, true, true, false).func_203905_a(root).func_200275_a("enter_everbright", (ICriterionInstance)this.changeDim(SkiesDimensions.everbrightKey())).func_203904_a(consumer, BlueSkies.find("everbright/enter"));
            Advancement getWoodBright = this.haveAnyItem(this.builder((IItemProvider)SkiesBlocks.bluebright_log, "get_wood", FrameType.TASK, true, true, false).func_203905_a(enterBright).func_200270_a(IRequirementsStrategy.field_223215_b_), (List<IItemProvider>)ImmutableList.of((Object)SkiesBlocks.bluebright_log, (Object)SkiesBlocks.bluebright_wood, (Object)SkiesBlocks.starlit_log, (Object)SkiesBlocks.starlit_wood, (Object)SkiesBlocks.frostbright_log, (Object)SkiesBlocks.frostbright_wood)).func_203904_a(consumer, BlueSkies.find("everbright/get_wood"));
            Advancement useToolBox = this.builder((IItemProvider)SkiesBlocks.tool_box, "use_tool_box", FrameType.TASK, true, true, false).func_203905_a(getWoodBright).func_200275_a("use_tool_box", (ICriterionInstance)UsedToolboxTrigger.Instance.any()).func_203904_a(consumer, BlueSkies.find("everbright/use_tool_box"));
            Advancement useFalsiteInToolBox = this.builder((IItemProvider)SkiesItems.falsite_ingot, "use_falsite_in_tool_box", FrameType.TASK, true, true, false).func_203905_a(useToolBox).func_200275_a("use_tool_box", (ICriterionInstance)UsedToolboxTrigger.Instance.withModifier(SkiesItemTags.FALSITE)).func_203904_a(consumer, BlueSkies.find("everbright/use_falsite_in_tool_box"));
            Advancement killSummoner = this.builder((IItemProvider)SkiesItems.ethereal_arc, "kill_summoner", FrameType.CHALLENGE, true, true, false).func_203905_a(getWoodBright).func_200275_a("kill_summoner", (ICriterionInstance)KilledTrigger.Instance.func_203928_a((EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_203998_a(SkiesEntityTypes.SUMMONER))).func_203904_a(consumer, BlueSkies.find("everbright/kill_summoner"));
            Advancement summonGolem = this.builder((IItemProvider)SkiesItems.summoning_tome, "summon_golem", FrameType.TASK, true, true, false).func_203905_a(killSummoner).func_200275_a("summon_golem", (ICriterionInstance)SummonedEntityTrigger.Instance.func_203937_a((EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_203998_a(SkiesEntityTypes.ARTIFICIAL_GOLEM))).func_203904_a(consumer, BlueSkies.find("everbright/summon_artificial_golem"));
            Advancement regenBrewberry = this.builder((IItemProvider)SkiesItems.pink_brewberry, "regen_brewberry", FrameType.GOAL, true, true, false).func_203905_a(regrowth).func_200275_a("have_pink_brewberry", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)SkiesItems.pink_brewberry)).func_203904_a(consumer, BlueSkies.find("everbright/regen_brewberry"));
            Advancement enterNatureDungeon = this.builder((IItemProvider)SkiesBlocks.nature_keystone, "enter_nature_dungeon", FrameType.GOAL, true, true, false).func_203905_a(killSummoner).func_200275_a("entered_dungeon", (ICriterionInstance)this.enterStructure(SkiesStructures.NATURE_DUNGEON.getStructure())).func_203904_a(consumer, BlueSkies.find("everbright/enter_nature_dungeon"));
            Advancement killCrusher = this.builder((IItemProvider)SkiesItems.nature_arc, "kill_starlit_crusher", FrameType.CHALLENGE, true, true, false).func_203905_a(enterNatureDungeon).func_200275_a("kill_starlit_crusher", (ICriterionInstance)KilledTrigger.Instance.func_203928_a((EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_203998_a(SkiesEntityTypes.STARLIT_CRUSHER))).func_203904_a(consumer, BlueSkies.find("everbright/kill_starlit_crusher"));
            this.setSection("everdawn");
            Advancement enterDawn = this.builder((IItemProvider)SkiesBlocks.everdawn_portal, "enter", FrameType.TASK, true, true, false).func_203905_a(root).func_200275_a("enter_everdawn", (ICriterionInstance)this.changeDim(SkiesDimensions.everdawnKey())).func_203904_a(consumer, BlueSkies.find("everdawn/enter"));
            Advancement getWoodDawn = this.haveAnyItem(this.builder((IItemProvider)SkiesBlocks.lunar_log, "get_wood", FrameType.TASK, true, true, false).func_203905_a(enterDawn).func_200270_a(IRequirementsStrategy.field_223215_b_), (List<IItemProvider>)ImmutableList.of((Object)SkiesBlocks.lunar_log, (Object)SkiesBlocks.lunar_wood, (Object)SkiesBlocks.dusk_log, (Object)SkiesBlocks.dusk_wood, (Object)SkiesBlocks.maple_log, (Object)SkiesBlocks.maple_wood)).func_203904_a(consumer, BlueSkies.find("everdawn/get_wood"));
            Advancement poisonShroom = this.builder((IItemProvider)SkiesBlocks.baneful_mushroom, "poison_shroom", FrameType.TASK, true, true, false).func_203905_a(enterDawn).func_200275_a("touch_shroom", (ICriterionInstance)EnterBlockTrigger.Instance.func_203920_a((Block)SkiesBlocks.baneful_mushroom)).func_203904_a(consumer, BlueSkies.find("everdawn/poison_shroom"));
            Advancement killAlchemist = this.builder((IItemProvider)SkiesItems.dusk_arc, "kill_alchemist", FrameType.CHALLENGE, true, true, false).func_203905_a(getWoodDawn).func_200275_a("kill_alchemist", (ICriterionInstance)KilledTrigger.Instance.func_203928_a((EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_203998_a(SkiesEntityTypes.ALCHEMIST))).func_203904_a(consumer, BlueSkies.find("everdawn/kill_alchemist"));
            Advancement useAlchemyTable = this.builder((IItemProvider)SkiesBlocks.alchemy_table, "use_alchemy_table", FrameType.TASK, true, true, false).func_203905_a(killAlchemist).func_200275_a("use_alchemy_table", (ICriterionInstance)UsedAlchemyTableTrigger.Instance.any()).func_203904_a(consumer, BlueSkies.find("everdawn/use_alchemy_table"));
            Advancement enterPoisonDungeon = this.builder((IItemProvider)SkiesBlocks.poison_keystone, "enter_poison_dungeon", FrameType.GOAL, true, true, false).func_203905_a(killAlchemist).func_200275_a("entered_dungeon", (ICriterionInstance)this.enterStructure(SkiesStructures.POISON_DUNGEON.getStructure())).func_203904_a(consumer, BlueSkies.find("everdawn/enter_poison_dungeon"));
            Advancement killArachnarch = this.builder((IItemProvider)SkiesItems.poison_arc, "kill_arachnarch", FrameType.CHALLENGE, true, true, false).func_203905_a(enterPoisonDungeon).func_200275_a("kill_arachnarch", (ICriterionInstance)KilledTrigger.Instance.func_203928_a((EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_203998_a(SkiesEntityTypes.ARACHNARCH))).func_203904_a(consumer, BlueSkies.find("everdawn/kill_arachnarch"));
            Advancement different = this.builder((IItemProvider)SkiesItems.different_sword, "think_different", FrameType.GOAL, true, true, false).func_203905_a(killArachnarch).func_200275_a("have_sword", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{SkiesItems.different_sword})).func_203904_a(consumer, BlueSkies.find("everdawn/think_different"));
            Advancement killBugs = this.killAllOf(this.builder((IItemProvider)SkiesItems.bug_guts, "kill_bug", FrameType.GOAL, true, true, false).func_203905_a(poisonShroom), (List<EntityType<?>>)ImmutableList.of(SkiesEntityTypes.VENOM_SPIDER, SkiesEntityTypes.NYCTOFLY, SkiesEntityTypes.EMBERBACK, SkiesEntityTypes.INFESTED_SWARMER, SkiesEntityTypes.ARACHNARCH, SkiesEntityTypes.NESTED_SPIDER)).func_203904_a(consumer, BlueSkies.find("everdawn/kill_bug"));
            Advancement alchemyGold = this.builder((IItemProvider)Items.field_151043_k, "alchemy_gold", FrameType.CHALLENGE, true, true, true).func_203905_a(useAlchemyTable).func_200275_a("craft_gold", (ICriterionInstance)UsedAlchemyTableTrigger.Instance.withItem((IItemProvider)Items.field_151043_k)).func_203904_a(consumer, BlueSkies.find("everdawn/alchemy_gold"));
            this.setSection("progression");
            Advancement impossibleRoot = Advancement.Builder.func_200278_a().func_200275_a("impossible", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_203904_a(consumer, BlueSkies.find("progression/root"));
            this.unlockKeyTrade("unlock_everbright_blinding_key_trade", SkiesItems.blinding_key, SkiesBlocks.bright_blinding_keystone, impossibleRoot, consumer);
            this.unlockKeyTrade("unlock_everdawn_blinding_key_trade", SkiesItems.blinding_key, SkiesBlocks.dawn_blinding_keystone, impossibleRoot, consumer);
            this.unlockKeyTrade("unlock_nature_key_trade", SkiesItems.nature_key, SkiesBlocks.nature_keystone, impossibleRoot, consumer);
            this.unlockKeyTrade("unlock_poison_key_trade", SkiesItems.poison_key, SkiesBlocks.poison_keystone, impossibleRoot, consumer);
        }

        private void toolRecipes(Consumer<Advancement> consumer) {
            for (ToolRecipe.Materials material : ToolRecipe.Materials.values()) {
                for (String type : SkiesRecipes.TOOL_TYPES) {
                    String name = StringUtil.toLower(material.name()) + "_" + type;
                    Advancement.Builder.func_200278_a().func_200275_a("has_resource", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200308_a(material.getItem()).func_200310_b()})).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)BlueSkies.locate(StringUtil.toLower(name)))).func_203904_a(consumer, BlueSkies.find("recipes/blue_skies_tools/" + StringUtil.toLower(name)));
                }
            }
        }

        private Advancement.Builder killAllOf(Advancement.Builder builder, List<EntityType<?>> entities) {
            entities.forEach(e -> builder.func_200275_a("kill_" + e.getRegistryName().func_110623_a(), (ICriterionInstance)KilledTrigger.Instance.func_203928_a((EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_203998_a(e))));
            return builder;
        }

        private Advancement.Builder haveAnyItem(Advancement.Builder builder, List<IItemProvider> items) {
            items.forEach(item -> builder.func_200275_a("has_" + item.func_199767_j().getRegistryName().func_110623_a(), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{item})));
            return builder;
        }

        private Advancement.Builder enterAnyStructure(Advancement.Builder builder, List<Structure<?>> structures) {
            structures.forEach(structure -> builder.func_200275_a("entered_" + structure.getRegistryName().func_110623_a(), (ICriterionInstance)this.enterStructure((Structure<?>)structure)));
            return builder;
        }

        private ChangeDimensionTrigger.Instance changeDim(RegistryKey<World> type) {
            return ChangeDimensionTrigger.Instance.func_233552_a_(type);
        }

        private PositionTrigger.Instance enterStructure(Structure<?> type) {
            return PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_218020_a(type));
        }

        private void unlockKeyTrade(String name, Item key, Block keystone, Advancement parent, Consumer<Advancement> consumer) {
            RightClickBlockWithItemTrigger.Instance clickKeystone = new RightClickBlockWithItemTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, LocationPredicate.Builder.func_226870_a_().func_235312_a_(BlockPredicate.Builder.func_226243_a_().func_233458_a_(keystone).func_226245_b_()).func_218013_a(), ItemPredicate.field_192495_a);
            Advancement.Builder.func_200278_a().func_203905_a(parent).func_203902_a((IItemProvider)key, (ITextComponent)new StringTextComponent(""), (ITextComponent)new StringTextComponent(""), null, FrameType.TASK, false, false, true).func_200275_a("click_keystone", (ICriterionInstance)clickKeystone).func_203904_a(consumer, BlueSkies.find("progression/" + name));
        }

        private TranslationTextComponent translate(String key) {
            return new TranslationTextComponent("advancements.blue_skies" + (this.section.equals("") ? "" : "." + this.section) + "." + key);
        }

        private void setSection(String name) {
            this.section = name;
        }

        private Advancement.Builder builder(IItemProvider displayItem, String name, ResourceLocation background, FrameType frameType, boolean showToast, boolean announceToChat, boolean hidden) {
            return Advancement.Builder.func_200278_a().func_203902_a(displayItem, (ITextComponent)this.translate(name), (ITextComponent)this.translate(name + ".desc"), background, frameType, showToast, announceToChat, hidden);
        }

        private Advancement.Builder builder(IItemProvider displayItem, String name, FrameType frameType, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.builder(displayItem, name, null, frameType, showToast, announceToChat, hidden);
        }
    }
}

