/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.providers;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.objects.SkiesItemTags;
import com.legacy.blue_skies.data.objects.alchemy.AlchemyRecipe;
import com.legacy.blue_skies.data.objects.alchemy.CatylistRecipe;
import com.legacy.blue_skies.data.objects.alchemy.TransmuteRecipe;
import com.legacy.blue_skies.data.providers.SkiesDataProvider;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class AlchemyRecipeProv
extends SkiesDataProvider<AlchemyRecipe> {
    public AlchemyRecipeProv(DataGenerator generator) {
        super(generator, AlchemyRecipe.getDirectory());
    }

    @Override
    protected Map<ResourceLocation, AlchemyRecipe> gatherData() {
        HashMap<ResourceLocation, AlchemyRecipe> registry = new HashMap<ResourceLocation, AlchemyRecipe>();
        AlchemyRecipeProv.transmute(registry, "banner", (ITag<Item>)ItemTags.field_202901_n);
        AlchemyRecipeProv.transmute(registry, "bed", (ITag<Item>)ItemTags.field_219771_F);
        AlchemyRecipeProv.transmute(registry, "carpet", (ITag<Item>)ItemTags.field_200035_e);
        AlchemyRecipeProv.colored(registry, "concrete");
        AlchemyRecipeProv.colored(registry, "concrete_powder");
        AlchemyRecipeProv.transmute(registry, "dye", (ITag<Item>)Tags.Items.DYES);
        AlchemyRecipeProv.colored(registry, "glazed_terracotta");
        AlchemyRecipeProv.transmute(registry, "stained_glass", (ITag<Item>)Tags.Items.STAINED_GLASS);
        AlchemyRecipeProv.transmute(registry, "stained_glass_pane", (ITag<Item>)Tags.Items.STAINED_GLASS_PANES);
        AlchemyRecipeProv.colored(registry, "terracotta");
        AlchemyRecipeProv.transmute(registry, "wool", (ITag<Item>)ItemTags.field_199904_a);
        AlchemyRecipeProv.coral(registry, "coral_block", "%s_coral_block");
        AlchemyRecipeProv.coral(registry, "coral", "%s_coral");
        AlchemyRecipeProv.coral(registry, "coral_fan", "%s_coral_fan");
        AlchemyRecipeProv.coral(registry, "dead_coral_block", "dead_%s_coral_block");
        AlchemyRecipeProv.coral(registry, "dead_coral", "dead_%s_coral");
        AlchemyRecipeProv.coral(registry, "dead_coral_fan", "dead_%s_coral_fan");
        AlchemyRecipeProv.transmute(registry, "log", (ITag<Item>)ItemTags.field_232912_o_);
        AlchemyRecipeProv.transmute(registry, "planks", (ITag<Item>)ItemTags.field_199905_b);
        AlchemyRecipeProv.transmute(registry, "sapling", (ITag<Item>)ItemTags.field_200037_g);
        AlchemyRecipeProv.netherWood(registry, "stem", "%s_stem");
        AlchemyRecipeProv.netherWood(registry, "hyphae", "%s_hyphae");
        AlchemyRecipeProv.netherWood(registry, "stripped_stem", "stripped_%s_stem");
        AlchemyRecipeProv.netherWood(registry, "stripped_hyphae", "stripped_%s_hyphae");
        AlchemyRecipeProv.transmute(registry, "iron", new IItemProvider[]{Items.field_151042_j, SkiesItems.ventium_ingot});
        AlchemyRecipeProv.transmute(registry, "dust", new IItemProvider[]{Items.field_151137_ax, Items.field_151114_aO});
        AlchemyRecipeProv.transmute(registry, "stone", new IItemProvider[]{Items.field_221574_b, Items.field_221575_c, Items.field_221579_g, Items.field_221577_e, SkiesBlocks.turquoise_stone, SkiesBlocks.lunar_stone, SkiesBlocks.taratite, SkiesBlocks.umber, SkiesBlocks.rimestone, SkiesBlocks.cinderstone});
        AlchemyRecipeProv.transmute(registry, "cobblestone", new IItemProvider[]{Items.field_221585_m, SkiesBlocks.turquoise_cobblestone, SkiesBlocks.lunar_cobblestone});
        AlchemyRecipeProv.transmute(registry, "nether_stone", new IItemProvider[]{Items.field_221691_cH, Items.field_234777_rA_});
        AlchemyRecipeProv.transmute(registry, "dirt", new IItemProvider[]{Items.field_221582_j, Items.field_221583_k, SkiesBlocks.turquoise_dirt, SkiesBlocks.coarse_turquoise_dirt, SkiesBlocks.lunar_dirt, SkiesBlocks.coarse_lunar_dirt});
        AlchemyRecipeProv.transmute(registry, "grass_block", new IItemProvider[]{Items.field_221581_i, SkiesBlocks.turquoise_grass_block, SkiesBlocks.lunar_grass_block, SkiesBlocks.turquoise_cherry_grass_block, SkiesBlocks.lunar_cherry_grass_block});
        AlchemyRecipeProv.transmute(registry, "grass", new IItemProvider[]{Items.field_221674_ay, SkiesBlocks.turquoise_grass, SkiesBlocks.lunar_grass, SkiesBlocks.cherry_grass});
        AlchemyRecipeProv.transmute(registry, "sand", (ITag<Item>)Tags.Items.SAND, new IItemProvider[]{SkiesBlocks.midnight_sand, SkiesBlocks.crystal_sand});
        AlchemyRecipeProv.transmute(registry, "glass", (ITag<Item>)Tags.Items.GLASS_COLORLESS, new IItemProvider[]{SkiesBlocks.midnight_glass, SkiesBlocks.crystal_glass});
        AlchemyRecipeProv.transmute(registry, "glass_pane", (ITag<Item>)Tags.Items.GLASS_PANES_COLORLESS, new IItemProvider[]{SkiesBlocks.midnight_glass_pane, SkiesBlocks.crystal_glass_pane});
        AlchemyRecipeProv.transmute(registry, "soul_sand", new IItemProvider[]{Items.field_221693_cI, Items.field_234734_dm_});
        AlchemyRecipeProv.transmute(registry, "gourd", new IItemProvider[]{Items.field_221794_dg, Items.field_221687_cF});
        AlchemyRecipeProv.transmute(registry, "coal", (ITag<Item>)ItemTags.field_219775_L);
        AlchemyRecipeProv.transmute(registry, "cobweb", new IItemProvider[]{Items.field_221672_ax, SkiesBlocks.spider_webbing});
        AlchemyRecipeProv.transmute(registry, "vine", SkiesItemTags.VINES, new IItemProvider[]{Items.field_221796_dh});
        AlchemyRecipeProv.transmute(registry, "nether_vine", new IItemProvider[]{Items.field_234718_bB_, Items.field_234719_bC_});
        AlchemyRecipeProv.transmute(registry, "lily_pad", new IItemProvider[]{Items.field_221816_dr, SkiesBlocks.chilled_lily_pad, SkiesBlocks.moonlit_water_lily});
        AlchemyRecipeProv.transmute(registry, "mushroom", new IItemProvider[]{Items.field_221694_bi, Items.field_221692_bh});
        AlchemyRecipeProv.transmute(registry, "brick", new IItemProvider[]{Items.field_151118_aC, Items.field_196154_dH});
        AlchemyRecipeProv.transmute(registry, "bricks", new IItemProvider[]{Items.field_221647_bL, Items.field_221818_ds});
        AlchemyRecipeProv.transmute(registry, "dripstone", new IItemProvider[]{SkiesBlocks.turquoise_dripstone, SkiesBlocks.lunar_dripstone});
        AlchemyRecipeProv.transmute(registry, "crystal", new IItemProvider[]{SkiesBlocks.moonstone_crystal, SkiesBlocks.sunstone_crystal});
        AlchemyRecipeProv.transmute(registry, "nether_fungus", new IItemProvider[]{Items.field_234722_bw_, Items.field_234723_bx_});
        AlchemyRecipeProv.transmute(registry, "nether_roots", new IItemProvider[]{Items.field_234724_by_, Items.field_234725_bz_, Items.field_234717_bA_});
        AlchemyRecipeProv.transmute(registry, "nylium", new IItemProvider[]{Items.field_234767_m_, Items.field_234768_n_});
        AlchemyRecipeProv.transmute(registry, "wart_block", new IItemProvider[]{Items.field_221960_gl, Items.field_234751_hk_});
        AlchemyRecipeProv.transmute(registry, "dungeon_stone", new IItemProvider[]{SkiesBlocks.blinding_stone, SkiesBlocks.nature_stone, SkiesBlocks.poison_stone});
        AlchemyRecipeProv.catylist(registry, "horizonite_from_iron", (IItemProvider)Items.field_151042_j, (IItemProvider)Items.field_151072_bj, new IItemProvider[]{SkiesItems.horizonite_ingot});
        AlchemyRecipeProv.catylist(registry, "falsite_from_iron", (IItemProvider)Items.field_151042_j, (IItemProvider)SkiesItems.soul_fragment, new IItemProvider[]{SkiesItems.falsite_ingot});
        AlchemyRecipeProv.catylist(registry, "netherrack_from_stone", (IItemProvider)Items.field_221574_b, (IItemProvider)Items.field_151075_bm, new IItemProvider[]{Items.field_221691_cH});
        AlchemyRecipeProv.catylist(registry, "end_stone_from_stone", (IItemProvider)Items.field_221574_b, (IItemProvider)Items.field_185161_cS, new IItemProvider[]{Items.field_221828_dx});
        AlchemyRecipeProv.catylist(registry, "grass_block_from_dirt", (IItemProvider)Items.field_221582_j, (IItemProvider)Items.field_196106_bc, new IItemProvider[]{Items.field_221581_i});
        AlchemyRecipeProv.catylist(registry, "turquoise_grass_block_from_dirt", (IItemProvider)SkiesBlocks.turquoise_dirt, (IItemProvider)Items.field_196106_bc, new IItemProvider[]{SkiesBlocks.turquoise_grass_block});
        AlchemyRecipeProv.catylist(registry, "lunar_grass_block_from_dirt", (IItemProvider)SkiesBlocks.lunar_dirt, (IItemProvider)Items.field_196106_bc, new IItemProvider[]{SkiesBlocks.lunar_grass_block});
        AlchemyRecipeProv.catylist(registry, "crimson_nylium_from_netherrack", (IItemProvider)Items.field_221691_cH, (IItemProvider)Items.field_234722_bw_, new IItemProvider[]{Items.field_234767_m_});
        AlchemyRecipeProv.catylist(registry, "warped_nylium_from_netherrack", (IItemProvider)Items.field_221691_cH, (IItemProvider)Items.field_234723_bx_, new IItemProvider[]{Items.field_234768_n_});
        AlchemyRecipeProv.catylist(registry, "lunar_mud_from_dirt", (IItemProvider)SkiesBlocks.lunar_dirt, (IItemProvider)Items.field_151123_aH, new IItemProvider[]{SkiesBlocks.lunar_mud});
        AlchemyRecipeProv.catylist(registry, "soul_sand_from_sand", (IItemProvider)Items.field_221548_A, (IItemProvider)SkiesItems.soul_fragment, new IItemProvider[]{Items.field_221693_cI});
        AlchemyRecipeProv.catylist(registry, "soul_soil_from_dirt", (IItemProvider)Items.field_221582_j, (IItemProvider)SkiesItems.soul_fragment, new IItemProvider[]{Items.field_234734_dm_});
        AlchemyRecipeProv.catylist(registry, "blinding_stone_from_ethereal_arc", (IItemProvider)SkiesBlocks.turquoise_stone, (IItemProvider)SkiesItems.ethereal_arc, new IItemProvider[]{SkiesBlocks.blinding_stone});
        AlchemyRecipeProv.catylist(registry, "blinding_stone_from_dusk_arc", (IItemProvider)SkiesBlocks.lunar_stone, (IItemProvider)SkiesItems.dusk_arc, new IItemProvider[]{SkiesBlocks.blinding_stone});
        AlchemyRecipeProv.catylist(registry, "nature_stone_from_arc", (IItemProvider)SkiesBlocks.turquoise_stone, (IItemProvider)SkiesItems.nature_arc, new IItemProvider[]{SkiesBlocks.nature_stone});
        AlchemyRecipeProv.catylist(registry, "poison_stone_from_arc", (IItemProvider)SkiesBlocks.lunar_stone, (IItemProvider)SkiesItems.poison_arc, new IItemProvider[]{SkiesBlocks.poison_stone});
        AlchemyRecipeProv.catylist(registry, "gold_lol", (IItemProvider)Items.field_234759_km_, (IItemProvider)Items.field_151068_bn, new IItemProvider[]{Items.field_151043_k});
        return registry;
    }

    private static void transmute(Map<ResourceLocation, AlchemyRecipe> registry, String name, Set<IItemProvider> items) {
        registry.put(BlueSkies.locate(name), new TransmuteRecipe(items.stream().map(IItemProvider::func_199767_j).collect(Collectors.toSet()), false));
    }

    private static void transmute(Map<ResourceLocation, AlchemyRecipe> registry, String name, IItemProvider ... items) {
        AlchemyRecipeProv.transmute(registry, name, Arrays.stream(items).collect(Collectors.toSet()));
    }

    private static void transmute(Map<ResourceLocation, AlchemyRecipe> registry, String name, ITag<Item> tag) {
        registry.put(BlueSkies.locate(name), new TransmuteRecipe(Lists.newArrayList((Object[])new ITag[]{tag}), false));
    }

    private static void transmute(Map<ResourceLocation, AlchemyRecipe> registry, String name, ITag<Item> tag, IItemProvider ... items) {
        registry.put(BlueSkies.locate(name), new TransmuteRecipe(Arrays.stream(items).map(IItemProvider::func_199767_j).collect(Collectors.toSet()), Lists.newArrayList((Object[])new ITag[]{tag}), false));
    }

    private static void catylist(Map<ResourceLocation, AlchemyRecipe> registry, String name, IItemProvider input, IItemProvider catylist, IItemProvider ... items) {
        registry.put(BlueSkies.locate(name), new CatylistRecipe(input.func_199767_j(), catylist.func_199767_j(), Arrays.stream(items).map(IItemProvider::func_199767_j).collect(Collectors.toSet()), false));
    }

    private static void colored(Map<ResourceLocation, AlchemyRecipe> registry, String name) {
        HashSet<IItemProvider> items = new HashSet<IItemProvider>();
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation itemName = new ResourceLocation(color.func_176610_l() + "_" + name);
            if (ForgeRegistries.ITEMS.containsKey(itemName)) {
                items.add((IItemProvider)ForgeRegistries.ITEMS.getValue(itemName));
                continue;
            }
            LOGGER.warn("No item exists for {}", (Object)itemName.toString());
        }
        AlchemyRecipeProv.transmute(registry, name, items);
    }

    private static void coral(Map<ResourceLocation, AlchemyRecipe> registry, String name, String format) {
        HashSet<IItemProvider> items = new HashSet<IItemProvider>();
        for (String coral : Arrays.asList("tube", "brain", "bubble", "fire", "horn")) {
            ResourceLocation itemName = new ResourceLocation(String.format(format, coral));
            if (ForgeRegistries.ITEMS.containsKey(itemName)) {
                items.add((IItemProvider)ForgeRegistries.ITEMS.getValue(itemName));
                continue;
            }
            LOGGER.warn("No item exists for {}", (Object)itemName.toString());
        }
        AlchemyRecipeProv.transmute(registry, name, items);
    }

    private static void netherWood(Map<ResourceLocation, AlchemyRecipe> registry, String name, String format) {
        HashSet<IItemProvider> items = new HashSet<IItemProvider>();
        for (String coral : Arrays.asList("crimson", "warped")) {
            ResourceLocation itemName = new ResourceLocation(String.format(format, coral));
            if (ForgeRegistries.ITEMS.containsKey(itemName)) {
                items.add((IItemProvider)ForgeRegistries.ITEMS.getValue(itemName));
                continue;
            }
            LOGGER.warn("No item exists for {}", (Object)itemName.toString());
        }
        AlchemyRecipeProv.transmute(registry, name, items);
    }
}

