/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.objects.alchemy;

import com.google.gson.JsonObject;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.data.objects.IToJson;
import com.legacy.blue_skies.data.objects.alchemy.CatylistRecipe;
import com.legacy.blue_skies.data.objects.alchemy.TransmuteRecipe;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public abstract class AlchemyRecipe
implements IToJson<AlchemyRecipe> {
    protected static final String OVERRIDE_KEY = "override";
    protected static final String TYPE_KEY = "type";
    public final boolean shouldOverride;
    public final ResourceLocation type;

    public AlchemyRecipe(boolean shouldOverride, ResourceLocation type) {
        this.shouldOverride = shouldOverride;
        this.type = type;
    }

    public abstract void addResults(Set<Item> var1);

    public abstract Set<Item> getResults(ItemStack var1, ItemStack var2);

    public abstract Set<Item> getResults();

    public abstract List<ImmutableTriple<ItemStack, ItemStack, ItemStack>> getAllCombinations();

    public abstract boolean matches(ItemStack var1, ItemStack var2);

    public abstract AlchemyRecipe fromJson(JsonObject var1) throws SkiesDataManager.RegistryObjectNotFoundException;

    public abstract AlchemyRecipe fromNbt(CompoundNBT var1);

    public abstract CompoundNBT toNbt(AlchemyRecipe var1);

    public static String getDirectory() {
        return "alchemy_recipes";
    }

    public static class Types {
        private static final Map<ResourceLocation, AlchemyRecipe> REGISTRY = new HashMap<ResourceLocation, AlchemyRecipe>();

        public static void register(AlchemyRecipe recipeDefault) {
            REGISTRY.put(recipeDefault.type, recipeDefault);
        }

        public static AlchemyRecipe parse(JsonObject json) {
            ResourceLocation name = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)AlchemyRecipe.TYPE_KEY));
            return Types.get(name);
        }

        public static AlchemyRecipe parse(CompoundNBT nbt) {
            ResourceLocation name = new ResourceLocation(nbt.func_74779_i(AlchemyRecipe.TYPE_KEY));
            return Types.get(name);
        }

        public static AlchemyRecipe get(ResourceLocation name) {
            if (REGISTRY.containsKey(name)) {
                return REGISTRY.get(name);
            }
            IllegalArgumentException e = new IllegalArgumentException(name.toString() + " is not a registered recipe type!");
            BlueSkies.LOGGER.fatal((Object)e);
            throw e;
        }

        static {
            Types.register(new TransmuteRecipe(new HashSet<Item>(), false));
            Types.register(new CatylistRecipe(Items.field_190931_a, Items.field_190931_a, new HashSet<Item>(), false));
        }
    }
}

