/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.renders.entities.misc;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.models.entities.misc.SpearModel;
import com.legacy.blue_skies.entities.projectile.SpearEntity;
import com.legacy.blue_skies.registries.SkiesItems;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpearRenderer<T extends SpearEntity>
extends EntityRenderer<T> {
    public static final ResourceLocation BLUEBRIGHT_SPEAR = BlueSkies.locate("textures/entity/spear/bluebright_spear.png");
    public static final ResourceLocation STARLIT_SPEAR = BlueSkies.locate("textures/entity/spear/starlit_spear.png");
    public static final ResourceLocation FROSTBRIGHT_SPEAR = BlueSkies.locate("textures/entity/spear/frostbright_spear.png");
    public static final ResourceLocation LUNAR_SPEAR = BlueSkies.locate("textures/entity/spear/lunar_spear.png");
    public static final ResourceLocation DUSK_SPEAR = BlueSkies.locate("textures/entity/spear/dusk_spear.png");
    public static final ResourceLocation MAPLE_SPEAR = BlueSkies.locate("textures/entity/spear/maple_spear.png");
    public static final ResourceLocation CHERRY_SPEAR = BlueSkies.locate("textures/entity/spear/cherry_spear.png");
    public static final ResourceLocation SOULBOUND_SPEAR = BlueSkies.locate("textures/entity/spear/soulbound_spear.png");
    public static final ResourceLocation GLOW = BlueSkies.locate("textures/entity/spear/spear_glow.png");
    public static final ResourceLocation SOULBOUND_GLOW = BlueSkies.locate("textures/entity/spear/soulbound_spear_glow.png");
    private final SpearModel spearModel = new SpearModel(false);
    private final SpearModel soulboundModel = new SpearModel(true);

    public SpearRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(T entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (((SpearEntity)((Object)entityIn)).field_70173_aa < 1) {
            return;
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)((SpearEntity)((Object)entityIn)).field_70126_B, (float)((SpearEntity)((Object)entityIn)).field_70177_z) - 90.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)((SpearEntity)((Object)entityIn)).field_70127_C, (float)((SpearEntity)((Object)entityIn)).field_70125_A) + 90.0f));
        IVertexBuilder builder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)bufferIn, (RenderType)RenderType.func_228638_b_((ResourceLocation)this.getTextureLocation(entityIn)), (boolean)false, (boolean)((SpearEntity)((Object)entityIn)).hasEffect());
        this.getModel(entityIn).func_225598_a_(matrixStackIn, builder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        IVertexBuilder glowBuilder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)bufferIn, (RenderType)RenderType.func_228652_i_((ResourceLocation)this.getGlowTexture(entityIn)), (boolean)false, (boolean)((SpearEntity)((Object)entityIn)).hasEffect());
        this.getModel(entityIn).func_225598_a_(matrixStackIn, glowBuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
        super.func_225623_a_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return SpearRenderer.getSpearTexture(((SpearEntity)((Object)entity)).func_184550_j().func_77973_b());
    }

    public static ResourceLocation getSpearTexture(Item item) {
        if (item.equals(SkiesItems.starlit_spear)) {
            return STARLIT_SPEAR;
        }
        if (item.equals(SkiesItems.frostbright_spear)) {
            return FROSTBRIGHT_SPEAR;
        }
        if (item.equals(SkiesItems.lunar_spear)) {
            return LUNAR_SPEAR;
        }
        if (item.equals(SkiesItems.dusk_spear)) {
            return DUSK_SPEAR;
        }
        if (item.equals(SkiesItems.maple_spear)) {
            return MAPLE_SPEAR;
        }
        if (item.equals(SkiesItems.cherry_spear)) {
            return CHERRY_SPEAR;
        }
        if (item.equals(SkiesItems.soulbound_spear)) {
            return SOULBOUND_SPEAR;
        }
        return BLUEBRIGHT_SPEAR;
    }

    public ResourceLocation getGlowTexture(T entity) {
        return ((SpearEntity)((Object)entity)).func_184550_j().func_77973_b() == SkiesItems.soulbound_spear ? SOULBOUND_GLOW : GLOW;
    }

    public SpearModel getModel(T entityIn) {
        return ((SpearEntity)((Object)entityIn)).func_184550_j().func_77973_b() == SkiesItems.soulbound_spear ? this.soulboundModel : this.spearModel;
    }
}

