/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class SkyFarmlandBlock
extends FarmlandBlock {
    private final Supplier<Block> dirt;

    public SkyFarmlandBlock(AbstractBlock.Properties builder, Supplier<Block> dirt) {
        super(builder);
        this.dirt = dirt;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return !this.func_176223_P().func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) ? this.dirt.get().func_176223_P() : super.func_196258_a(context);
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.func_177972_a(facing));
        if (plantType == PlantType.CROP) {
            return true;
        }
        return super.canSustainPlant(state, world, pos, facing, plantable);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (!world.field_72995_K && ForgeHooks.onFarmlandTrample((World)world, (BlockPos)pos, (BlockState)this.dirt.get().func_176223_P(), (float)fallDistance, (Entity)entity)) {
            SkyFarmlandBlock.turnToDirt(world.func_180495_p(pos), world, pos, this);
        }
        entity.func_225503_b_(fallDistance, 1.0f);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!state.func_196955_c((IWorldReader)world, pos)) {
            SkyFarmlandBlock.turnToDirt(state, (World)world, pos, this);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        int i = (Integer)state.func_177229_b((Property)field_176531_a);
        if (!SkyFarmlandBlock.hasWater((IWorldReader)world, pos) && !world.func_175727_C(pos.func_177984_a())) {
            if (i > 0) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176531_a, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.hasCrops((IBlockReader)world, pos)) {
                SkyFarmlandBlock.turnToDirt(state, (World)world, pos, this);
            }
        } else if (i < 7) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176531_a, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    private static boolean hasWater(IWorldReader world, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (!world.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((IWorldReader)world, (BlockPos)pos);
    }

    private boolean hasCrops(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos.func_177984_a());
        return state.func_177230_c() instanceof IPlantable && this.canSustainPlant(state, world, pos, Direction.UP, (IPlantable)state.func_177230_c());
    }

    public static void turnToDirt(BlockState state, World world, BlockPos pos, SkyFarmlandBlock instance) {
        world.func_175656_a(pos, SkyFarmlandBlock.func_199601_a((BlockState)state, (BlockState)instance.dirt.get().func_176223_P(), (World)world, (BlockPos)pos));
    }

    public boolean isFertile(BlockState state, IBlockReader world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == this) {
            return (Integer)state.func_177229_b((Property)FarmlandBlock.field_176531_a) > 0;
        }
        return false;
    }
}

