/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.structure_gel.util.GelCollectors;
import com.legacy.structure_gel.util.VoxelShapeUtil;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;

public class SeaMossBlock
extends BushBlock
implements ILiquidContainer,
IGrowable,
IForgeShearable {
    private static final VoxelShape MAIN_SHAPE = Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    private static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape SOUTH_SHAPE = VoxelShapeUtil.rotate((VoxelShape)NORTH_SHAPE, (Direction)Direction.SOUTH);
    private static final VoxelShape EAST_SHAPE = VoxelShapeUtil.rotate((VoxelShape)NORTH_SHAPE, (Direction)Direction.EAST);
    private static final VoxelShape WEST_SHAPE = VoxelShapeUtil.rotate((VoxelShape)NORTH_SHAPE, (Direction)Direction.WEST);
    public static final BooleanProperty NORTH = BlockStateProperties.field_208151_D;
    public static final BooleanProperty SOUTH = BlockStateProperties.field_208153_F;
    public static final BooleanProperty EAST = BlockStateProperties.field_208152_E;
    public static final BooleanProperty WEST = BlockStateProperties.field_208154_G;
    private static final Map<Direction, BooleanProperty> DIRECTION_TO_PROP = GelCollectors.mapOf(Direction.class, BooleanProperty.class, (Object[])new Object[]{Direction.NORTH, NORTH, Direction.SOUTH, SOUTH, Direction.EAST, EAST, Direction.WEST, WEST});
    private static final Map<Direction, VoxelShape> DIRECTION_TO_SHAPE = GelCollectors.mapOf(Direction.class, VoxelShape.class, (Object[])new Object[]{Direction.NORTH, NORTH_SHAPE, Direction.SOUTH, SOUTH_SHAPE, Direction.EAST, EAST_SHAPE, Direction.WEST, WEST_SHAPE});

    public SeaMossBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = MAIN_SHAPE;
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            if (!((Boolean)state.func_177229_b((Property)DIRECTION_TO_PROP.get(dir))).booleanValue()) continue;
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)DIRECTION_TO_SHAPE.get(dir));
        }
        return shape;
    }

    public VoxelShape func_230335_e_(BlockState state, IBlockReader world, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_224755_d(world, pos, Direction.UP) && !state.func_203425_a(Blocks.field_196814_hQ);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        return fluidState.func_206884_a((ITag)FluidTags.field_206959_a) && fluidState.func_206882_g() == 8 ? this.getStateForPlacement(this.func_176223_P(), (IWorld)context.func_195991_k(), context.func_195995_a()) : null;
    }

    public BlockState getStateForPlacement(BlockState state, IWorld world, BlockPos pos) {
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(dir);
            state = (BlockState)state.func_206870_a((Property)DIRECTION_TO_PROP.get(dir), (Comparable)Boolean.valueOf(world.func_180495_p(offsetPos).func_224755_d((IBlockReader)world, offsetPos, dir)));
        }
        return state;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        BlockState newState = super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
        if (newState.func_177230_c() == this) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
            return this.getStateForPlacement(newState, world, currentPos);
        }
        return newState;
    }

    public FluidState func_204507_t(BlockState state) {
        return Fluids.field_204546_a.func_207204_a(false);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, SOUTH, EAST, WEST});
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        block0: for (int attempts = rand.nextInt(3) + 7; attempts > 0; --attempts) {
            BlockPos offset = pos.func_177982_a(rand.nextInt(7) - 3, 0, rand.nextInt(7) - 3);
            for (int y = -1; y <= 1; ++y) {
                BlockPos upOffset = offset.func_177981_b(y);
                BlockState placementState = this.getStateForPlacement(state, (IWorld)world, upOffset);
                if (world.func_180495_p(upOffset).func_177230_c() != Blocks.field_150355_j || !this.func_196260_a(placementState, (IWorldReader)world, upOffset)) continue;
                world.func_175656_a(upOffset, placementState);
                continue block0;
            }
        }
    }
}

