/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BrewberryBushBlock
extends BushBlock
implements IGrowable {
    private static final VoxelShape BUSH_SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final BooleanProperty MATURE = BooleanProperty.func_177716_a((String)"mature");
    public static final EnumProperty<Type> TYPE = EnumProperty.func_177709_a((String)"type", Type.class);

    public BrewberryBushBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200944_c().func_200943_b(0.2f).func_200942_a().func_200947_a(SoundType.field_185850_c));
        this.func_180632_j((BlockState)((BlockState)super.func_176223_P().func_206870_a((Property)MATURE, (Comparable)Boolean.valueOf(false))).func_206870_a(TYPE, (Comparable)((Object)Type.RED)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return BUSH_SHAPE;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && entityIn.func_200600_R() != EntityType.field_220356_B) {
            entityIn.func_213295_a(state, new Vector3d(0.9, 0.85, 0.9));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{MATURE}).func_206894_a(new Property[]{TYPE});
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!world.field_72995_K && !((Boolean)state.func_177229_b((Property)MATURE)).booleanValue() && rand.nextInt(60) == 0) {
            world.func_175656_a(pos, this.getGrownState((World)world, pos, rand));
        }
    }

    private ItemStack getBerry(World world, BlockState state, BlockPos pos) {
        Block soil = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        int count = this.RANDOM.nextInt(2) + 1;
        if (soil instanceof FarmlandBlock || soil == Blocks.field_196661_l) {
            count += this.RANDOM.nextInt(3);
        }
        return new ItemStack((IItemProvider)((Type)((Object)state.func_177229_b(TYPE))).getBerry(), count);
    }

    private BlockState getGrownState(World world, BlockPos pos, Random rand) {
        Type type = Type.RED;
        if (rand.nextBoolean()) {
            Block soil = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            if (soil == Blocks.field_150391_bh) {
                type = Type.BLACK;
            } else if (soil == SkiesBlocks.turquoise_cherry_grass_block || soil == SkiesBlocks.lunar_cherry_grass_block) {
                type = Type.PINK;
            }
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)MATURE, (Comparable)Boolean.valueOf(true))).func_206870_a(TYPE, (Comparable)((Object)type));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (((Boolean)state.func_177229_b((Property)MATURE)).booleanValue()) {
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, this.getBerry(world, state, pos)));
            world.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187575_bT, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)MATURE, (Comparable)Boolean.valueOf(false))).func_206870_a(TYPE, (Comparable)((Object)Type.RED)));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        Block block = state.func_177230_c();
        return super.func_200014_a_(state, world, pos) || block instanceof FarmlandBlock || block == Blocks.field_150391_bh;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)state.func_177229_b((Property)MATURE) == false;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return (Boolean)state.func_177229_b((Property)MATURE) == false;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        if ((double)rand.nextFloat() > 0.5) {
            world.func_180501_a(pos, this.getGrownState((World)world, pos, rand), 3);
        }
    }

    public static enum Type implements IStringSerializable
    {
        RED("red", () -> SkiesItems.brewberry),
        PINK("pink", () -> SkiesItems.pink_brewberry),
        BLACK("black", () -> SkiesItems.black_brewberry);

        private final String name;
        private final Supplier<Item> berry;

        private Type(String name, Supplier<Item> berry) {
            this.name = name;
            this.berry = berry;
        }

        public Item getBerry() {
            return this.berry.get();
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

