/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.client.particle.data.PoisonData;
import com.legacy.blue_skies.registries.SkiesVillagers;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BanefulMushroomBlock
extends BushBlock {
    private static final BooleanProperty OPEN = BooleanProperty.func_177716_a((String)"open");
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);

    public BanefulMushroomBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vector3d vec3d = state.func_191059_e(worldIn, pos);
        return SHAPE.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
            world.func_180501_a(pos, this.func_176223_P(), 3);
        }
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        BanefulMushroomBlock.poisonTarget(state, world, pos, entity, (Block)this, OPEN);
    }

    public static void poisonTarget(BlockState state, World world, BlockPos pos, Entity entity, Block block, BooleanProperty openProperty) {
        if (entity instanceof LivingEntity && ((LivingEntity)entity).func_70687_e(new EffectInstance(Effects.field_76436_u))) {
            if (entity instanceof VillagerEntity && ((VillagerEntity)entity).func_213700_eh().func_221129_a() == SkiesVillagers.SHADED_WOODLANDS) {
                return;
            }
            int durration = 20 * (world.func_175659_aa().func_151525_a() + 3);
            int amplifier = world.func_175659_aa().func_151525_a() / 2;
            if (world.func_201670_d() && !((Boolean)state.func_177229_b((Property)openProperty)).booleanValue()) {
                block.func_180655_c(world.func_180495_p(pos), world, pos, new Random());
            }
            world.func_175656_a(pos, (BlockState)block.func_176223_P().func_206870_a((Property)openProperty, (Comparable)Boolean.valueOf(true)));
            if (!((LivingEntity)entity).func_70644_a(Effects.field_76436_u)) {
                ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76436_u, durration, amplifier));
            }
            world.func_205220_G_().func_205360_a(pos, (Object)block, 100);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue() && rand.nextFloat() < 0.7f) {
            Vector3d vec3d = state.func_191059_e((IBlockReader)world, pos);
            for (int i = 0; i < rand.nextInt(2) + 1; ++i) {
                float dx = (rand.nextFloat() - 0.5f) / 7.0f;
                float dy = rand.nextFloat() / 10.0f;
                float dz = (rand.nextFloat() - 0.5f) / 7.0f;
                world.func_195594_a((IParticleData)new PoisonData(false), (double)pos.func_177958_n() + 0.5 + vec3d.field_72450_a, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5 + vec3d.field_72449_c, (double)dx, (double)dy, (double)dz);
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{OPEN});
    }
}

