/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.misc;

import com.legacy.blue_skies.tile_entity.TrophyTileEntity;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.structure_gel.util.VoxelShapeUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrophyBlock
extends ContainerBlock
implements IWaterLoggable {
    public static final EnumProperty<Tier> TIER = EnumProperty.func_177709_a((String)"tier", Tier.class);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private final Map<Direction, VoxelShape> shapes = new HashMap<Direction, VoxelShape>();
    private final Supplier<EntityType<?>> boss;

    public TrophyBlock(AbstractBlock.Properties builder, Supplier<EntityType<?>> boss, VoxelShape shape) {
        super(builder);
        this.boss = boss;
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            this.shapes.put(dir, VoxelShapeUtil.rotate((VoxelShape)shape, (Direction)dir));
        }
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TIER, (Comparable)((Object)Tier.BRONZE))).func_206870_a(FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes.get(state.func_177229_b(FACING));
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        for (Tier tier : Tier.values()) {
            items.add((Object)tier.getItem(this));
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return ((Tier)((Object)state.func_177229_b(TIER))).getItem(this);
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TrophyTileEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader world, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public boolean func_200123_i(BlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TrophyTileEntity) {
            ((TrophyTileEntity)tile).setLabel(stack.func_82837_s() ? stack.func_200301_q() : this.boss.get().func_212546_e());
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_195992_f().func_176734_d();
        boolean waterlogged = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)facing)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return state;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TIER, FACING, WATERLOGGED});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a(FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b(FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b(FACING)));
    }

    public static enum Tier implements IStringSerializable
    {
        BRONZE("bronze"),
        SILVER("silver"),
        GOLD("gold"),
        PLATINUM("platinum");

        public final String name;

        private Tier(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public ItemStack getItem(TrophyBlock trophy) {
            ItemStack stack = new ItemStack((IItemProvider)trophy);
            CompoundNBT nbt = stack.func_196082_o();
            CompoundNBT states = new CompoundNBT();
            states.func_74778_a("tier", this.func_176610_l());
            nbt.func_218657_a("BlockStateTag", (INBT)states);
            return stack;
        }

        public static Tier from(String name) {
            for (Tier t : Tier.values()) {
                if (!t.name.equals(name)) continue;
                return t;
            }
            return BRONZE;
        }
    }
}

