/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.dungeon;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.events.SkiesPlayerEvents;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.DisplayToastPacket;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.registries.SkiesStats;
import com.legacy.blue_skies.tile_entity.KeystoneTileEntity;
import com.legacy.blue_skies.util.EntityUtil;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class KeystoneBlock
extends ContainerBlock {
    public KeystoneBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150357_h).func_222380_e());
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        player.func_195066_a(SkiesStats.INTERACT_WITH_KEYSTONE);
        if (player instanceof ServerPlayerEntity) {
            int start = 15;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            if (!(state.func_177230_c() != SkiesBlocks.bright_blinding_keystone && state.func_177230_c() != SkiesBlocks.dawn_blinding_keystone || EntityUtil.hasAdvancement(serverPlayer, BlueSkies.locate("progression/unlock_everbright_blinding_key_trade")) || EntityUtil.hasAdvancement(serverPlayer, BlueSkies.locate("progression/unlock_everdawn_blinding_key_trade")))) {
                PacketHandler.sendToClient(new DisplayToastPacket((byte)start), serverPlayer);
            }
            if (state.func_177230_c() == SkiesBlocks.nature_keystone && !EntityUtil.hasAdvancement(serverPlayer, BlueSkies.locate("progression/unlock_nature_key_trade"))) {
                PacketHandler.sendToClient(new DisplayToastPacket((byte)(start + 1)), serverPlayer);
            }
            if (state.func_177230_c() == SkiesBlocks.poison_keystone && !EntityUtil.hasAdvancement(serverPlayer, BlueSkies.locate("progression/unlock_poison_key_trade"))) {
                PacketHandler.sendToClient(new DisplayToastPacket((byte)(start + 2)), serverPlayer);
            }
        }
        if (player.func_175142_cm()) {
            if (worldIn.func_175625_s(pos) instanceof KeystoneTileEntity) {
                KeystoneTileEntity tile = (KeystoneTileEntity)worldIn.func_175625_s(pos);
                ItemStack heldItem = player.func_184586_b(handIn);
                if (player.func_184812_l_() && heldItem.func_77973_b() instanceof SpawnEggItem) {
                    EntityType entityType = ((SpawnEggItem)heldItem.func_77973_b()).func_208076_b(heldItem.func_77978_p());
                    tile.setContainedMob(entityType);
                    return ActionResultType.SUCCESS;
                }
                if ((tile.isCorrectKey(heldItem) || tile.isCorrectArc(heldItem.func_77973_b())) && SkiesPlayerEvents.inBossFight(player)) {
                    return KeystoneBlock.playLockedWithMessage(player, pos, "tile.keystone.respawning_in_fight");
                }
                if (tile.getSpawnsBoss() && tile.isCorrectArc(heldItem.func_77973_b()) && player.func_184811_cZ().func_185141_a(heldItem.func_77973_b())) {
                    return KeystoneBlock.playLockedWithMessage(player, pos, "tile.keystone.arc_on_cooldown");
                }
                if (tile.getSpawnsBoss() && (tile.isCorrectKey(heldItem) || tile.isCorrectArc(heldItem.func_77973_b())) && this.spawnBoss(tile, state, worldIn, pos, player, heldItem)) {
                    return ActionResultType.SUCCESS;
                }
                if (!(tile.getSpawnsBoss() && tile.getKeysRequired() || !this.teleportPlayer(tile, state, worldIn, pos, player, hit.func_216354_b()))) {
                    return ActionResultType.SUCCESS;
                }
                if (tile.getKeysRequired()) {
                    return KeystoneBlock.playLockedWithMessage(player, pos, "tile.keystone.requires_keys");
                }
                return ActionResultType.PASS;
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    public boolean spawnBoss(KeystoneTileEntity tile, BlockState state, World worldIn, BlockPos pos, PlayerEntity player, ItemStack heldItem) {
        if (!(worldIn.field_72995_K || player.func_184812_l_() || EntityUtil.hasPlayerProgressedTo(player, tile.isEverbrightBased(), tile.getRequiredProgressionId()))) {
            return false;
        }
        tile.spawnMob(tile.isCorrectArc(heldItem.func_77973_b()));
        tile.teleportClosePlayers(worldIn);
        tile.setKeysRequired(false);
        if (tile.isCorrectKey(heldItem)) {
            if (!player.func_184812_l_() && !worldIn.field_72995_K) {
                heldItem.func_190918_g(4);
            }
            if (worldIn.field_72995_K) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("tile.keystone.remove_key_requirement"), true);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)heldItem.func_77973_b()));
        } else if (tile.isCorrectArc(heldItem.func_77973_b())) {
            if (!player.func_184812_l_()) {
                player.func_184811_cZ().func_185145_a(heldItem.func_77973_b(), 12000);
            }
            if (worldIn.field_72995_K) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("tile.keystone.arc_drained", new Object[]{heldItem.func_77973_b().func_200296_o()}), true);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)heldItem.func_77973_b()));
        }
        if (worldIn.field_72995_K) {
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SkiesSounds.BLOCK_KEYSTONE_UNLOCK, SoundCategory.BLOCKS, 1.0f, EntityUtil.getSoundPitchWithStart(worldIn.field_73012_v, 1.0f), false);
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SkiesSounds.BLOCK_KEYSTONE_TELEPORT, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
        }
        return true;
    }

    public boolean teleportPlayer(KeystoneTileEntity tile, BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Direction clickDirection) {
        if (!player.func_184812_l_() && !EntityUtil.hasPlayerProgressedTo(player, tile.isEverbrightBased(), tile.getRequiredProgressionId())) {
            return false;
        }
        tile.teleportPlayer(player);
        return true;
    }

    public static ActionResultType playLockedWithMessage(PlayerEntity player, BlockPos pos, String message) {
        player.field_70170_p.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SkiesSounds.BLOCK_KEYSTONE_LOCKED, SoundCategory.BLOCKS, 1.0f, EntityUtil.getSoundPitchWithStart(player.field_70170_p.field_73012_v, 1.0f));
        player.func_146105_b((ITextComponent)new TranslationTextComponent(message), true);
        return ActionResultType.SUCCESS;
    }

    public static abstract class DirectionalKeystoneBlock
    extends KeystoneBlock {
        public static final EnumProperty<Direction> FACING = HorizontalBlock.field_185512_D;

        public DirectionalKeystoneBlock() {
            this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)Direction.NORTH));
        }

        public BlockState func_196258_a(BlockItemUseContext context) {
            return (BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)context.func_195992_f().func_176734_d());
        }

        public BlockState func_185499_a(BlockState state, Rotation rotation) {
            return (BlockState)state.func_206870_a(FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b(FACING)));
        }

        public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
            return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b(FACING)));
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            builder.func_206894_a(new Property[]{FACING});
        }
    }
}

