/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.construction;

import com.legacy.blue_skies.data.objects.SkiesItemTags;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.structure_gel.util.VoxelShapeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class TroughBlock
extends HorizontalBlock
implements ISidedInventoryProvider {
    public static final IntegerProperty LEVEL = IntegerProperty.func_177719_a((String)"level", (int)0, (int)4);
    private static final Map<Direction, List<VoxelShape>> SHAPES = new HashMap<Direction, List<VoxelShape>>();

    public TroughBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((Property)field_185512_D)).get((Integer)state.func_177229_b((Property)LEVEL));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((Property)field_185512_D)).get(0);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        int level = (Integer)state.func_177229_b((Property)LEVEL);
        ItemStack heldStack = player.func_184586_b(hand);
        if (level < 4 && TroughBlock.canUseItem(heldStack)) {
            if (!world.field_72995_K) {
                TroughBlock.attemptFill(state, (IWorld)world, pos, heldStack);
                if (!player.field_71075_bZ.field_75098_d) {
                    heldStack.func_190918_g(1);
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public static boolean attemptFill(BlockState state, IWorld world, BlockPos pos, ItemStack fillWithStack) {
        if (TroughBlock.canUseItem(fillWithStack) && world.func_201674_k().nextFloat() < 0.4f) {
            BlockState newState = (BlockState)state.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(Math.min(4, (Integer)state.func_177229_b((Property)LEVEL) + 1)));
            world.func_180501_a(pos, newState, 3);
            world.func_217379_c(1500, pos, 1);
            return true;
        }
        world.func_217379_c(1500, pos, 0);
        return false;
    }

    public static boolean canConsume(BlockState state, IWorld world) {
        return (Integer)state.func_177229_b((Property)LEVEL) > 0;
    }

    public static boolean attemptConsume(BlockState state, IWorld world, BlockPos pos) {
        if (TroughBlock.canConsume(state, world)) {
            BlockState newState = (BlockState)state.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(Math.max(0, (Integer)state.func_177229_b((Property)LEVEL) - 1)));
            world.func_180501_a(pos, newState, 3);
            return true;
        }
        return false;
    }

    public static boolean canUseItem(ItemStack item) {
        return item.func_77973_b().func_206844_a(SkiesItemTags.TROUGH_FOODS);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return (Integer)state.func_177229_b((Property)LEVEL);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, LEVEL});
    }

    public ISidedInventory func_219966_a(BlockState state, IWorld world, BlockPos pos) {
        return new TroughInventory(state, world, pos);
    }

    static {
        VoxelShape outside = Block.func_208617_a((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)10.0, (double)14.0);
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            SHAPES.put(dir, new ArrayList());
            for (int i = 0; i <= 4; ++i) {
                SHAPES.get(dir).add(VoxelShapeUtil.rotate((VoxelShape)VoxelShapes.func_197878_a((VoxelShape)outside, (VoxelShape)Block.func_208617_a((double)1.0, (double)(i * 2 + 1), (double)3.0, (double)15.0, (double)10.0, (double)13.0), (IBooleanFunction)IBooleanFunction.field_223234_e_), (Direction)dir));
            }
        }
    }

    static class TroughInventory
    extends Inventory
    implements ISidedInventory {
        private final BlockState state;
        private final int level;
        private final IWorld world;
        private final BlockPos pos;
        private boolean hasInserted = false;

        protected TroughInventory(BlockState state, IWorld world, BlockPos pos) {
            super(1);
            this.state = state;
            this.level = (Integer)state.func_177229_b((Property)LEVEL);
            this.world = world;
            this.pos = pos;
        }

        public int[] func_180463_a(Direction dir) {
            int[] nArray;
            if (dir == Direction.UP) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction dir) {
            return !this.hasInserted && this.level < 4 && dir == Direction.UP && TroughBlock.canUseItem(stack);
        }

        public boolean func_180461_b(int index, ItemStack stack, Direction dir) {
            return false;
        }

        public void func_70296_d() {
            ItemStack stackInThis = this.func_70301_a(0);
            if (!stackInThis.func_190926_b()) {
                this.hasInserted = true;
                TroughBlock.attemptFill(this.state, this.world, this.pos, stackInThis);
                this.func_70304_b(0);
            }
        }
    }
}

