/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class BlueSkiesConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ClientConfig CLIENT;
    public static final CommonConfig COMMON;

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)pair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        pair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)pair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    public static class CommonConfig {
        private final ForgeConfigSpec.ConfigValue<Boolean> logMissingRegistryObjectForDatapack;
        private final ForgeConfigSpec.ConfigValue<Integer> gatekeeperEmeraldCount;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> allowedModsForFeatureGen;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            this.logMissingRegistryObjectForDatapack = builder.comment("\n When loading files from datapacks, set this to true to log missing registry data for things like items.\n Default: false").define("log_missing_registry_data_for_datapacks", false);
            this.gatekeeperEmeraldCount = builder.comment("\n The emerald cost for the Zeal Lighter sold by the Gatekeeper.\n Default: 12").define("gatekeeper_emerald_count", (Object)8);
            this.allowedModsForFeatureGen = builder.comment("\n A list of mods that are allowed to generate features in our dimensions.\n Default: []\n Example: [\"minecraft\", \"blue_skies\", \"botania\"]").defineList("allowed_mods_for_feature_gen", (List)Lists.newArrayList(), o -> true);
        }

        public boolean shouldLogMissingRegistryObjectForDatapack() {
            return (Boolean)this.logMissingRegistryObjectForDatapack.get();
        }

        public int getGatekeeperEmeraldCount() {
            return (Integer)this.gatekeeperEmeraldCount.get();
        }

        public boolean isModAllowedForFeatureGen(String mod) {
            return ((List)this.allowedModsForFeatureGen.get()).contains(mod);
        }
    }

    public static class ClientConfig {
        private final ForgeConfigSpec.ConfigValue<Boolean> festivities;
        private final ForgeConfigSpec.ConfigValue<Boolean> customPanorama;
        private final ForgeConfigSpec.ConfigValue<Boolean> capBrightness;
        private final ForgeConfigSpec.ConfigValue<Boolean> useSimpleInventoryTabs;
        private final ForgeConfigSpec.ConfigValue<Integer> inventoryTabX;
        private final ForgeConfigSpec.ConfigValue<Integer> inventoryTabY;
        private final ForgeConfigSpec.ConfigValue<Boolean> verticalInventoryTabs;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.festivities = builder.comment("\n Whether or not festive cosmetic effects should happen.\n Default: true").define("festivities", true);
            this.customPanorama = builder.comment("\n Should blue skies override the title screen panorama.\n Default: true").define("custom_panorama", true);
            this.capBrightness = builder.comment("\n Whether or not brightness should be capped when inside the dimensions for aesthetic purposes.\n Default: true").define("cap_brightness", true);
            builder.push("Inventory Tab Settings");
            this.useSimpleInventoryTabs = builder.comment("\n If set to true, inventory tabs will use simple buttons that can be placed anywhere on the screen.\n Note: Placing on the left of the inventory is not suggested due to the recipe book.\n Default: false").define("use_simple_inventory_tabs", false);
            String extra = "\n This setting does nothing when use_simple_inventory_tabs is set to false.";
            this.inventoryTabX = builder.comment(extra + "\n The x position of the inventory tabs.\n Default: 88").define("inventory_tab_x", (Object)88);
            this.inventoryTabY = builder.comment(extra + "\n The y position of the inventory tabs.\n Default: 80").define("inventory_tab_y", (Object)80);
            this.verticalInventoryTabs = builder.comment(extra + "\n If set to true, inventory tabs are sorted vertically. If set to false, they are sorted horizontally.\n Default: true").define("vertical_inventory_tabs", true);
            builder.pop();
        }

        public boolean hasFestivities() {
            return (Boolean)this.festivities.get();
        }

        public boolean isPanoramaCustom() {
            return (Boolean)this.customPanorama.get();
        }

        public boolean shouldBrightnessCap() {
            return (Boolean)this.capBrightness.get();
        }

        public boolean useSimpleInventoryTabs() {
            return (Boolean)this.useSimpleInventoryTabs.get();
        }

        public int getInventoryTabX() {
            return (Integer)this.inventoryTabX.get();
        }

        public int getInventoryTabY() {
            return (Integer)this.inventoryTabY.get();
        }

        public boolean areInventoryTabsVertical() {
            return (Boolean)this.verticalInventoryTabs.get();
        }
    }
}

