/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.utility;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.constants.ModRegistries;
import com.davidm1a2.afraidofthedark.common.registry.bolt.BoltEntry;
import com.davidm1a2.afraidofthedark.common.registry.research.Research;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.PlayerEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/utility/BoltOrderHelper;", "", "()V", "getBoltAt", "Lcom/davidm1a2/afraidofthedark/common/registry/bolt/BoltEntry;", "index", "", "getNextBoltIndex", "entityPlayer", "Lnet/minecraft/entity/player/PlayerEntity;", "currentBoltIndex", "afraidofthedark"})
public final class BoltOrderHelper {
    @NotNull
    public static final BoltOrderHelper INSTANCE = new BoltOrderHelper();

    private BoltOrderHelper() {
    }

    public final int getNextBoltIndex(@NotNull PlayerEntity entityPlayer, int currentBoltIndex) {
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        int currentBoltIndex2 = currentBoltIndex;
        Research preRequisite = null;
        int boltTypeCount = ModRegistries.INSTANCE.getBOLTS().getEntries().size();
        do {
            int n;
            if ((currentBoltIndex2 = (n = currentBoltIndex2) + 1) < boltTypeCount) continue;
            currentBoltIndex2 = 0;
        } while ((preRequisite = this.getBoltAt(currentBoltIndex2).getPreRequisite()) != null && !CapabilityExtensionsKt.getResearch(entityPlayer).isResearched(preRequisite));
        return currentBoltIndex2;
    }

    @NotNull
    public final BoltEntry getBoltAt(int index) {
        Collection collection = ModRegistries.INSTANCE.getBOLTS().getValues();
        Intrinsics.checkNotNullExpressionValue(collection, "ModRegistries.BOLTS.values");
        Object t = CollectionsKt.elementAt(collection, index);
        Intrinsics.checkNotNullExpressionValue(t, "ModRegistries.BOLTS.values.elementAt(index)");
        return (BoltEntry)((Object)t);
    }
}

