/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.tileEntity;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.common.constants.ModBlocks;
import com.davidm1a2.afraidofthedark.common.constants.ModEntities;
import com.davidm1a2.afraidofthedark.common.constants.ModParticles;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.constants.ModTileEntities;
import com.davidm1a2.afraidofthedark.common.entity.enchantedFrog.EnchantedFrogEntity;
import com.davidm1a2.afraidofthedark.common.network.packets.otherPackets.ParticlePacket;
import com.davidm1a2.afraidofthedark.common.network.packets.packetHandler.PacketHandler;
import com.davidm1a2.afraidofthedark.common.tileEntity.core.AOTDTickingTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/tileEntity/DesertOasisTileEntity;", "Lcom/davidm1a2/afraidofthedark/common/tileEntity/core/AOTDTickingTileEntity;", "()V", "oasisBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "computeOasisBoundingBox", "", "spawnFrogs", "number", "", "tick", "Companion", "afraidofthedark"})
public final class DesertOasisTileEntity
extends AOTDTickingTileEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private AxisAlignedBB oasisBoundingBox;
    private static final int TICKS_INBETWEEN_CHECKS = 1200;
    private static final int MAX_NUMBER_OF_FROGS = 70;
    private static final int MAX_NUMBER_OF_FROGS_TO_SPAWN_AT_ONCE = 10;
    @NotNull
    private static final Set<Block> NON_SURFACE_BLOCKS;

    public DesertOasisTileEntity() {
        super(ModTileEntities.INSTANCE.getDESERT_OASIS());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        World world = this.field_145850_b;
        if (Intrinsics.areEqual(world == null ? null : Boolean.valueOf(world.field_72995_K), false) && this.getTicksExisted() % (long)1200 == 0L) {
            if (this.oasisBoundingBox == null) {
                this.computeOasisBoundingBox();
            }
            World world2 = this.field_145850_b;
            Intrinsics.checkNotNull(world2);
            World world3 = world2;
            world2 = this.oasisBoundingBox;
            if (world2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("oasisBoundingBox");
                throw null;
            }
            List enchantedFrogs = world3.func_217357_a(EnchantedFrogEntity.class, (AxisAlignedBB)world2);
            int numberOfFrogsToSpawn = RangesKt.coerceIn(70 - enchantedFrogs.size(), 0, 10);
            this.spawnFrogs(numberOfFrogsToSpawn);
        }
    }

    private final void computeOasisBoundingBox() {
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(this.field_174879_c).func_72314_b((double)ModSchematics.INSTANCE.getDESERT_OASIS().getWidth() / 2.0, 0.0, (double)ModSchematics.INSTANCE.getDESERT_OASIS().getLength() / 2.0).func_72321_a(0.0, (double)ModSchematics.INSTANCE.getDESERT_OASIS().getHeight() - (double)6, 0.0);
        Intrinsics.checkNotNullExpressionValue(axisAlignedBB, "AxisAlignedBB(pos).grow(\n            ModSchematics.DESERT_OASIS.getWidth() / 2.0,\n            0.0,\n            ModSchematics.DESERT_OASIS.getLength() / 2.0\n        ).expand(\n            0.0,\n            // The DesertOasis sits at y=6 (relative to 0,0,0) so don't look up past the bounds of the structure\n            ModSchematics.DESERT_OASIS.getHeight().toDouble() - 6,\n            0.0\n        )");
        this.oasisBoundingBox = axisAlignedBB;
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnFrogs(int number) {
        int n = 0;
        if (n < number) {
            do {
                Vec3d vec3d;
                int n2;
                Object object;
                int n3;
                int n4;
                int n5;
                Object object2;
                int ignored = n++;
                AxisAlignedBB axisAlignedBB = this.oasisBoundingBox;
                if (axisAlignedBB == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("oasisBoundingBox");
                    throw null;
                }
                axisAlignedBB = this.oasisBoundingBox;
                if (axisAlignedBB == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("oasisBoundingBox");
                    throw null;
                }
                int ellipseWidth = (int)axisAlignedBB.field_72336_d - (int)axisAlignedBB.field_72340_a;
                AxisAlignedBB axisAlignedBB2 = this.oasisBoundingBox;
                if (axisAlignedBB2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("oasisBoundingBox");
                    throw null;
                }
                axisAlignedBB2 = this.oasisBoundingBox;
                if (axisAlignedBB2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("oasisBoundingBox");
                    throw null;
                }
                int ellipseHeight = (int)axisAlignedBB2.field_72334_f - (int)axisAlignedBB2.field_72339_c;
                double d = Random.Default.nextDouble(0.0, Math.PI * 2);
                boolean bl = false;
                double x = Math.cos(d) * (double)ellipseWidth / (double)2 * Random.Default.nextDouble();
                double d2 = Random.Default.nextDouble(0.0, Math.PI * 2);
                boolean bl2 = false;
                double z = Math.sin(d2) * (double)ellipseHeight / (double)2 * Random.Default.nextDouble();
                AxisAlignedBB axisAlignedBB3 = this.oasisBoundingBox;
                if (axisAlignedBB3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("oasisBoundingBox");
                    throw null;
                }
                int xPos = (int)axisAlignedBB3.field_72340_a + ellipseWidth / 2 + (int)x;
                AxisAlignedBB axisAlignedBB4 = this.oasisBoundingBox;
                if (axisAlignedBB4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("oasisBoundingBox");
                    throw null;
                }
                int zPos = (int)axisAlignedBB4.field_72339_c + ellipseHeight / 2 + (int)z;
                int yPos = 0;
                AxisAlignedBB axisAlignedBB5 = this.oasisBoundingBox;
                if (axisAlignedBB5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("oasisBoundingBox");
                    throw null;
                }
                int n6 = (int)axisAlignedBB5.field_72337_e;
                AxisAlignedBB axisAlignedBB6 = this.oasisBoundingBox;
                if (axisAlignedBB6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("oasisBoundingBox");
                    throw null;
                }
                int n7 = (int)axisAlignedBB6.field_72338_b;
                if (n7 <= n6) {
                    int y22;
                    do {
                        y22 = n6--;
                        object2 = this.field_145850_b;
                        Intrinsics.checkNotNull(object2);
                        Block currentBlock = object2.func_180495_p(new BlockPos(xPos, y22, zPos)).func_177230_c();
                        if (Intrinsics.areEqual(currentBlock, Blocks.field_150355_j)) {
                            yPos = 0;
                            break;
                        }
                        if (NON_SURFACE_BLOCKS.contains(currentBlock)) continue;
                        yPos = y22;
                        break;
                    } while (y22 != n7);
                }
                if (yPos == 0) continue;
                World world = this.field_145850_b;
                Intrinsics.checkNotNull(world);
                if (!world.isAreaLoaded(new BlockPos(xPos, yPos, zPos), 0)) continue;
                n7 = 20;
                int y22 = 0;
                boolean bl3 = false;
                object2 = new ArrayList(n7);
                boolean bl4 = false;
                int n8 = 0;
                n8 = 0;
                int n9 = n7;
                while (n8 < n9) {
                    n5 = n8++;
                    n4 = 0;
                    n3 = n5;
                    object = object2;
                    n2 = 0;
                    vec3d = new Vec3d((double)xPos + 0.5, (double)yPos + 1.0, (double)zPos + 0.5);
                    ((ArrayList)object).add(vec3d);
                }
                List particlePositions = (List)object2;
                y22 = 20;
                bl3 = false;
                boolean bl5 = false;
                ArrayList arrayList = new ArrayList(y22);
                n8 = 0;
                n9 = 0;
                n9 = 0;
                n5 = y22;
                while (n9 < n5) {
                    void it;
                    n4 = n9++;
                    n3 = 0;
                    n2 = n4;
                    object = arrayList;
                    boolean bl6 = false;
                    double d3 = Math.toRadians(360.0 / (double)particlePositions.size() * (double)it);
                    boolean bl7 = false;
                    double d4 = Math.sin(d3) * 0.2;
                    d3 = Math.toRadians(360.0 / (double)particlePositions.size() * (double)it);
                    bl7 = false;
                    vec3d = new Vec3d(d4, 0.0, Math.cos(d3) * 0.2);
                    ((ArrayList)object).add(vec3d);
                }
                List particleSpeeds = arrayList;
                PacketHandler packetHandler = AfraidOfTheDark.Companion.getPacketHandler();
                ParticlePacket particlePacket = new ParticlePacket((IParticleData)ModParticles.INSTANCE.getENCHANTED_FROG_SPAWN(), particlePositions, particleSpeeds);
                double d5 = (double)xPos + 0.5;
                double d6 = (double)yPos + 0.5;
                double d7 = (double)zPos + 0.5;
                World y22 = this.field_145850_b;
                Intrinsics.checkNotNull(y22);
                packetHandler.sendToAllAround(particlePacket, new PacketDistributor.TargetPoint(d5, d6, d7, 100.0, y22.field_73011_w.func_186058_p()));
                EntityType<EnchantedFrogEntity> entityType = ModEntities.INSTANCE.getENCHANTED_FROG();
                object2 = this.field_145850_b;
                Intrinsics.checkNotNull(object2);
                Object object3 = object2;
                EnchantedFrogEntity frog = new EnchantedFrogEntity(entityType, (World)object3);
                frog.func_70107_b((double)xPos + 0.5, (double)yPos + 1.5, (double)zPos + 0.5);
                object3 = this.field_145850_b;
                Intrinsics.checkNotNull(object3);
                object3.func_217376_c((Entity)frog);
            } while (n < number);
        }
    }

    static {
        Block[] blockArray = new Block[]{Blocks.field_150350_a, (Block)ModBlocks.INSTANCE.getMANGROVE_LEAVES(), (Block)ModBlocks.INSTANCE.getSACRED_MANGROVE_LEAVES(), (Block)ModBlocks.INSTANCE.getMANGROVE(), (Block)ModBlocks.INSTANCE.getSACRED_MANGROVE()};
        NON_SURFACE_BLOCKS = SetsKt.setOf(blockArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/tileEntity/DesertOasisTileEntity$Companion;", "", "()V", "MAX_NUMBER_OF_FROGS", "", "MAX_NUMBER_OF_FROGS_TO_SPAWN_AT_ONCE", "NON_SURFACE_BLOCKS", "", "Lnet/minecraft/block/Block;", "kotlin.jvm.PlatformType", "TICKS_INBETWEEN_CHECKS", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

