/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell.component.powerSource;

import com.davidm1a2.afraidofthedark.common.constants.ModItems;
import com.davidm1a2.afraidofthedark.common.item.FlaskOfSoulsItem;
import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.spell.component.powerSource.base.AOTDSpellPowerSource;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/component/powerSource/FlaskSpellPowerSource;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/powerSource/base/AOTDSpellPowerSource;", "()V", "canCast", "", "entity", "Lnet/minecraft/entity/Entity;", "spell", "Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "consumePowerToCast", "", "getCostDescription", "", "getUnlocalizedOutOfPowerMsg", "afraidofthedark"})
public final class FlaskSpellPowerSource
extends AOTDSpellPowerSource {
    public FlaskSpellPowerSource() {
        super(new ResourceLocation("afraidofthedark", "flask"));
    }

    @Override
    public boolean canCast(@NotNull Entity entity, @NotNull Spell spell) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(spell, "spell");
        if (entity instanceof PlayerEntity) {
            NonNullList nonNullList = ((PlayerEntity)entity).field_71071_by.field_70462_a;
            Intrinsics.checkNotNullExpressionValue(nonNullList, "entity.inventory.mainInventory");
            Collection collection = (Collection)nonNullList;
            nonNullList = ((PlayerEntity)entity).field_71071_by.field_184439_c;
            Intrinsics.checkNotNullExpressionValue(nonNullList, "entity.inventory.offHandInventory");
            List<ItemStack> inventory = CollectionsKt.plus(collection, (Iterable)nonNullList);
            double remainingCost = spell.getCost();
            for (ItemStack stack : inventory) {
                if (!Intrinsics.areEqual(stack.func_77973_b(), (Object)ModItems.INSTANCE.getFLASK_OF_SOULS())) continue;
                FlaskOfSoulsItem flaskOfSoulsItem = ModItems.INSTANCE.getFLASK_OF_SOULS();
                Intrinsics.checkNotNullExpressionValue(stack, "stack");
                int killsRequired = flaskOfSoulsItem.getKillsRequired(stack);
                int kills = ModItems.INSTANCE.getFLASK_OF_SOULS().getKills(stack);
                double soulPower = (double)300 / (double)killsRequired;
                double powerAvailable = (double)kills * soulPower;
                if (remainingCost <= powerAvailable) {
                    return true;
                }
                remainingCost -= powerAvailable;
            }
        }
        return false;
    }

    @Override
    public void consumePowerToCast(@NotNull Entity entity, @NotNull Spell spell) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(spell, "spell");
        if (entity instanceof PlayerEntity) {
            NonNullList nonNullList = ((PlayerEntity)entity).field_71071_by.field_70462_a;
            Intrinsics.checkNotNullExpressionValue(nonNullList, "entity.inventory.mainInventory");
            Collection collection = (Collection)nonNullList;
            nonNullList = ((PlayerEntity)entity).field_71071_by.field_184439_c;
            Intrinsics.checkNotNullExpressionValue(nonNullList, "entity.inventory.offHandInventory");
            List<ItemStack> inventory = CollectionsKt.plus(collection, (Iterable)nonNullList);
            double remainingCost = spell.getCost();
            for (ItemStack stack : inventory) {
                if (!Intrinsics.areEqual(stack.func_77973_b(), (Object)ModItems.INSTANCE.getFLASK_OF_SOULS())) continue;
                FlaskOfSoulsItem flaskOfSoulsItem = ModItems.INSTANCE.getFLASK_OF_SOULS();
                Intrinsics.checkNotNullExpressionValue(stack, "stack");
                int killsRequired = flaskOfSoulsItem.getKillsRequired(stack);
                int kills = ModItems.INSTANCE.getFLASK_OF_SOULS().getKills(stack);
                double soulPower = (double)300 / (double)killsRequired;
                double powerAvailable = (double)kills * soulPower;
                if (remainingCost <= powerAvailable) {
                    while (remainingCost > 0.0) {
                        remainingCost -= soulPower;
                        ModItems.INSTANCE.getFLASK_OF_SOULS().addKills(stack, -1);
                    }
                    continue;
                }
                remainingCost -= powerAvailable;
                ModItems.INSTANCE.getFLASK_OF_SOULS().setKills(stack, 0);
            }
        }
    }

    @Override
    @NotNull
    public String getCostDescription() {
        return "A full Flask of Souls provides 300 spell power";
    }

    @Override
    @NotNull
    public String getUnlocalizedOutOfPowerMsg() {
        return "message.afraidofthedark.spell.power_source.flask.invalid_msg";
    }
}

