/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.spell;

import com.davidm1a2.afraidofthedark.common.spell.SpellStage;
import com.davidm1a2.afraidofthedark.common.spell.component.SpellComponentInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.SpellDeliveryMethod;
import com.davidm1a2.afraidofthedark.common.spell.component.deliveryMethod.base.SpellDeliveryMethodInstance;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffect;
import com.davidm1a2.afraidofthedark.common.spell.component.effect.base.SpellEffectInstance;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0002H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR!\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00070\u000e\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/SpellStage;", "Lnet/minecraftforge/common/util/INBTSerializable;", "Lnet/minecraft/nbt/CompoundNBT;", "()V", "spellStageNBT", "(Lnet/minecraft/nbt/CompoundNBT;)V", "deliveryInstance", "Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "Lcom/davidm1a2/afraidofthedark/common/spell/component/deliveryMethod/base/SpellDeliveryMethod;", "getDeliveryInstance", "()Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "setDeliveryInstance", "(Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;)V", "effects", "", "Lcom/davidm1a2/afraidofthedark/common/spell/component/effect/base/SpellEffect;", "getEffects", "()[Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "[Lcom/davidm1a2/afraidofthedark/common/spell/component/SpellComponentInstance;", "deserializeNBT", "", "nbt", "getCost", "", "isValid", "", "serializeNBT", "toString", "", "Companion", "afraidofthedark"})
public final class SpellStage
implements INBTSerializable<CompoundNBT> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private SpellComponentInstance<SpellDeliveryMethod> deliveryInstance;
    @NotNull
    private final SpellComponentInstance<SpellEffect>[] effects;
    @NotNull
    private static final String NBT_DELIVERY_METHOD = "delivery_method";
    @NotNull
    private static final String NBT_EFFECT_BASE = "effect_";
    private static final int MAX_EFFECTS_PER_STAGE = 4;

    @Nullable
    public final SpellComponentInstance<SpellDeliveryMethod> getDeliveryInstance() {
        return this.deliveryInstance;
    }

    public final void setDeliveryInstance(@Nullable SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance) {
        this.deliveryInstance = spellComponentInstance;
    }

    @NotNull
    public final SpellComponentInstance<SpellEffect>[] getEffects() {
        return this.effects;
    }

    public SpellStage() {
        this.effects = new SpellComponentInstance[4];
        this.deliveryInstance = null;
    }

    public SpellStage(@NotNull CompoundNBT spellStageNBT) {
        Intrinsics.checkNotNullParameter(spellStageNBT, "spellStageNBT");
        this.effects = new SpellComponentInstance[4];
        this.deserializeNBT(spellStageNBT);
    }

    public final double getCost() {
        if (this.isValid()) {
            SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = this.deliveryInstance;
            Intrinsics.checkNotNull(spellComponentInstance);
            SpellDeliveryMethod deliveryType = spellComponentInstance.getComponent();
            SpellComponentInstance<SpellEffect>[] spellComponentInstanceArray = this.deliveryInstance;
            Intrinsics.checkNotNull(spellComponentInstanceArray);
            double cost = deliveryType.getCost((SpellComponentInstance<SpellDeliveryMethod>)spellComponentInstanceArray);
            for (SpellComponentInstance<SpellEffect> effect : this.effects) {
                if (effect == null) continue;
                SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance2 = this.deliveryInstance;
                Intrinsics.checkNotNull(spellComponentInstance2);
                cost += deliveryType.getStageCostMultiplier(spellComponentInstance2) * effect.getComponent().getCost(effect);
            }
            return cost;
        }
        return 0.0;
    }

    public final boolean isValid() {
        return this.deliveryInstance != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance = this.deliveryInstance;
        if (spellComponentInstance != null) {
            SpellComponentInstance<SpellDeliveryMethod> spellComponentInstance2 = spellComponentInstance;
            boolean bl = false;
            boolean bl2 = false;
            SpellComponentInstance<SpellDeliveryMethod> it = spellComponentInstance2;
            boolean bl3 = false;
            nbt.func_218657_a(NBT_DELIVERY_METHOD, (INBT)it.serializeNBT());
        }
        SpellComponentInstance<SpellEffect>[] $this$forEachIndexed$iv = this.effects;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (SpellComponentInstance<SpellEffect> item$iv : $this$forEachIndexed$iv) {
            void effect;
            int n = index$iv++;
            SpellComponentInstance<SpellEffect> spellComponentInstance3 = item$iv;
            int i = n;
            boolean bl = false;
            void var12_15 = effect;
            if (var12_15 == null) continue;
            void var13_16 = var12_15;
            boolean bl4 = false;
            boolean bl5 = false;
            void it = var13_16;
            boolean bl6 = false;
            nbt.func_218657_a(Intrinsics.stringPlus(NBT_EFFECT_BASE, i), (INBT)it.serializeNBT());
        }
        return nbt;
    }

    public void deserializeNBT(@NotNull CompoundNBT nbt) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        if (nbt.func_74764_b(NBT_DELIVERY_METHOD)) {
            CompoundNBT compoundNBT = nbt.func_74775_l(NBT_DELIVERY_METHOD);
            Intrinsics.checkNotNullExpressionValue(compoundNBT, "nbt.getCompound(NBT_DELIVERY_METHOD)");
            this.deliveryInstance = SpellDeliveryMethodInstance.Companion.createFromNBT(compoundNBT);
        }
        if ((n2 = 0) <= (n = this.effects.length + -1)) {
            do {
                int i;
                if (!nbt.func_74764_b(Intrinsics.stringPlus(NBT_EFFECT_BASE, i = n2++))) continue;
                CompoundNBT compoundNBT = nbt.func_74775_l(Intrinsics.stringPlus(NBT_EFFECT_BASE, i));
                Intrinsics.checkNotNullExpressionValue(compoundNBT, "nbt.getCompound(NBT_EFFECT_BASE + i)");
                this.effects[i] = SpellEffectInstance.Companion.createFromNBT(compoundNBT);
            } while (n2 <= n);
        }
    }

    @NotNull
    public String toString() {
        SpellDeliveryMethod spellDeliveryMethod;
        ResourceLocation resourceLocation = this.deliveryInstance;
        SpellDeliveryMethod spellDeliveryMethod2 = spellDeliveryMethod = resourceLocation == null ? null : resourceLocation.getComponent();
        return (spellDeliveryMethod == null ? null : ((resourceLocation = spellDeliveryMethod.getRegistryName()) == null ? null : resourceLocation.func_110623_a())) + ": " + CollectionsKt.joinToString$default(ArraysKt.filterNotNull(this.effects), ", ", "[", "]", 0, null, toString.1.INSTANCE, 24, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/davidm1a2/afraidofthedark/common/spell/SpellStage$Companion;", "", "()V", "MAX_EFFECTS_PER_STAGE", "", "NBT_DELIVERY_METHOD", "", "NBT_EFFECT_BASE", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

