/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.registry.meteor;

import com.davidm1a2.afraidofthedark.common.registry.research.Research;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lcom/davidm1a2/afraidofthedark/common/registry/meteor/MeteorEntry;", "Lnet/minecraftforge/registries/ForgeRegistryEntry;", "icon", "Lnet/minecraft/util/ResourceLocation;", "minMeteorRadius", "", "maxMeteorRadius", "richnessPercent", "", "interiorBlock", "Lnet/minecraft/block/Block;", "preRequisite", "Lcom/davidm1a2/afraidofthedark/common/registry/research/Research;", "(Lnet/minecraft/util/ResourceLocation;IIDLnet/minecraft/block/Block;Lcom/davidm1a2/afraidofthedark/common/registry/research/Research;)V", "getIcon", "()Lnet/minecraft/util/ResourceLocation;", "getInteriorBlock", "()Lnet/minecraft/block/Block;", "getMaxMeteorRadius", "()I", "getMinMeteorRadius", "getPreRequisite", "()Lcom/davidm1a2/afraidofthedark/common/registry/research/Research;", "getRichnessPercent", "()D", "getUnlocalizedName", "", "Companion", "afraidofthedark"})
public abstract class MeteorEntry
extends ForgeRegistryEntry<MeteorEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation icon;
    private final int minMeteorRadius;
    private final int maxMeteorRadius;
    private final double richnessPercent;
    @NotNull
    private final Block interiorBlock;
    @NotNull
    private final Research preRequisite;
    private static final Logger logger = LogManager.getLogger();

    public MeteorEntry(@NotNull ResourceLocation icon, int minMeteorRadius, int maxMeteorRadius, double richnessPercent, @NotNull Block interiorBlock, @NotNull Research preRequisite) {
        Intrinsics.checkNotNullParameter(icon, "icon");
        Intrinsics.checkNotNullParameter(interiorBlock, "interiorBlock");
        Intrinsics.checkNotNullParameter((Object)preRequisite, "preRequisite");
        this.icon = icon;
        this.minMeteorRadius = minMeteorRadius;
        this.maxMeteorRadius = maxMeteorRadius;
        this.richnessPercent = richnessPercent;
        this.interiorBlock = interiorBlock;
        this.preRequisite = preRequisite;
        if (this.minMeteorRadius < 2) {
            logger.error("Meteor entries should not have a min radius less than 2!");
        }
        if (this.minMeteorRadius > this.maxMeteorRadius) {
            logger.error("Meteor entries max-radius should be larger than the min-radius!");
        }
    }

    @NotNull
    public final ResourceLocation getIcon() {
        return this.icon;
    }

    public final int getMinMeteorRadius() {
        return this.minMeteorRadius;
    }

    public final int getMaxMeteorRadius() {
        return this.maxMeteorRadius;
    }

    public final double getRichnessPercent() {
        return this.richnessPercent;
    }

    @NotNull
    public final Block getInteriorBlock() {
        return this.interiorBlock;
    }

    @NotNull
    public final Research getPreRequisite() {
        return this.preRequisite;
    }

    @NotNull
    public final String getUnlocalizedName() {
        StringBuilder stringBuilder = new StringBuilder().append("meteor_entry.");
        ResourceLocation resourceLocation = this.getRegistryName();
        Intrinsics.checkNotNull(resourceLocation);
        StringBuilder stringBuilder2 = stringBuilder.append((Object)resourceLocation.func_110624_b()).append('.');
        resourceLocation = this.getRegistryName();
        Intrinsics.checkNotNull(resourceLocation);
        return stringBuilder2.append((Object)resourceLocation.func_110623_a()).toString();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/davidm1a2/afraidofthedark/common/registry/meteor/MeteorEntry$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

