/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.IPlayerSpellManager;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItem;
import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/WandItem;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItem;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "getSpellId", "Ljava/util/UUID;", "itemStack", "hasSpellId", "", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "setSpellId", "spellId", "setSpellToFirstAvailable", "entityPlayer", "Companion", "afraidofthedark"})
public final class WandItem
extends AOTDItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NBT_SPELL_ID = "spell_id";

    public WandItem() {
        Item.Properties properties = new Item.Properties().func_200917_a(1);
        Intrinsics.checkNotNullExpressionValue(properties, "Properties().maxStackSize(1)");
        super("wand", properties, false, 4, null);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull PlayerEntity player, @NotNull Hand hand) {
        UUID spellId;
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(hand, "hand");
        ItemStack heldItem = player.func_184586_b(hand);
        IPlayerSpellManager spellManager = CapabilityExtensionsKt.getSpellManager(player);
        if (player.func_225608_bj_()) {
            Intrinsics.checkNotNullExpressionValue(heldItem, "heldItem");
            if (!this.hasSpellId(heldItem)) {
                this.setSpellToFirstAvailable(player, heldItem);
            } else {
                spellId = this.getSpellId(heldItem);
                Intrinsics.checkNotNull(spellId);
                Spell currentSpell = spellManager.getSpellById(spellId);
                if (currentSpell == null) {
                    this.setSpellToFirstAvailable(player, heldItem);
                } else {
                    int currentSpellIndex;
                    List<Spell> spells;
                    block16: {
                        int n;
                        List<Spell> $this$indexOfFirst$iv = spells = spellManager.getSpells();
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        Iterator<Spell> iterator2 = $this$indexOfFirst$iv.iterator();
                        while (iterator2.hasNext()) {
                            Spell item$iv;
                            Spell it = item$iv = iterator2.next();
                            boolean bl = false;
                            if (Intrinsics.areEqual(it.getId(), spellId)) {
                                n = index$iv;
                                break block16;
                            }
                            ++index$iv;
                        }
                        n = currentSpellIndex = -1;
                    }
                    if (currentSpellIndex + 1 < spells.size()) {
                        Spell next = spells.get(currentSpellIndex + 1);
                        this.setSpellId(heldItem, next.getId());
                        if (!world.field_72995_K) {
                            Object[] objectArray = new Object[]{next.getName()};
                            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark:wand.spell_set", objectArray));
                        }
                    } else {
                        this.setSpellToFirstAvailable(player, heldItem);
                    }
                }
            }
        } else if (!world.field_72995_K) {
            Intrinsics.checkNotNullExpressionValue(heldItem, "heldItem");
            spellId = this.getSpellId(heldItem);
            if (spellId != null) {
                Spell toCast = spellManager.getSpellById(spellId);
                if (toCast != null) {
                    Spell.attemptToCast$default(toCast, (Entity)player, null, 2, null);
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.wand.invalid_spell", new Object[0]));
                }
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.wand.no_bound_spell", new Object[0]));
            }
        }
        ActionResult actionResult = ActionResult.func_226251_d_((Object)heldItem);
        Intrinsics.checkNotNullExpressionValue(actionResult, "resultFail(heldItem)");
        return actionResult;
    }

    private final void setSpellToFirstAvailable(PlayerEntity entityPlayer, ItemStack itemStack) {
        IPlayerSpellManager spellManager = CapabilityExtensionsKt.getSpellManager(entityPlayer);
        Collection collection = spellManager.getSpells();
        boolean bl = false;
        if (!collection.isEmpty()) {
            Spell first = spellManager.getSpells().get(0);
            if (!entityPlayer.field_70170_p.field_72995_K) {
                Object[] objectArray = new Object[]{first.getName()};
                entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.wand.spell_set", objectArray));
            }
            this.setSpellId(itemStack, first.getId());
        } else if (!entityPlayer.field_70170_p.field_72995_K) {
            entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.wand.no_spells", new Object[0]));
        }
    }

    private final boolean hasSpellId(ItemStack itemStack) {
        return NBTHelper.INSTANCE.hasTag(itemStack, NBT_SPELL_ID);
    }

    private final void setSpellId(ItemStack itemStack, UUID spellId) {
        CompoundNBT compoundNBT = NBTUtil.func_186862_a((UUID)spellId);
        Intrinsics.checkNotNullExpressionValue(compoundNBT, "writeUniqueId(spellId)");
        NBTHelper.INSTANCE.setCompound(itemStack, NBT_SPELL_ID, compoundNBT);
    }

    private final UUID getSpellId(ItemStack itemStack) {
        UUID uUID;
        CompoundNBT uuidNBT = NBTHelper.INSTANCE.getCompound(itemStack, NBT_SPELL_ID);
        CompoundNBT compoundNBT = uuidNBT;
        if (compoundNBT == null) {
            uUID = null;
        } else {
            CompoundNBT compoundNBT2 = compoundNBT;
            boolean bl = false;
            boolean bl2 = false;
            CompoundNBT it = compoundNBT2;
            boolean bl3 = false;
            uUID = NBTUtil.func_186860_b((CompoundNBT)it);
        }
        return uUID;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(tooltip, "tooltip");
        Intrinsics.checkNotNullParameter(flag, "flag");
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && CapabilityExtensionsKt.getResearch((PlayerEntity)player).isResearched(ModResearches.INSTANCE.getENARIAS_SECRET())) {
            if (this.hasSpellId(stack)) {
                IPlayerSpellManager iPlayerSpellManager = CapabilityExtensionsKt.getSpellManager((PlayerEntity)player);
                Object[] objectArray = this.getSpellId(stack);
                Intrinsics.checkNotNull(objectArray);
                Spell spell = iPlayerSpellManager.getSpellById((UUID)objectArray);
                if (spell != null) {
                    objectArray = new Object[]{spell.getName()};
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.wand.spell_name", objectArray));
                    objectArray = new Object[]{spell.getCost()};
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.wand.spell_cost", objectArray));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.wand.spell_invalid", new Object[0]));
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.wand.no_spell", new Object[0]));
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.wand.set_spell", new Object[0]));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.dont_know_how_to_use", new Object[0]));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/WandItem$Companion;", "", "()V", "NBT_SPELL_ID", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

