/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.research.IPlayerResearch;
import com.davidm1a2.afraidofthedark.common.constants.ModRegistries;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDItem;
import com.davidm1a2.afraidofthedark.common.registry.research.Research;
import com.davidm1a2.afraidofthedark.common.utility.NBTHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0006J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0018\u00a8\u0006$"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/ResearchScrollItem;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDItem;", "()V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "fillItemGroup", "group", "Lnet/minecraft/item/ItemGroup;", "items", "Lnet/minecraft/util/NonNullList;", "getNumberParts", "", "itemStack", "getPartNumber", "getScrollResearch", "Lcom/davidm1a2/afraidofthedark/common/registry/research/Research;", "isPart", "", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "setScrollResearch", "research", "Companion", "afraidofthedark"})
public final class ResearchScrollItem
extends AOTDItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NBT_RESEARCH_ID = "research_id";
    @NotNull
    private static final String NBT_PART_NUMBER = "part_number";
    @NotNull
    private static final String NBT_NUMBER_PARTS = "number_parts";

    public ResearchScrollItem() {
        super("research_scroll", new Item.Properties(), false, 4, null);
    }

    public void func_150895_a(@NotNull ItemGroup group, @NotNull NonNullList<ItemStack> items) {
        Intrinsics.checkNotNullParameter(group, "group");
        Intrinsics.checkNotNullParameter(items, "items");
        if (this.func_194125_a(group)) {
            for (Research research : ModRegistries.INSTANCE.getRESEARCH()) {
                ItemStack itemStack = new ItemStack((IItemProvider)this, 1);
                Intrinsics.checkNotNullExpressionValue((Object)research, "research");
                this.setScrollResearch(itemStack, research);
                items.add((Object)itemStack);
            }
        }
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull PlayerEntity player, @NotNull Hand hand) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(hand, "hand");
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            IPlayerResearch playerResearch = CapabilityExtensionsKt.getResearch(player);
            Intrinsics.checkNotNullExpressionValue(itemStack, "itemStack");
            Research scrollResearch = this.getScrollResearch(itemStack);
            if (scrollResearch != null) {
                if (playerResearch.canResearch(scrollResearch)) {
                    if (!this.isPart(itemStack)) {
                        itemStack.func_190918_g(1);
                        playerResearch.setResearch(scrollResearch, true);
                        playerResearch.sync(player, true);
                    } else {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.research_scroll.incomplete", new Object[0]));
                    }
                } else if (!playerResearch.isResearched(scrollResearch)) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.research_scroll.cant_understand", new Object[0]));
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.research_scroll.already_researched", new Object[0]));
                }
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.research_scroll.corrupt", new Object[0]));
            }
        }
        ActionResult actionResult = super.func_77659_a(world, player, hand);
        Intrinsics.checkNotNullExpressionValue(actionResult, "super.onItemRightClick(world, player, hand)");
        return actionResult;
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(tooltip, "tooltip");
        Intrinsics.checkNotNullParameter(flag, "flag");
        Research scrollResearch = this.getScrollResearch(stack);
        if (scrollResearch != null) {
            if (this.isPart(stack)) {
                Object[] objectArray = new Object[]{this.getPartNumber(stack), this.getNumberParts(stack), new TranslationTextComponent(scrollResearch.getUnlocalizedName(), new Object[0])};
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.research_scroll.part", objectArray));
            } else {
                Object[] objectArray = new Object[]{I18n.func_135052_a((String)scrollResearch.getUnlocalizedName(), (Object[])new Object[0])};
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.research_scroll.complete", objectArray));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.research_scroll.corrupt", new Object[0]));
        }
    }

    public final void setScrollResearch(@NotNull ItemStack itemStack, @NotNull Research research) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter((Object)research, "research");
        NBTHelper.INSTANCE.setString(itemStack, NBT_RESEARCH_ID, String.valueOf(research.getRegistryName()));
    }

    public final boolean isPart(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        return NBTHelper.INSTANCE.hasTag(itemStack, NBT_NUMBER_PARTS) && NBTHelper.INSTANCE.hasTag(itemStack, NBT_PART_NUMBER);
    }

    public final int getNumberParts(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Integer n = NBTHelper.INSTANCE.getInteger(itemStack, NBT_NUMBER_PARTS);
        Intrinsics.checkNotNull(n);
        return n;
    }

    public final int getPartNumber(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Integer n = NBTHelper.INSTANCE.getInteger(itemStack, NBT_PART_NUMBER);
        Intrinsics.checkNotNull(n);
        return n;
    }

    @Nullable
    public final Research getScrollResearch(@NotNull ItemStack itemStack) {
        Research research;
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        if (NBTHelper.INSTANCE.hasTag(itemStack, NBT_RESEARCH_ID)) {
            IForgeRegistry<Research> iForgeRegistry = ModRegistries.INSTANCE.getRESEARCH();
            String string = NBTHelper.INSTANCE.getString(itemStack, NBT_RESEARCH_ID);
            Intrinsics.checkNotNull(string);
            research = (Research)iForgeRegistry.getValue(new ResourceLocation(string));
        } else {
            research = null;
        }
        return research;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/ResearchScrollItem$Companion;", "", "()V", "NBT_NUMBER_PARTS", "", "NBT_PART_NUMBER", "NBT_RESEARCH_ID", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

