/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.item;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.constants.ModArmorMaterials;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.item.core.AOTDArmorItem;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J*\u0010\u0012\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J \u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J0\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0005H\u0016\u00a8\u0006$"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/IgneousArmorItem;", "Lcom/davidm1a2/afraidofthedark/common/item/core/AOTDArmorItem;", "baseName", "", "equipmentSlot", "Lnet/minecraft/inventory/EquipmentSlotType;", "(Ljava/lang/String;Lnet/minecraft/inventory/EquipmentSlotType;)V", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "tooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "getArmorTexture", "entity", "Lnet/minecraft/entity/Entity;", "slot", "type", "getRatio", "", "onArmorTick", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "processDamage", "Lnet/minecraft/entity/LivingEntity;", "armorStack", "source", "Lnet/minecraft/util/DamageSource;", "amount", "", "Companion", "afraidofthedark"})
public final class IgneousArmorItem
extends AOTDArmorItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double KNOCKBACK_STRENGTH = 0.6;
    @NotNull
    private static final Set<DamageSource> FIRE_SOURCES;
    @NotNull
    private static final Set<DamageSource> TRUE_DAMAGE_SOURCES;

    public IgneousArmorItem(@NotNull String baseName, @NotNull EquipmentSlotType equipmentSlot) {
        Intrinsics.checkNotNullParameter(baseName, "baseName");
        Intrinsics.checkNotNullParameter(equipmentSlot, "equipmentSlot");
        IArmorMaterial iArmorMaterial = ModArmorMaterials.INSTANCE.getIGNEOUS();
        Item.Properties properties = new Item.Properties().func_200915_b(0);
        Intrinsics.checkNotNullExpressionValue(properties, "Properties().defaultMaxDamage(0)");
        super(baseName, iArmorMaterial, equipmentSlot, properties, false, 16, null);
    }

    @NotNull
    public String getArmorTexture(@NotNull ItemStack stack, @NotNull Entity entity, @NotNull EquipmentSlotType slot, @Nullable String type) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(slot, "slot");
        return slot == EquipmentSlotType.LEGS ? "afraidofthedark:textures/armor/igneous_2.png" : "afraidofthedark:textures/armor/igneous_1.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(tooltip, "tooltip");
        Intrinsics.checkNotNullParameter(flag, "flag");
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && CapabilityExtensionsKt.getResearch((PlayerEntity)player).isResearched(ModResearches.INSTANCE.getIGNEOUS())) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.magic_armor_never_breaks", new Object[0]));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.igneous_armor.effect", new Object[0]));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.afraidofthedark.dont_know_how_to_use", new Object[0]));
        }
    }

    public void onArmorTick(@NotNull ItemStack stack, @NotNull World world, @NotNull PlayerEntity player) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        if (player.func_70089_S() && player.func_70027_ad() && CapabilityExtensionsKt.getResearch(player).isResearched(ModResearches.INSTANCE.getIGNEOUS()) && this.isWearingFullArmor(player)) {
            player.func_70066_B();
        }
    }

    @Override
    public double processDamage(@NotNull LivingEntity entity, @NotNull ItemStack armorStack, @NotNull DamageSource source, float amount, @NotNull EquipmentSlotType slot) {
        Entity damageSourceEntity;
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(armorStack, "armorStack");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(slot, "slot");
        if (!(entity instanceof PlayerEntity)) {
            return 0.0;
        }
        if (!CapabilityExtensionsKt.getResearch((PlayerEntity)entity).isResearched(ModResearches.INSTANCE.getIGNEOUS())) {
            return 0.0;
        }
        if (this.isWearingFullArmor((PlayerEntity)entity) && slot == EquipmentSlotType.CHEST && (damageSourceEntity = source.func_76346_g()) != null) {
            damageSourceEntity.func_70015_d(5);
            Vec3d direction = damageSourceEntity.func_174791_d().func_178788_d(((PlayerEntity)entity).func_174791_d()).func_72432_b().func_186678_a(0.6);
            damageSourceEntity.func_70024_g(direction.field_72450_a, direction.field_72448_b, direction.field_72449_c);
        }
        if (TRUE_DAMAGE_SOURCES.contains(source)) {
            return 0.0;
        }
        double protectionRatio = this.getRatio(slot);
        if (FIRE_SOURCES.contains(source)) {
            return protectionRatio;
        }
        if (Intrinsics.areEqual(source, DamageSource.field_76371_c)) {
            return protectionRatio * 0.9;
        }
        if (Intrinsics.areEqual(source, DamageSource.field_76379_h)) {
            return protectionRatio * 0.7;
        }
        return protectionRatio * (double)0.96f;
    }

    private final double getRatio(EquipmentSlotType slot) {
        double d;
        int totalProtection = 20;
        EquipmentSlotType equipmentSlotType = slot;
        int n = WhenMappings.$EnumSwitchMapping$0[equipmentSlotType.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                d = 3.0 / (double)totalProtection;
                break;
            }
            case 3: {
                d = 6.0 / (double)totalProtection;
                break;
            }
            case 4: {
                d = 8.0 / (double)totalProtection;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    static {
        DamageSource[] damageSourceArray = new DamageSource[]{DamageSource.field_76372_a, DamageSource.field_76370_b};
        FIRE_SOURCES = SetsKt.setOf(damageSourceArray);
        damageSourceArray = new DamageSource[]{DamageSource.field_76369_e, DamageSource.field_76368_d, DamageSource.field_76380_i, DamageSource.field_76366_f};
        TRUE_DAMAGE_SOURCES = SetsKt.setOf(damageSourceArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/davidm1a2/afraidofthedark/common/item/IgneousArmorItem$Companion;", "", "()V", "FIRE_SOURCES", "", "Lnet/minecraft/util/DamageSource;", "kotlin.jvm.PlatformType", "KNOCKBACK_STRENGTH", "", "TRUE_DAMAGE_SOURCES", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EquipmentSlotType.values().length];
            nArray[EquipmentSlotType.HEAD.ordinal()] = 1;
            nArray[EquipmentSlotType.FEET.ordinal()] = 2;
            nArray[EquipmentSlotType.LEGS.ordinal()] = 3;
            nArray[EquipmentSlotType.CHEST.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

