/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.feature.tree;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J>\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002JT\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002JL\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002JL\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014\u00a8\u0006\u0018"}, d2={"Lcom/davidm1a2/afraidofthedark/common/feature/tree/MangroveTreeFeature;", "Lnet/minecraft/world/gen/feature/AbstractTreeFeature;", "Lnet/minecraft/world/gen/feature/TreeFeatureConfig;", "()V", "generateBase", "Lnet/minecraft/util/math/BlockPos;", "world", "Lnet/minecraft/world/gen/IWorldGenerationReader;", "pos", "random", "Ljava/util/Random;", "logPositions", "", "boundingBox", "Lnet/minecraft/util/math/MutableBoundingBox;", "config", "generateBranches", "", "topOfTrunk", "leafPositions", "generateLeafCluster", "location", "place", "", "afraidofthedark"})
public final class MangroveTreeFeature
extends AbstractTreeFeature<TreeFeatureConfig> {
    public MangroveTreeFeature() {
        super(MangroveTreeFeature::_init_$lambda-0);
        this.setRegistryName("afraidofthedark", "mangrove_tree");
    }

    protected boolean place(@NotNull IWorldGenerationReader world, @NotNull Random random, @NotNull BlockPos pos, @NotNull Set<BlockPos> logPositions, @NotNull Set<BlockPos> leafPositions, @NotNull MutableBoundingBox boundingBox, @NotNull TreeFeatureConfig config) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(random, "random");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(logPositions, "logPositions");
        Intrinsics.checkNotNullParameter(leafPositions, "leafPositions");
        Intrinsics.checkNotNullParameter(boundingBox, "boundingBox");
        Intrinsics.checkNotNullParameter(config, "config");
        BlockPos topOfTrunk = this.generateBase(world, pos, random, logPositions, boundingBox, config);
        this.generateBranches(world, topOfTrunk, random, pos, logPositions, leafPositions, boundingBox, config);
        return true;
    }

    private final BlockPos generateBase(IWorldGenerationReader world, BlockPos pos, Random random, Set<BlockPos> logPositions, MutableBoundingBox boundingBox, TreeFeatureConfig config) {
        int heightBeforeTrunk = random.nextInt(4) + 4;
        int n = 0;
        int numRoots = random.nextInt(5) + 4;
        if (n < numRoots) {
            do {
                int i = n++;
                Direction xOffsetDirection = random.nextBoolean() ? Direction.NORTH : Direction.SOUTH;
                Direction zOffsetDirection = random.nextBoolean() ? Direction.EAST : Direction.WEST;
                int xDistanceFromTrunk = random.nextInt(3) + 3;
                int zDistanceFromTrunk = random.nextInt(3) + 3;
                BlockPos currentPos = pos.func_177967_a(xOffsetDirection, xDistanceFromTrunk).func_177967_a(zOffsetDirection, zDistanceFromTrunk);
                int n2 = 0;
                if (n2 < heightBeforeTrunk) {
                    do {
                        int n3;
                        int j = n2++;
                        if (xDistanceFromTrunk != 0 && random.nextBoolean()) {
                            currentPos = currentPos.func_177972_a(xOffsetDirection.func_176734_d());
                            n3 = xDistanceFromTrunk;
                            xDistanceFromTrunk = n3 + -1;
                        }
                        if (zDistanceFromTrunk != 0 && random.nextBoolean()) {
                            currentPos = currentPos.func_177972_a(zOffsetDirection.func_176734_d());
                            n3 = zDistanceFromTrunk;
                            zDistanceFromTrunk = n3 + -1;
                        }
                        this.func_227216_a_(world, random, currentPos, logPositions, boundingBox, (BaseTreeFeatureConfig)config);
                        if (random.nextDouble() < 0.1) {
                            this.func_227216_a_(world, random, random.nextBoolean() ? currentPos.func_177984_a() : currentPos.func_177977_b(), logPositions, boundingBox, (BaseTreeFeatureConfig)config);
                        }
                        currentPos = currentPos.func_177984_a();
                    } while (n2 < heightBeforeTrunk);
                }
                while (xDistanceFromTrunk > 0 || zDistanceFromTrunk > 0) {
                    if (xDistanceFromTrunk != 0) {
                        currentPos = currentPos.func_177972_a(xOffsetDirection.func_176734_d());
                        n2 = xDistanceFromTrunk;
                        xDistanceFromTrunk = n2 + -1;
                    }
                    if (zDistanceFromTrunk != 0) {
                        currentPos = currentPos.func_177972_a(zOffsetDirection.func_176734_d());
                        n2 = zDistanceFromTrunk;
                        zDistanceFromTrunk = n2 + -1;
                    }
                    this.func_227216_a_(world, random, currentPos, logPositions, boundingBox, (BaseTreeFeatureConfig)config);
                }
            } while (n < numRoots);
        }
        int trunkHeight = random.nextInt(4) + 6;
        BlockPos currentPos = pos.func_177981_b(heightBeforeTrunk);
        int n4 = 0;
        if (n4 < trunkHeight) {
            do {
                int i = n4++;
                if (random.nextDouble() < 0.1) {
                    currentPos = currentPos.func_177972_a(Direction.func_176731_b((int)random.nextInt(4)));
                }
                this.func_227216_a_(world, random, currentPos, logPositions, boundingBox, (BaseTreeFeatureConfig)config);
                currentPos = currentPos.func_177984_a();
            } while (n4 < trunkHeight);
        }
        BlockPos blockPos = currentPos;
        Intrinsics.checkNotNullExpressionValue(blockPos, "currentPos");
        return blockPos;
    }

    private final void generateBranches(IWorldGenerationReader world, BlockPos topOfTrunk, Random random, BlockPos pos, Set<BlockPos> logPositions, Set<BlockPos> leafPositions, MutableBoundingBox boundingBox, TreeFeatureConfig config) {
        this.generateLeafCluster(world, random, pos, logPositions, leafPositions, boundingBox, config);
        int numBranches = random.nextInt(3) + 3;
        int n = 0;
        if (n < numBranches) {
            do {
                int i = n++;
                Direction branchDir1 = Direction.func_176731_b((int)random.nextInt(4));
                Direction branchDir2 = random.nextBoolean() ? branchDir1.func_176746_e() : branchDir1.func_176735_f();
                int branchLength = random.nextInt(5) + 3;
                BlockPos currentBranchPos = topOfTrunk.func_177972_a(random.nextBoolean() ? branchDir1 : branchDir2);
                int n2 = 0;
                if (n2 < branchLength) {
                    do {
                        int j = n2++;
                        this.func_227216_a_(world, random, currentBranchPos, logPositions, boundingBox, (BaseTreeFeatureConfig)config);
                        if (random.nextDouble() < 0.1) {
                            BlockPos blockPos = currentBranchPos;
                            Intrinsics.checkNotNullExpressionValue(blockPos, "currentBranchPos");
                            this.generateLeafCluster(world, random, blockPos, logPositions, leafPositions, boundingBox, config);
                        }
                        currentBranchPos = currentBranchPos.func_177972_a(random.nextBoolean() ? branchDir1 : branchDir2);
                        if (!(random.nextDouble() < 0.2)) continue;
                        currentBranchPos = currentBranchPos.func_177984_a();
                    } while (n2 < branchLength);
                }
                BlockPos blockPos = currentBranchPos;
                Intrinsics.checkNotNullExpressionValue(blockPos, "currentBranchPos");
                this.generateLeafCluster(world, random, blockPos, logPositions, leafPositions, boundingBox, config);
            } while (n < numBranches);
        }
    }

    private final void generateLeafCluster(IWorldGenerationReader world, Random random, BlockPos location, Set<BlockPos> logPositions, Set<BlockPos> leafPositions, MutableBoundingBox boundingBox, TreeFeatureConfig config) {
        this.func_227216_a_(world, random, location, logPositions, boundingBox, (BaseTreeFeatureConfig)config);
        int n = -2;
        do {
            int x = n++;
            int n2 = -1;
            do {
                int y = n2++;
                int n3 = -2;
                do {
                    int z = n3++;
                    BlockPos leafPos = location.func_177982_a(x, y, z);
                    double d = leafPos.func_177951_i((Vec3i)location);
                    boolean bl = false;
                    double d2 = Math.sqrt(d);
                    double d3 = y == 0 ? 2.5 : 2.0;
                    if (!(d2 < d3) || !(random.nextDouble() < 0.9)) continue;
                    if (random.nextDouble() < 0.03) {
                        int i;
                        this.func_227216_a_(world, random, leafPos, logPositions, boundingBox, (BaseTreeFeatureConfig)config);
                        int vineLength = random.nextInt(3) + 2;
                        int n4 = 1;
                        if (n4 > vineLength) continue;
                        do {
                            i = n4++;
                            this.func_227219_b_(world, random, leafPos.func_177979_c(i), leafPositions, boundingBox, (BaseTreeFeatureConfig)config);
                        } while (i != vineLength);
                        continue;
                    }
                    this.func_227219_b_(world, random, leafPos, leafPositions, boundingBox, (BaseTreeFeatureConfig)config);
                } while (n3 <= 2);
            } while (n2 <= 1);
        } while (n <= 2);
    }

    private static final TreeFeatureConfig _init_$lambda-0(Dynamic it) {
        return TreeFeatureConfig.func_227338_a_((Dynamic)it);
    }
}

