/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.feature.structure.crypt;

import com.davidm1a2.afraidofthedark.common.constants.ModBiomes;
import com.davidm1a2.afraidofthedark.common.constants.ModCommonConfiguration;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.feature.structure.base.AOTDStructure;
import com.davidm1a2.afraidofthedark.common.feature.structure.base.MultiplierConfig;
import com.davidm1a2.afraidofthedark.common.feature.structure.crypt.CryptStructure;
import com.davidm1a2.afraidofthedark.common.feature.structure.crypt.CryptStructureStart;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/davidm1a2/afraidofthedark/common/feature/structure/crypt/CryptStructure;", "Lcom/davidm1a2/afraidofthedark/common/feature/structure/base/AOTDStructure;", "Lcom/davidm1a2/afraidofthedark/common/feature/structure/base/MultiplierConfig;", "()V", "canFitAt", "", "chunkGen", "Lnet/minecraft/world/gen/ChunkGenerator;", "biomeManager", "Lnet/minecraft/world/biome/BiomeManager;", "random", "Ljava/util/Random;", "xPos", "", "zPos", "getLength", "getStartFactory", "Lnet/minecraft/world/gen/feature/structure/Structure$IStartFactory;", "getStructureName", "", "getWidth", "setupStructureIn", "", "biome", "Lnet/minecraft/world/biome/Biome;", "Companion", "afraidofthedark"})
public final class CryptStructure
extends AOTDStructure<MultiplierConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<Biome.Category> INCOMPATIBLE_BIOMES;

    public CryptStructure() {
        super(1.INSTANCE, false, 2, null);
    }

    @Override
    @NotNull
    public String func_143025_a() {
        return "afraidofthedark:crypt";
    }

    @Override
    public int getWidth() {
        return ModSchematics.INSTANCE.getCRYPT().getWidth();
    }

    @Override
    public int getLength() {
        return ModSchematics.INSTANCE.getCRYPT().getLength();
    }

    @Override
    public void setupStructureIn(@NotNull Biome biome) {
        Intrinsics.checkNotNullParameter(biome, "biome");
        if (!INCOMPATIBLE_BIOMES.contains(biome.func_201856_r())) {
            if (Intrinsics.areEqual(biome, (Object)ModBiomes.INSTANCE.getEERIE_FOREST())) {
                this.addToBiome(biome, (IFeatureConfig)new MultiplierConfig(10));
            } else {
                this.addToBiome(biome, (IFeatureConfig)new MultiplierConfig(1));
            }
        } else {
            this.addToBiome(biome, (IFeatureConfig)new MultiplierConfig(0));
        }
    }

    @NotNull
    public Structure.IStartFactory func_214557_a() {
        return CryptStructure::getStartFactory$lambda-0;
    }

    @Override
    public boolean canFitAt(@NotNull ChunkGenerator<?> chunkGen, @NotNull BiomeManager biomeManager, @NotNull Random random, int xPos, int zPos) {
        Intrinsics.checkNotNullParameter(chunkGen, "chunkGen");
        Intrinsics.checkNotNullParameter(biomeManager, "biomeManager");
        Intrinsics.checkNotNullParameter(random, "random");
        Integer n = (Integer)SequencesKt.minOrNull(SequencesKt.map(AOTDStructure.getInteriorConfigEstimate$default(this, xPos, zPos, chunkGen, biomeManager, 0, 0, 48, null), canFitAt.biomeMultiplier.1.INSTANCE));
        int biomeMultiplier2 = n == null ? 0 : n;
        double chance = this.getOneInNValidChunks(350) * ModCommonConfiguration.INSTANCE.getCryptMultiplier() * (double)biomeMultiplier2;
        if (random.nextDouble() >= chance) {
            return false;
        }
        Sequence heights = AOTDStructure.getEdgeHeights$afraidofthedark$default(this, xPos, zPos, chunkGen, 0, 0, 24, null);
        Integer n2 = (Integer)SequencesKt.maxOrNull(heights);
        Intrinsics.checkNotNull(n2);
        int maxHeight = n2;
        Integer n3 = (Integer)SequencesKt.minOrNull(heights);
        Intrinsics.checkNotNull(n3);
        int minHeight = n3;
        return maxHeight - minHeight <= 5;
    }

    private static final StructureStart getStartFactory$lambda-0(Structure structure, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int reference, long seed) {
        Intrinsics.checkNotNullExpressionValue(structure, "structure");
        Intrinsics.checkNotNullExpressionValue(mutableBoundingBox, "mutableBoundingBox");
        return new CryptStructureStart(structure, chunkX, chunkZ, mutableBoundingBox, reference, seed);
    }

    static {
        Biome.Category[] categoryArray = new Biome.Category[]{Biome.Category.BEACH, Biome.Category.EXTREME_HILLS, Biome.Category.ICY, Biome.Category.NETHER, Biome.Category.OCEAN, Biome.Category.RIVER, Biome.Category.THEEND, Biome.Category.NONE, Biome.Category.MUSHROOM, Biome.Category.SWAMP};
        INCOMPATIBLE_BIOMES = SetsKt.setOf(categoryArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/davidm1a2/afraidofthedark/common/feature/structure/crypt/CryptStructure$Companion;", "", "()V", "INCOMPATIBLE_BIOMES", "", "Lnet/minecraft/world/biome/Biome$Category;", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

