/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.event;

import com.davidm1a2.afraidofthedark.client.sound.EerieEchoSound;
import com.davidm1a2.afraidofthedark.client.sound.NightmareChaseMusicSound;
import com.davidm1a2.afraidofthedark.client.sound.NightmareMusicSound;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.dimension.IPlayerNightmareData;
import com.davidm1a2.afraidofthedark.common.capabilities.player.research.IPlayerResearch;
import com.davidm1a2.afraidofthedark.common.constants.ModBlocks;
import com.davidm1a2.afraidofthedark.common.constants.ModDimensions;
import com.davidm1a2.afraidofthedark.common.constants.ModEffects;
import com.davidm1a2.afraidofthedark.common.constants.ModEntities;
import com.davidm1a2.afraidofthedark.common.constants.ModItems;
import com.davidm1a2.afraidofthedark.common.constants.ModResearches;
import com.davidm1a2.afraidofthedark.common.constants.ModSchematics;
import com.davidm1a2.afraidofthedark.common.dimension.IslandUtility;
import com.davidm1a2.afraidofthedark.common.dimension.PlayerTeleportExtensionsKt;
import com.davidm1a2.afraidofthedark.common.entity.enaria.GhastlyEnariaEntity;
import com.davidm1a2.afraidofthedark.common.feature.structure.base.SchematicStructurePiece;
import java.util.Random;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ChestScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0018H\u0007J \u0010\u0019\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010!\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002\u00a8\u0006'"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/NightmareHandler;", "", "()V", "createNamedJournal", "Lnet/minecraft/item/ItemStack;", "entityPlayer", "Lnet/minecraft/entity/player/PlayerEntity;", "onChunkUnloadEvent", "", "event", "Lnet/minecraftforge/event/world/ChunkEvent$Unload;", "onEntityJoinWorldEvent", "Lnet/minecraftforge/event/entity/EntityJoinWorldEvent;", "onGuiOpen", "Lnet/minecraftforge/client/event/GuiOpenEvent;", "onNightmareWorldTick", "Lnet/minecraftforge/event/TickEvent$WorldTickEvent;", "onPlayerRespawnEvent", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerRespawnEvent;", "onPlayerSleepInBedEvent", "Lnet/minecraftforge/event/entity/player/PlayerSleepInBedEvent;", "onPostEntityTravelToDimension", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerChangedDimensionEvent;", "onPreEntityTravelToDimension", "Lnet/minecraftforge/event/entity/EntityTravelToDimensionEvent;", "processPostTeleport", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "dimensionFrom", "Lnet/minecraft/world/dimension/DimensionType;", "dimensionTo", "processPreTeleport", "", "resetPlayerStats", "testForEnariasAltar", "nightmareWorld", "Lnet/minecraft/world/server/ServerWorld;", "islandPos", "Lnet/minecraft/util/math/BlockPos;", "Companion", "afraidofthedark"})
public final class NightmareHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int VALID_SPAWN_SEARCH_DISTANCE = 6;

    @SubscribeEvent
    public final void onNightmareWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.SERVER) {
            World world = event.world;
            if (Intrinsics.areEqual(world.field_73011_w.func_186058_p(), ModDimensions.INSTANCE.getNIGHTMARE_TYPE()) && world.func_82737_E() % (long)20 == 0L) {
                if (world == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.world.server.ServerWorld");
                }
                ((ServerWorld)world).getEntities().filter(NightmareHandler::onNightmareWorldTick$lambda-0).map(NightmareHandler::onNightmareWorldTick$lambda-1).filter(NightmareHandler::onNightmareWorldTick$lambda-2).forEach(arg_0 -> NightmareHandler.onNightmareWorldTick$lambda-3(world, arg_0));
            }
        }
    }

    @SubscribeEvent
    public final void onPlayerSleepInBedEvent(@NotNull PlayerSleepInBedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        PlayerEntity entityPlayer = event.getPlayer();
        if (!entityPlayer.field_70170_p.field_72995_K && entityPlayer.func_70660_b((Effect)ModEffects.INSTANCE.getSLEEPING()) != null) {
            Intrinsics.checkNotNullExpressionValue(entityPlayer, "entityPlayer");
            IPlayerResearch playerResearch = CapabilityExtensionsKt.getResearch(entityPlayer);
            if (playerResearch.canResearch(ModResearches.INSTANCE.getNIGHTMARE())) {
                playerResearch.setResearch(ModResearches.INSTANCE.getNIGHTMARE(), true);
                playerResearch.sync(entityPlayer, true);
            }
            if (playerResearch.isResearched(ModResearches.INSTANCE.getNIGHTMARE())) {
                event.setResult(PlayerEntity.SleepResult.OTHER_PROBLEM);
                PlayerTeleportExtensionsKt.teleport((ServerPlayerEntity)entityPlayer, ModDimensions.INSTANCE.getNIGHTMARE_TYPE());
            }
        }
    }

    @SubscribeEvent
    public final void onChunkUnloadEvent(@NotNull ChunkEvent.Unload event) {
        IChunk chunk;
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getWorld().func_201670_d() && Intrinsics.areEqual(event.getWorld().func_201675_m().func_186058_p(), ModDimensions.INSTANCE.getNIGHTMARE_TYPE()) && (chunk = event.getChunk()) instanceof Chunk) {
            ClassInheritanceMultiMap[] classInheritanceMultiMapArray = ((Chunk)chunk).func_177429_s();
            Intrinsics.checkNotNullExpressionValue(classInheritanceMultiMapArray, "chunk.entityLists");
            ClassInheritanceMultiMap[] classInheritanceMultiMapArray2 = classInheritanceMultiMapArray;
            int n = 0;
            int n2 = classInheritanceMultiMapArray2.length;
            while (n < n2) {
                ClassInheritanceMultiMap entityMap = classInheritanceMultiMapArray2[n];
                ++n;
                for (Entity entity : entityMap) {
                    if (!(entity instanceof GhastlyEnariaEntity) || !((GhastlyEnariaEntity)entity).func_70089_S()) continue;
                    entity.func_70106_y();
                    PlayerEntity entityPlayer = event.getWorld().func_217362_a(entity, 500.0);
                    if (entityPlayer == null || !entityPlayer.func_70089_S()) continue;
                    Random random = entityPlayer.func_70681_au();
                    int offsetX = random.nextBoolean() ? random.nextInt(26) - 50 : random.nextInt(26) + 25;
                    int offsetZ = random.nextBoolean() ? random.nextInt(26) - 50 : random.nextInt(26) + 25;
                    int posX = entityPlayer.func_180425_c().func_177958_n() + offsetX;
                    int posZ = entityPlayer.func_180425_c().func_177952_p() + offsetZ;
                    EntityType<GhastlyEnariaEntity> entityType = ModEntities.INSTANCE.getGHASTLY_ENARIA();
                    World world = event.getWorld().func_201672_e();
                    Intrinsics.checkNotNullExpressionValue(world, "event.world.world");
                    GhastlyEnariaEntity newEnaria = new GhastlyEnariaEntity(entityType, world);
                    newEnaria.setBenign(!CapabilityExtensionsKt.getResearch(entityPlayer).isResearched(ModResearches.INSTANCE.getENARIA()));
                    newEnaria.func_70107_b(posX, entityPlayer.func_226278_cu_(), posZ);
                    event.getWorld().func_217376_c((Entity)newEnaria);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public final void onPlayerRespawnEvent(@NotNull PlayerEvent.PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getPlayer().field_70170_p.field_72995_K && Intrinsics.areEqual(event.getPlayer().field_71093_bK, ModDimensions.INSTANCE.getNIGHTMARE_TYPE())) {
            PlayerEntity playerEntity = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(playerEntity, "event.player");
            IPlayerNightmareData nightmareData = CapabilityExtensionsKt.getNightmareData(playerEntity);
            playerEntity = event.getPlayer();
            if (playerEntity == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.ServerPlayerEntity");
            }
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)playerEntity;
            playerEntity = nightmareData.getPreTeleportDimension();
            Intrinsics.checkNotNull(playerEntity);
            PlayerTeleportExtensionsKt.teleport(serverPlayerEntity, (DimensionType)playerEntity);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public final void onEntityJoinWorldEvent(@NotNull EntityJoinWorldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getWorld().field_72995_K) {
            Entity entity = event.getEntity();
            if (Intrinsics.areEqual(event.getWorld().field_73011_w.func_186058_p().getModType(), (Object)ModDimensions.INSTANCE.getNIGHTMARE()) && Intrinsics.areEqual(entity, Minecraft.func_71410_x().field_71439_g) && Intrinsics.areEqual(entity.field_70170_p.field_73011_w.func_186058_p().getModType(), (Object)ModDimensions.INSTANCE.getNIGHTMARE())) {
                SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
                soundHandler.func_147681_a((ISound)new EerieEchoSound(), 60);
                soundHandler.func_147681_a((ISound)new NightmareMusicSound(), 140);
                soundHandler.func_147681_a((ISound)new NightmareChaseMusicSound(), 140);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public final void onGuiOpen(@NotNull GuiOpenEvent event) {
        ITextComponent title;
        Screen gui;
        DimensionType dimensionType;
        ClientPlayerEntity player;
        Intrinsics.checkNotNullParameter(event, "event");
        ClientPlayerEntity clientPlayerEntity = player = Minecraft.func_71410_x().field_71439_g;
        if (Intrinsics.areEqual(clientPlayerEntity == null ? null : ((dimensionType = clientPlayerEntity.field_71093_bK) == null ? null : dimensionType.getModType()), (Object)ModDimensions.INSTANCE.getNIGHTMARE()) && (gui = event.getGui()) instanceof ChestScreen && (title = ((ChestScreen)gui).getTitle()) instanceof TranslationTextComponent) {
            String string = ((TranslationTextComponent)title).func_150268_i();
            Intrinsics.checkNotNullExpressionValue(string, "title.key");
            if (StringsKt.contains$default((CharSequence)string, "enderchest", false, 2, null)) {
                ((ChestContainer)((ChestScreen)gui).func_212873_a_()).func_75134_a((PlayerEntity)player);
                event.setCanceled(true);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.nightmare.enderchest", new Object[0]));
            }
        }
    }

    @SubscribeEvent
    public final void onPreEntityTravelToDimension(@NotNull EntityTravelToDimensionEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getEntity().field_70170_p.field_72995_K) {
            DimensionType fromDimension = event.getEntity().field_71093_bK;
            DimensionType toDimension = event.getDimension();
            if (event.getEntity() instanceof ServerPlayerEntity) {
                Entity entity = event.getEntity();
                if (entity == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.ServerPlayerEntity");
                }
                ServerPlayerEntity entityPlayer = (ServerPlayerEntity)entity;
                Intrinsics.checkNotNullExpressionValue(fromDimension, "fromDimension");
                Intrinsics.checkNotNullExpressionValue(toDimension, "toDimension");
                if (this.processPreTeleport(entityPlayer, fromDimension, toDimension)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    private final boolean processPreTeleport(ServerPlayerEntity entityPlayer, DimensionType dimensionFrom, DimensionType dimensionTo) {
        if (Intrinsics.areEqual(dimensionTo, ModDimensions.INSTANCE.getNIGHTMARE_TYPE())) {
            if (Intrinsics.areEqual(dimensionFrom, ModDimensions.INSTANCE.getNIGHTMARE_TYPE())) {
                return true;
            }
            IPlayerNightmareData playerNightmareData = CapabilityExtensionsKt.getNightmareData((PlayerEntity)entityPlayer);
            World world = entityPlayer.field_70170_p;
            Intrinsics.checkNotNullExpressionValue(world, "entityPlayer.world");
            World world2 = world;
            world = entityPlayer.func_180425_c();
            Intrinsics.checkNotNullExpressionValue(world, "entityPlayer.position");
            if (IslandUtility.INSTANCE.isValidSpawnLocation(world2, (BlockPos)world)) {
                playerNightmareData.setPreTeleportPosition(entityPlayer.func_180425_c());
            } else {
                World world3 = entityPlayer.field_70170_p;
                Intrinsics.checkNotNullExpressionValue(world3, "entityPlayer.world");
                World world4 = world3;
                world3 = entityPlayer.func_180425_c();
                Intrinsics.checkNotNullExpressionValue(world3, "entityPlayer.position");
                BlockPos preTeleportPosition = IslandUtility.INSTANCE.findValidSpawnLocation(world4, (BlockPos)world3, 6);
                if (preTeleportPosition == null) {
                    entityPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.dimension.nightmare.no_spawn", new Object[0]));
                    return true;
                }
                playerNightmareData.setPreTeleportPosition(preTeleportPosition);
            }
            playerNightmareData.setPreTeleportDimension(dimensionFrom);
            ListNBT inventoryNBT = entityPlayer.field_71071_by.func_70442_a(new ListNBT());
            playerNightmareData.setPreTeleportPlayerInventory(inventoryNBT);
            entityPlayer.field_71071_by.func_174888_l();
            entityPlayer.field_71069_bz.func_75142_b();
        }
        return false;
    }

    @SubscribeEvent
    public final void onPostEntityTravelToDimension(@NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            DimensionType fromDimension = event.getFrom();
            DimensionType toDimension = event.getTo();
            PlayerEntity playerEntity = event.getPlayer();
            if (playerEntity == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.ServerPlayerEntity");
            }
            ServerPlayerEntity entityPlayer = (ServerPlayerEntity)playerEntity;
            Intrinsics.checkNotNullExpressionValue(fromDimension, "fromDimension");
            Intrinsics.checkNotNullExpressionValue(toDimension, "toDimension");
            this.processPostTeleport(entityPlayer, fromDimension, toDimension);
        }
    }

    private final void processPostTeleport(ServerPlayerEntity entityPlayer, DimensionType dimensionFrom, DimensionType dimensionTo) {
        IPlayerNightmareData playerNightmareData = CapabilityExtensionsKt.getNightmareData((PlayerEntity)entityPlayer);
        if (Intrinsics.areEqual(dimensionTo, ModDimensions.INSTANCE.getNIGHTMARE_TYPE())) {
            MinecraftServer minecraftServer = entityPlayer.field_71133_b;
            Intrinsics.checkNotNull(minecraftServer);
            ServerWorld nightmareWorld = minecraftServer.func_71218_a(ModDimensions.INSTANCE.getNIGHTMARE_TYPE());
            Intrinsics.checkNotNullExpressionValue(nightmareWorld, "nightmareWorld");
            int indexToGoTo = IslandUtility.INSTANCE.getOrAssignPlayerPositionalIndex((World)nightmareWorld, playerNightmareData);
            int playerXBase = indexToGoTo * 1000;
            entityPlayer.field_71135_a.func_147364_a((double)playerXBase + 21.5, 74.0, 44.5, 0.0f, 0.0f);
            this.resetPlayerStats((PlayerEntity)entityPlayer);
            entityPlayer.field_71071_by.func_70441_a(this.createNamedJournal((PlayerEntity)entityPlayer));
            entityPlayer.field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModItems.INSTANCE.getINSANITYS_HEIGHTS()));
            entityPlayer.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Blocks.field_150478_aa, 64));
            this.testForEnariasAltar(entityPlayer, nightmareWorld, new BlockPos(playerXBase, 0, 0));
        }
        if (Intrinsics.areEqual(dimensionFrom, ModDimensions.INSTANCE.getNIGHTMARE_TYPE())) {
            BlockPos indexToGoTo = playerNightmareData.getPreTeleportPosition();
            Intrinsics.checkNotNull(indexToGoTo);
            BlockPos preTeleportPosition = indexToGoTo;
            entityPlayer.field_71135_a.func_147364_a((double)preTeleportPosition.func_177958_n() + 0.5, (double)preTeleportPosition.func_177956_o() + 1.5, (double)preTeleportPosition.func_177952_p() + 0.5, 0.0f, 0.0f);
            this.resetPlayerStats((PlayerEntity)entityPlayer);
            int numberNightmareStones = RangesKt.coerceAtMost(entityPlayer.field_71071_by.func_195408_a(NightmareHandler::processPostTeleport$lambda-4, -1), 64);
            entityPlayer.field_71071_by.func_174888_l();
            PlayerInventory playerInventory = entityPlayer.field_71071_by;
            ListNBT listNBT = playerNightmareData.getPreTeleportPlayerInventory();
            Intrinsics.checkNotNull(listNBT);
            playerInventory.func_70443_b(listNBT);
            if (numberNightmareStones > 0) {
                entityPlayer.field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModItems.INSTANCE.getNIGHTMARE_STONE(), numberNightmareStones));
            }
            entityPlayer.field_71069_bz.func_75142_b();
        }
    }

    private final void resetPlayerStats(PlayerEntity entityPlayer) {
        entityPlayer.func_213317_d(new Vec3d(0.0, 0.0, 0.0));
        entityPlayer.func_70606_j(20.0f);
        entityPlayer.func_71024_bL().func_75114_a(20);
        entityPlayer.func_195061_cb();
    }

    private final ItemStack createNamedJournal(PlayerEntity entityPlayer) {
        ItemStack toReturn = new ItemStack((IItemProvider)ModItems.INSTANCE.getJOURNAL(), 1);
        ModItems.INSTANCE.getJOURNAL().setOwner(toReturn, entityPlayer.func_146103_bH().getName());
        return toReturn;
    }

    private final void testForEnariasAltar(ServerPlayerEntity entityPlayer, ServerWorld nightmareWorld, BlockPos islandPos) {
        IPlayerResearch playerResearch = CapabilityExtensionsKt.getResearch((PlayerEntity)entityPlayer);
        if (playerResearch.isResearched(ModResearches.INSTANCE.getENARIA()) && nightmareWorld.func_180495_p(islandPos.func_177982_a(101, 74, 233)).func_177230_c() != ModBlocks.INSTANCE.getENARIAS_ALTAR()) {
            int posX = islandPos.func_177958_n() + 67;
            int posY = islandPos.func_177956_o() + 40;
            int posZ = islandPos.func_177952_p() + 179;
            Random throwawayRandom = new Random();
            SchematicStructurePiece enariasAltar = new SchematicStructurePiece(posX, posY, posZ, throwawayRandom, ModSchematics.INSTANCE.getENARIAS_ALTAR(), null, Direction.NORTH);
            IWorld iWorld = (IWorld)nightmareWorld;
            ChunkGenerator chunkGenerator = nightmareWorld.func_72863_F().func_201711_g();
            Intrinsics.checkNotNullExpressionValue(chunkGenerator, "nightmareWorld.chunkProvider.chunkGenerator");
            enariasAltar.func_225577_a_(iWorld, chunkGenerator, throwawayRandom, new MutableBoundingBox(posX, posZ, posX + ModSchematics.INSTANCE.getENARIAS_ALTAR().getWidth(), posZ + ModSchematics.INSTANCE.getENARIAS_ALTAR().getLength()), new ChunkPos(0, 0));
        }
    }

    private static final boolean onNightmareWorldTick$lambda-0(Entity it) {
        Entity entity = it;
        return Intrinsics.areEqual(entity == null ? null : entity.func_200600_R(), ModEntities.INSTANCE.getGHASTLY_ENARIA());
    }

    private static final GhastlyEnariaEntity onNightmareWorldTick$lambda-1(Entity it) {
        if (it == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.davidm1a2.afraidofthedark.common.entity.enaria.GhastlyEnariaEntity");
        }
        return (GhastlyEnariaEntity)it;
    }

    private static final boolean onNightmareWorldTick$lambda-2(GhastlyEnariaEntity it) {
        return it.getTouchedPlayer() != null;
    }

    private static final void onNightmareWorldTick$lambda-3(World $world, GhastlyEnariaEntity it) {
        ServerWorld serverWorld = (ServerWorld)$world;
        UUID uUID = it.getTouchedPlayer();
        Intrinsics.checkNotNull(uUID);
        Entity player = serverWorld.func_217461_a(uUID);
        if (player != null && player instanceof ServerPlayerEntity) {
            it.func_174812_G();
            ((ServerPlayerEntity)player).func_184210_p();
            ((ServerPlayerEntity)player).field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModItems.INSTANCE.getNIGHTMARE_STONE()));
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
            uUID = CapabilityExtensionsKt.getNightmareData((PlayerEntity)player).getPreTeleportDimension();
            Intrinsics.checkNotNull(uUID);
            PlayerTeleportExtensionsKt.teleport(serverPlayerEntity, (DimensionType)uUID);
        }
        it.clearTouchedPlayer();
    }

    private static final boolean processPostTeleport$lambda-4(ItemStack it) {
        return Intrinsics.areEqual(it.func_77973_b(), (Object)ModItems.INSTANCE.getNIGHTMARE_STONE());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/davidm1a2/afraidofthedark/common/event/NightmareHandler$Companion;", "", "()V", "VALID_SPAWN_SEARCH_DISTANCE", "", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

