/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.entity.enaria.fight.events;

import com.davidm1a2.afraidofthedark.common.entity.enaria.fight.EnariaFight;
import com.davidm1a2.afraidofthedark.common.entity.enaria.fight.events.EnariaFightEvent;
import com.davidm1a2.afraidofthedark.common.entity.enaria.fight.events.EnariaFightEvents;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0002J\b\u0010\u0011\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/davidm1a2/afraidofthedark/common/entity/enaria/fight/events/LavaRiseFightEvent;", "Lcom/davidm1a2/afraidofthedark/common/entity/enaria/fight/events/EnariaFightEvent;", "fight", "Lcom/davidm1a2/afraidofthedark/common/entity/enaria/fight/EnariaFight;", "(Lcom/davidm1a2/afraidofthedark/common/entity/enaria/fight/EnariaFight;)V", "currentLavaLevel", "", "ticksUntilEnd", "ticksUntilNextLevel", "deserializeNBT", "", "nbt", "Lnet/minecraft/nbt/CompoundNBT;", "forceStop", "isOver", "", "lowerLavaLevel", "raiseLavaLevel", "serializeNBT", "start", "tick", "Companion", "afraidofthedark"})
public final class LavaRiseFightEvent
extends EnariaFightEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int currentLavaLevel;
    private int ticksUntilNextLevel;
    private int ticksUntilEnd;
    @NotNull
    private static final String NBT_CURRENT_LAVA_LEVEL = "current_lava_level";
    @NotNull
    private static final String NBT_TICKS_UNTIL_NEXT_LEVEL = "ticks_until_next_level";
    @NotNull
    private static final String NBT_TICKS_UNTIL_END = "ticks_until_end";
    private static final int MAX_LAVA_LEVEL = 3;
    private static final int TICKS_BETWEEN_LEVELS = 60;
    private static final int MIN_EVENT_TIME_SEC = 30;
    private static final int MAX_EVENT_TIME_SEC = 40;

    public LavaRiseFightEvent(@NotNull EnariaFight fight) {
        Intrinsics.checkNotNullParameter(fight, "fight");
        super(fight, EnariaFightEvents.LavaRise);
    }

    @Override
    public void start() {
        this.currentLavaLevel = 0;
        this.ticksUntilNextLevel = 1;
        this.ticksUntilEnd = Random.Default.nextInt(600, 800);
    }

    @Override
    public void forceStop() {
        while (this.currentLavaLevel > 0) {
            this.lowerLavaLevel();
            --this.currentLavaLevel;
        }
        this.lowerLavaLevel();
        this.ticksUntilEnd = 0;
    }

    @Override
    public void tick() {
        if (this.ticksUntilEnd > 0 && this.currentLavaLevel == 3) {
            --this.ticksUntilEnd;
            return;
        }
        --this.ticksUntilNextLevel;
        if (this.ticksUntilNextLevel == 0) {
            this.ticksUntilNextLevel = 60;
            if (this.ticksUntilEnd > 0 && this.currentLavaLevel < 3) {
                this.raiseLavaLevel();
                ++this.currentLavaLevel;
            } else if (this.ticksUntilEnd == 0 && this.currentLavaLevel >= 0) {
                --this.currentLavaLevel;
                this.lowerLavaLevel();
            }
        }
    }

    @Override
    public boolean isOver() {
        return this.ticksUntilEnd <= 0 && this.currentLavaLevel == 0;
    }

    private final void raiseLavaLevel() {
        World world = this.getFight().getEnaria().field_70170_p;
        this.iterateOverRegion(this.relativeToAbsolutePosition(-30, -1 + this.currentLavaLevel, -3), this.relativeToAbsolutePosition(30, -1 + this.currentLavaLevel, 79), (Function1<? super BlockPos, Unit>)new Function1<BlockPos, Unit>(world){
            final /* synthetic */ World $world;
            {
                this.$world = $world;
                super(1);
            }

            public final void invoke(@NotNull BlockPos it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (this.$world.func_180495_p(it).isAir((IBlockReader)this.$world, it)) {
                    this.$world.func_175656_a(it, Blocks.field_150353_l.func_176223_P());
                }
            }
        });
    }

    private final void lowerLavaLevel() {
        World world = this.getFight().getEnaria().field_70170_p;
        this.iterateOverRegion(this.relativeToAbsolutePosition(-30, -1 + this.currentLavaLevel, -3), this.relativeToAbsolutePosition(30, -1 + this.currentLavaLevel, 79), (Function1<? super BlockPos, Unit>)new Function1<BlockPos, Unit>(world){
            final /* synthetic */ World $world;
            {
                this.$world = $world;
                super(1);
            }

            public final void invoke(@NotNull BlockPos it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (Intrinsics.areEqual(this.$world.func_180495_p(it).func_177230_c(), Blocks.field_150353_l)) {
                    this.$world.func_175656_a(it, Blocks.field_150350_a.func_176223_P());
                }
            }
        });
    }

    @Override
    @NotNull
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74768_a(NBT_CURRENT_LAVA_LEVEL, this.currentLavaLevel);
        nbt.func_74768_a(NBT_TICKS_UNTIL_NEXT_LEVEL, this.ticksUntilNextLevel);
        nbt.func_74768_a(NBT_TICKS_UNTIL_END, this.ticksUntilEnd);
        return nbt;
    }

    @Override
    public void deserializeNBT(@NotNull CompoundNBT nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.deserializeNBT(nbt);
        this.currentLavaLevel = nbt.func_74762_e(NBT_CURRENT_LAVA_LEVEL);
        this.ticksUntilNextLevel = nbt.func_74762_e(NBT_TICKS_UNTIL_NEXT_LEVEL);
        this.ticksUntilEnd = nbt.func_74762_e(NBT_TICKS_UNTIL_END);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/entity/enaria/fight/events/LavaRiseFightEvent$Companion;", "", "()V", "MAX_EVENT_TIME_SEC", "", "MAX_LAVA_LEVEL", "MIN_EVENT_TIME_SEC", "NBT_CURRENT_LAVA_LEVEL", "", "NBT_TICKS_UNTIL_END", "NBT_TICKS_UNTIL_NEXT_LEVEL", "TICKS_BETWEEN_LEVELS", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

