/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.crafting;

import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.registry.research.Research;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 )*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\u0001)B\u0015\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0096\u0001J!\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00142\u000e\u0010\u0010\u001a\n \u0015*\u0004\u0018\u00010\u00030\u0003H\u0096\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0011\u0010\u0018\u001a\n \u0015*\u0004\u0018\u00010\u00190\u0019H\u0096\u0001J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u0011\u0010\u001d\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014H\u0096\u0001J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001b2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0019\u0010 \u001a\u0012\u0012\u0002\b\u0003 \u0015*\b\u0012\u0002\b\u0003\u0018\u00010!0!H\u0096\u0001J\f\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0016J\b\u0010$\u001a\u00020\u000fH\u0016J\u001a\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u00032\b\u0010'\u001a\u0004\u0018\u00010(H\u0016R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006*"}, d2={"Lcom/davidm1a2/afraidofthedark/common/crafting/ResearchRequiredRecipeBase;", "T", "Lnet/minecraft/item/crafting/IRecipe;", "Lnet/minecraft/inventory/CraftingInventory;", "Lnet/minecraft/item/crafting/ICraftingRecipe;", "baseRecipe", "preRequisite", "Lcom/davidm1a2/afraidofthedark/common/registry/research/Research;", "(Lnet/minecraft/item/crafting/IRecipe;Lcom/davidm1a2/afraidofthedark/common/registry/research/Research;)V", "getBaseRecipe", "()Lnet/minecraft/item/crafting/IRecipe;", "Lnet/minecraft/item/crafting/IRecipe;", "getPreRequisite$afraidofthedark", "()Lcom/davidm1a2/afraidofthedark/common/registry/research/Research;", "canFit", "", "p0", "", "p1", "getCraftingResult", "Lnet/minecraft/item/ItemStack;", "kotlin.jvm.PlatformType", "getGroup", "", "getId", "Lnet/minecraft/util/ResourceLocation;", "getIngredients", "Lnet/minecraft/util/NonNullList;", "Lnet/minecraft/item/crafting/Ingredient;", "getRecipeOutput", "getRemainingItems", "inventory", "getSerializer", "Lnet/minecraft/item/crafting/IRecipeSerializer;", "getType", "Lnet/minecraft/item/crafting/IRecipeType;", "isDynamic", "matches", "inv", "world", "Lnet/minecraft/world/World;", "Companion", "afraidofthedark"})
public abstract class ResearchRequiredRecipeBase<T extends IRecipe<CraftingInventory>>
implements IRecipe<CraftingInventory>,
ICraftingRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final T baseRecipe;
    @NotNull
    private final Research preRequisite;
    private static final Logger logger = LogManager.getLogger();

    public ResearchRequiredRecipeBase(@NotNull T baseRecipe, @NotNull Research preRequisite) {
        Intrinsics.checkNotNullParameter(baseRecipe, "baseRecipe");
        Intrinsics.checkNotNullParameter((Object)preRequisite, "preRequisite");
        this.baseRecipe = baseRecipe;
        this.preRequisite = preRequisite;
    }

    @NotNull
    public final T getBaseRecipe() {
        return this.baseRecipe;
    }

    @NotNull
    public final Research getPreRequisite$afraidofthedark() {
        return this.preRequisite;
    }

    public boolean func_194133_a(int p0, int p1) {
        return this.baseRecipe.func_194133_a(p0, p1);
    }

    public ItemStack getCraftingResult(CraftingInventory p0) {
        return this.baseRecipe.func_77572_b((IInventory)p0);
    }

    public ResourceLocation func_199560_c() {
        return this.baseRecipe.func_199560_c();
    }

    public ItemStack func_77571_b() {
        return this.baseRecipe.func_77571_b();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return this.baseRecipe.func_199559_b();
    }

    public boolean matches(@NotNull CraftingInventory inv, @Nullable World world) {
        Intrinsics.checkNotNullParameter(inv, "inv");
        boolean matches2 = this.baseRecipe.func_77569_a((IInventory)inv, world);
        PlayerEntity craftingPlayer = ResearchRequiredRecipeBase.Companion.findPlayer(inv);
        if (craftingPlayer != null && !CapabilityExtensionsKt.getResearch(craftingPlayer).isResearched(this.preRequisite)) {
            if (matches2 && !craftingPlayer.field_70170_p.field_72995_K) {
                craftingPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.crafting.missing_research", new Object[0]));
            }
            return false;
        }
        return matches2;
    }

    public boolean func_192399_d() {
        return true;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingInventory inventory) {
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        NonNullList nonNullList = this.baseRecipe.func_179532_b((IInventory)inventory);
        Intrinsics.checkNotNullExpressionValue(nonNullList, "baseRecipe.getRemainingItems(inventory)");
        return nonNullList;
    }

    @NotNull
    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonNullList = this.baseRecipe.func_192400_c();
        Intrinsics.checkNotNullExpressionValue(nonNullList, "baseRecipe.ingredients");
        return nonNullList;
    }

    @NotNull
    public String func_193358_e() {
        String string = this.baseRecipe.func_193358_e();
        Intrinsics.checkNotNullExpressionValue(string, "baseRecipe.group");
        return string;
    }

    @NotNull
    public IRecipeType<?> func_222127_g() {
        IRecipeType iRecipeType = super.func_222127_g();
        Intrinsics.checkNotNullExpressionValue(iRecipeType, "super.getType()");
        return iRecipeType;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/davidm1a2/afraidofthedark/common/crafting/ResearchRequiredRecipeBase$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "findPlayer", "Lnet/minecraft/entity/player/PlayerEntity;", "inventory", "Lnet/minecraft/inventory/CraftingInventory;", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        private final PlayerEntity findPlayer(CraftingInventory inventory) {
            try {
                Container container;
                Container container2 = (Container)ObfuscationReflectionHelper.getPrivateValue(CraftingInventory.class, (Object)inventory, (String)"field_70465_c");
                Intrinsics.checkNotNull(container2);
                Container container3 = container = container2;
                if (container3 instanceof PlayerContainer) {
                    return (PlayerEntity)ObfuscationReflectionHelper.getPrivateValue(PlayerContainer.class, (Object)container3, (String)"field_82862_h");
                }
                if (container3 instanceof WorkbenchContainer) {
                    return (PlayerEntity)ObfuscationReflectionHelper.getPrivateValue(WorkbenchContainer.class, (Object)container3, (String)"field_192390_i");
                }
            }
            catch (IllegalAccessException e) {
                logger.error(Intrinsics.stringPlus("Could not find the player crafting the recipe, error was: ", ExceptionUtils.getStackTrace((Throwable)e)));
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

