/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.capabilities.world.structure;

import com.davidm1a2.afraidofthedark.common.capabilities.world.structure.StructureGridPos;
import com.davidm1a2.afraidofthedark.common.capabilities.world.structure.StructureGridSize;
import com.davidm1a2.afraidofthedark.common.capabilities.world.structure.StructureMap;
import com.davidm1a2.afraidofthedark.common.capabilities.world.structure.StructureMapNode;
import com.davidm1a2.afraidofthedark.common.feature.structure.base.AOTDStructure;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010J\"\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015J6\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0002H\u0016J4\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/davidm1a2/afraidofthedark/common/capabilities/world/structure/StructureMap;", "Lnet/minecraftforge/common/util/INBTSerializable;", "Lnet/minecraft/nbt/CompoundNBT;", "()V", "random", "Lnet/minecraft/util/SharedSeedRandom;", "root", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/structure/StructureMapNode;", "deserializeNBT", "", "nbt", "getStructureCenterIn", "Lnet/minecraft/util/math/BlockPos;", "chunkPos", "Lnet/minecraft/util/math/ChunkPos;", "structure", "Lnet/minecraft/world/gen/feature/structure/Structure;", "planStructuresIn", "biomeManager", "Lnet/minecraft/world/biome/BiomeManager;", "chunkGenerator", "Lnet/minecraft/world/gen/ChunkGenerator;", "previousNode", "gridSize", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/structure/StructureGridSize;", "serializeNBT", "tryPlacingStructuresFor", "node", "Companion", "afraidofthedark"})
public final class StructureMap
implements INBTSerializable<CompoundNBT> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SharedSeedRandom random = new SharedSeedRandom();
    @Nullable
    private StructureMapNode root;
    @NotNull
    private static final String NBT_ROOT = "root";
    @NotNull
    private static final Lazy<Map<StructureGridSize, List<AOTDStructure<?>>>> GRID_SIZE_TO_STRUCTURES$delegate = LazyKt.lazy(Companion.GRID_SIZE_TO_STRUCTURES.2.INSTANCE);

    @Nullable
    public final BlockPos getStructureCenterIn(@NotNull ChunkPos chunkPos, @NotNull Structure<?> structure) {
        Intrinsics.checkNotNullParameter(chunkPos, "chunkPos");
        Intrinsics.checkNotNullParameter(structure, "structure");
        StructureGridSize currentGridSize = StructureGridSize.Companion.getLARGEST_GRID_SIZE();
        StructureMapNode currentGridNode = this.root;
        do {
            StructureMapNode structureMapNode;
            Intrinsics.checkNotNull(currentGridNode);
            if (currentGridNode.hasStructure()) {
                if (Intrinsics.areEqual(currentGridNode.getStructure(), structure)) {
                    BlockPos blockPos = currentGridNode.getStructurePos();
                    Intrinsics.checkNotNull(blockPos);
                    BlockPos structurePos = blockPos;
                    ChunkPos structureChunkPos = new ChunkPos(structurePos);
                    if (Intrinsics.areEqual(structureChunkPos, chunkPos)) {
                        return structurePos;
                    }
                }
                return null;
            }
            Intrinsics.checkNotNull((Object)currentGridSize);
            currentGridSize = currentGridSize.getNextSizeDown();
            if (currentGridSize == null) continue;
            StructureGridPos relativeChildGridPos = currentGridSize.toRelativeGridPos(chunkPos);
            int childXQuadrant = Math.floorMod(relativeChildGridPos.getX(), 2);
            int childZQuadrant = Math.floorMod(relativeChildGridPos.getZ(), 2);
            if (childXQuadrant == 0 && childZQuadrant == 0) {
                structureMapNode = currentGridNode.getLowerLeftChild();
            } else if (childXQuadrant == 1 && childZQuadrant == 0) {
                structureMapNode = currentGridNode.getLowerRightChild();
            } else if (childXQuadrant == 0 && childZQuadrant == 1) {
                structureMapNode = currentGridNode.getUpperLeftChild();
            } else if (childXQuadrant == 1 && childZQuadrant == 1) {
                structureMapNode = currentGridNode.getUpperRightChild();
            } else {
                throw new IllegalStateException("Quadrant (" + childXQuadrant + ", " + childZQuadrant + ") is not valid.");
            }
            currentGridNode = structureMapNode;
        } while (currentGridSize != null);
        return null;
    }

    public final void planStructuresIn(@NotNull ChunkPos chunkPos, @NotNull BiomeManager biomeManager, @NotNull ChunkGenerator<?> chunkGenerator) {
        Intrinsics.checkNotNullParameter(chunkPos, "chunkPos");
        Intrinsics.checkNotNullParameter(biomeManager, "biomeManager");
        Intrinsics.checkNotNullParameter(chunkGenerator, "chunkGenerator");
        this.planStructuresIn(chunkPos, biomeManager, chunkGenerator, null, StructureGridSize.Companion.getLARGEST_GRID_SIZE());
    }

    private final void planStructuresIn(ChunkPos chunkPos, BiomeManager biomeManager, ChunkGenerator<?> chunkGenerator, StructureMapNode previousNode, StructureGridSize gridSize) {
        StructureMapNode structureMapNode;
        if (previousNode == null) {
            StructureMapNode structureMapNode2;
            if (this.root == null) {
                structureMapNode2 = this.root = new StructureMapNode();
                Intrinsics.checkNotNull(structureMapNode2);
                this.tryPlacingStructuresFor(structureMapNode2, chunkPos, biomeManager, chunkGenerator, gridSize);
            }
            structureMapNode2 = this.root;
            Intrinsics.checkNotNull(structureMapNode2);
            structureMapNode = structureMapNode2;
        } else {
            StructureMapNode structureMapNode3;
            StructureGridPos relativeGridPos = gridSize.toRelativeGridPos(chunkPos);
            int currentXQuadrant = Math.floorMod(relativeGridPos.getX(), 2);
            int currentZQuadrant = Math.floorMod(relativeGridPos.getZ(), 2);
            if (currentXQuadrant == 0 && currentZQuadrant == 0) {
                if (previousNode.getLowerLeftChild() == null) {
                    previousNode.setLowerLeftChild(new StructureMapNode());
                    structureMapNode3 = previousNode.getLowerLeftChild();
                    Intrinsics.checkNotNull(structureMapNode3);
                    this.tryPlacingStructuresFor(structureMapNode3, chunkPos, biomeManager, chunkGenerator, gridSize);
                }
                structureMapNode3 = previousNode.getLowerLeftChild();
                Intrinsics.checkNotNull(structureMapNode3);
                structureMapNode = structureMapNode3;
            } else if (currentXQuadrant == 1 && currentZQuadrant == 0) {
                if (previousNode.getLowerRightChild() == null) {
                    previousNode.setLowerRightChild(new StructureMapNode());
                    structureMapNode3 = previousNode.getLowerRightChild();
                    Intrinsics.checkNotNull(structureMapNode3);
                    this.tryPlacingStructuresFor(structureMapNode3, chunkPos, biomeManager, chunkGenerator, gridSize);
                }
                structureMapNode3 = previousNode.getLowerRightChild();
                Intrinsics.checkNotNull(structureMapNode3);
                structureMapNode = structureMapNode3;
            } else if (currentXQuadrant == 0 && currentZQuadrant == 1) {
                if (previousNode.getUpperLeftChild() == null) {
                    previousNode.setUpperLeftChild(new StructureMapNode());
                    structureMapNode3 = previousNode.getUpperLeftChild();
                    Intrinsics.checkNotNull(structureMapNode3);
                    this.tryPlacingStructuresFor(structureMapNode3, chunkPos, biomeManager, chunkGenerator, gridSize);
                }
                structureMapNode3 = previousNode.getUpperLeftChild();
                Intrinsics.checkNotNull(structureMapNode3);
                structureMapNode = structureMapNode3;
            } else if (currentXQuadrant == 1 && currentZQuadrant == 1) {
                if (previousNode.getUpperRightChild() == null) {
                    previousNode.setUpperRightChild(new StructureMapNode());
                    structureMapNode3 = previousNode.getUpperRightChild();
                    Intrinsics.checkNotNull(structureMapNode3);
                    this.tryPlacingStructuresFor(structureMapNode3, chunkPos, biomeManager, chunkGenerator, gridSize);
                }
                structureMapNode3 = previousNode.getUpperRightChild();
                Intrinsics.checkNotNull(structureMapNode3);
                structureMapNode = structureMapNode3;
            } else {
                throw new IllegalStateException("Quadrant (" + currentXQuadrant + ", " + currentZQuadrant + ") is not valid.");
            }
        }
        StructureMapNode plannedNode = structureMapNode;
        if (!plannedNode.hasStructure() && gridSize.getNextSizeDown() != null) {
            this.planStructuresIn(chunkPos, biomeManager, chunkGenerator, plannedNode, gridSize.getNextSizeDown());
        }
    }

    private final void tryPlacingStructuresFor(StructureMapNode node, ChunkPos chunkPos, BiomeManager biomeManager, ChunkGenerator<?> chunkGenerator, StructureGridSize gridSize) {
        StructureGridPos gridPos = gridSize.toAbsoluteGridPos(chunkPos);
        this.random.func_202425_c(chunkGenerator.func_202089_c(), gridPos.getX(), gridPos.getZ());
        ChunkPos cornerChunkPos = gridPos.getStartCornerChunk();
        int centerXPos = cornerChunkPos.func_180334_c() + gridSize.getBlockSize() / 2;
        int centerZPos = cornerChunkPos.func_180333_d() + gridSize.getBlockSize() / 2;
        List list = (List)StructureMap.Companion.getGRID_SIZE_TO_STRUCTURES().get((Object)gridSize);
        Intrinsics.checkNotNull(list);
        List<AOTDStructure> possibleStructures = CollectionsKt.shuffled(list, (Random)this.random);
        for (AOTDStructure structure : possibleStructures) {
            int n = structure.getLength();
            int n2 = structure.getWidth();
            boolean bl = false;
            int structureSize = Math.min(n, n2);
            int gridSizeBlocks = gridSize.getBlockSize();
            int wiggleRoom = gridSizeBlocks - structureSize;
            int n3 = 0;
            int numPlacementAttempts = (int)StructureMap.Companion.powOptimized(4.0, gridSize.ordinal());
            if (n3 >= numPlacementAttempts) continue;
            do {
                int zPosOffset;
                int zPos;
                int i = n3++;
                int xPosOffset = this.random.nextInt(wiggleRoom) - wiggleRoom / 2;
                int xPos = centerXPos + xPosOffset;
                if (!structure.canFitAt(chunkGenerator, biomeManager, (Random)this.random, xPos, zPos = centerZPos + (zPosOffset = this.random.nextInt(wiggleRoom) - wiggleRoom / 2))) continue;
                node.insertStructure(structure, new BlockPos(xPos, 0, zPos));
                return;
            } while (n3 < numPlacementAttempts);
        }
    }

    @NotNull
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        StructureMapNode structureMapNode = this.root;
        if (structureMapNode != null) {
            StructureMapNode structureMapNode2 = structureMapNode;
            boolean bl = false;
            boolean bl2 = false;
            StructureMapNode it = structureMapNode2;
            boolean bl3 = false;
            nbt.func_218657_a(NBT_ROOT, (INBT)it.serializeNBT());
        }
        return nbt;
    }

    /*
     * WARNING - void declaration
     */
    public void deserializeNBT(@NotNull CompoundNBT nbt) {
        StructureMapNode structureMapNode;
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        StructureMap structureMap = this;
        if (nbt.func_74764_b(NBT_ROOT)) {
            void $this$deserializeNBT_u24lambda_u2d1;
            StructureMapNode structureMapNode2 = new StructureMapNode();
            boolean bl = false;
            boolean bl2 = false;
            StructureMapNode structureMapNode3 = structureMapNode2;
            StructureMap structureMap2 = structureMap;
            boolean bl3 = false;
            CompoundNBT compoundNBT = nbt.func_74775_l(NBT_ROOT);
            Intrinsics.checkNotNullExpressionValue(compoundNBT, "nbt.getCompound(NBT_ROOT)");
            $this$deserializeNBT_u24lambda_u2d1.deserializeNBT(compoundNBT);
            Unit unit = Unit.INSTANCE;
            structureMap = structureMap2;
            structureMapNode = structureMapNode2;
        } else {
            structureMapNode = null;
        }
        structureMap.root = structureMapNode;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R1\u0010\u0003\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00060\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/davidm1a2/afraidofthedark/common/capabilities/world/structure/StructureMap$Companion;", "", "()V", "GRID_SIZE_TO_STRUCTURES", "", "Lcom/davidm1a2/afraidofthedark/common/capabilities/world/structure/StructureGridSize;", "", "Lcom/davidm1a2/afraidofthedark/common/feature/structure/base/AOTDStructure;", "getGRID_SIZE_TO_STRUCTURES", "()Ljava/util/Map;", "GRID_SIZE_TO_STRUCTURES$delegate", "Lkotlin/Lazy;", "NBT_ROOT", "", "powOptimized", "", "n", "", "afraidofthedark"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final Map<StructureGridSize, List<AOTDStructure<?>>> getGRID_SIZE_TO_STRUCTURES() {
            Lazy lazy = GRID_SIZE_TO_STRUCTURES$delegate;
            boolean bl = false;
            return (Map)lazy.getValue();
        }

        private final double powOptimized(double $this$powOptimized, int n) {
            if (n == 0) {
                return 1.0;
            }
            double result = $this$powOptimized;
            int n2 = 0;
            int n3 = n - 1;
            if (n2 < n3) {
                do {
                    int ignored = n2++;
                    result *= $this$powOptimized;
                } while (n2 < n3);
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(Companion.class), "GRID_SIZE_TO_STRUCTURES", "getGRID_SIZE_TO_STRUCTURES()Ljava/util/Map;"))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

