/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.capabilities.player.research;

import com.davidm1a2.afraidofthedark.AfraidOfTheDark;
import com.davidm1a2.afraidofthedark.client.sound.ResearchUnlockedSound;
import com.davidm1a2.afraidofthedark.common.capabilities.player.research.IPlayerResearch;
import com.davidm1a2.afraidofthedark.common.constants.ModRegistries;
import com.davidm1a2.afraidofthedark.common.event.ResearchOverlayHandler;
import com.davidm1a2.afraidofthedark.common.network.packets.capabilityPackets.ResearchPacket;
import com.davidm1a2.afraidofthedark.common.registry.research.Research;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J \u0010\u0010\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/davidm1a2/afraidofthedark/common/capabilities/player/research/PlayerResearch;", "Lcom/davidm1a2/afraidofthedark/common/capabilities/player/research/IPlayerResearch;", "()V", "researchToUnlocked", "", "Lcom/davidm1a2/afraidofthedark/common/registry/research/Research;", "", "canResearch", "research", "isResearched", "isServerSide", "entityPlayer", "Lnet/minecraft/entity/player/PlayerEntity;", "setResearch", "", "researched", "setResearchAndAlert", "sync", "notify", "afraidofthedark"})
public final class PlayerResearch
implements IPlayerResearch {
    @NotNull
    private final Map<Research, Boolean> researchToUnlocked;

    public PlayerResearch() {
        boolean bl = false;
        this.researchToUnlocked = new LinkedHashMap();
        Collection collection = ModRegistries.INSTANCE.getRESEARCH().getValues();
        Intrinsics.checkNotNullExpressionValue(collection, "ModRegistries.RESEARCH.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Research it = (Research)((Object)element$iv);
            boolean bl2 = false;
            Map<Research, Boolean> map = this.researchToUnlocked;
            Intrinsics.checkNotNullExpressionValue((Object)it, "it");
            Research research = it;
            Boolean bl3 = false;
            boolean bl4 = false;
            map.put(research, bl3);
        }
    }

    private final boolean isServerSide(PlayerEntity entityPlayer) {
        return !entityPlayer.field_70170_p.field_72995_K;
    }

    @Override
    public boolean isResearched(@NotNull Research research) {
        Intrinsics.checkNotNullParameter((Object)research, "research");
        return this.researchToUnlocked.getOrDefault((Object)research, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canResearch(@NotNull Research research) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)research, "research");
        if (this.isResearched(research)) return false;
        Research research2 = research.getPreRequisite();
        if (research2 == null) {
            return true;
        }
        Research research3 = research2;
        boolean bl2 = false;
        boolean bl3 = false;
        Research it = research3;
        boolean bl4 = false;
        boolean bl5 = bl = this.isResearched(it);
        if (!bl5) return false;
        return true;
    }

    @Override
    public void setResearch(@NotNull Research research, boolean researched) {
        Intrinsics.checkNotNullParameter((Object)research, "research");
        Map<Research, Boolean> map = this.researchToUnlocked;
        Boolean bl = researched;
        boolean bl2 = false;
        map.put(research, bl);
    }

    @Override
    public void setResearchAndAlert(@NotNull Research research, boolean researched, @NotNull PlayerEntity entityPlayer) {
        Intrinsics.checkNotNullParameter((Object)research, "research");
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        this.setResearch(research, researched);
        if (!this.isServerSide(entityPlayer)) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new ResearchUnlockedSound());
            ResearchOverlayHandler researchOverlayHandler = AfraidOfTheDark.Companion.getProxy().getResearchOverlay();
            Intrinsics.checkNotNull(researchOverlayHandler);
            researchOverlayHandler.displayResearch(research);
        }
    }

    @Override
    public void sync(@NotNull PlayerEntity entityPlayer, boolean notify) {
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        if (this.isServerSide(entityPlayer)) {
            AfraidOfTheDark.Companion.getPacketHandler().sendTo(new ResearchPacket(this.researchToUnlocked, notify), (ServerPlayerEntity)entityPlayer);
        } else {
            AfraidOfTheDark.Companion.getPacketHandler().sendToServer(new ResearchPacket(this.researchToUnlocked, notify));
        }
    }
}

