/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.common.block;

import com.davidm1a2.afraidofthedark.common.block.core.AOTDBlock;
import com.davidm1a2.afraidofthedark.common.constants.ModBlocks;
import com.davidm1a2.afraidofthedark.common.constants.ModItems;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u001c\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00070\u0016H\u0014J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001c\u0010\u001f\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000bH\u0016J\u001c\u0010 \u001a\u00020!2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000bH\u0016J(\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010#\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J(\u0010%\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020&2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0016J(\u0010)\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,H\u0016J:\u0010-\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020/2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000bH\u0016\u00a8\u00063"}, d2={"Lcom/davidm1a2/afraidofthedark/common/block/ImbuedCactusBlock;", "Lcom/davidm1a2/afraidofthedark/common/block/core/AOTDBlock;", "Lnet/minecraftforge/common/IPlantable;", "()V", "allowsMovement", "", "state", "Lnet/minecraft/block/BlockState;", "world", "Lnet/minecraft/world/IBlockReader;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "pathType", "Lnet/minecraft/pathfinding/PathType;", "canSustainPlant", "iBlockState", "facing", "Lnet/minecraft/util/Direction;", "iPlantable", "fillStateContainer", "", "builder", "Lnet/minecraft/state/StateContainer$Builder;", "Lnet/minecraft/block/Block;", "getCollisionShape", "Lnet/minecraft/util/math/shapes/VoxelShape;", "blockState", "worldIn", "pos", "context", "Lnet/minecraft/util/math/shapes/ISelectionContext;", "getPlant", "getPlantType", "Lnet/minecraftforge/common/PlantType;", "getShape", "isValidPosition", "Lnet/minecraft/world/IWorldReader;", "onEntityCollision", "Lnet/minecraft/world/World;", "entity", "Lnet/minecraft/entity/Entity;", "tick", "Lnet/minecraft/world/server/ServerWorld;", "rand", "Ljava/util/Random;", "updatePostPlacement", "facingState", "Lnet/minecraft/world/IWorld;", "currentPos", "facingPos", "Companion", "afraidofthedark"})
public final class ImbuedCactusBlock
extends AOTDBlock
implements IPlantable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_HEIGHT = 3;
    private static final int MAX_AGE = 5;
    private static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)5);
    private static final VoxelShape CACTUS_COLLISION_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    private static final VoxelShape CACTUS_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public ImbuedCactusBlock() {
        Block.Properties properties = Block.Properties.func_200945_a((Material)Material.field_151570_A).func_200944_c().func_200947_a(SoundType.field_185854_g).func_200943_b(0.4f);
        Intrinsics.checkNotNullExpressionValue(properties, "create(Material.CACTUS)\n        .tickRandomly()\n        .sound(SoundType.CLOTH)\n        .hardnessAndResistance(0.4f)");
        super("imbued_cactus", properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void func_225534_a_(@NotNull BlockState state, @NotNull ServerWorld world, @NotNull BlockPos pos, @NotNull Random rand) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(rand, "rand");
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!state.func_196955_c((IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
        } else if (world.func_175623_d(pos.func_177984_a())) {
            Integer age;
            Integer n = age = (Integer)state.func_177229_b((IProperty)AGE);
            age = n + 1;
            int n2 = 5;
            if (age == n2) {
                age = 0;
                int currentHeight = 0;
                int n3 = 0;
                do {
                    int yOffset;
                    BlockState blockBelow;
                    if (Intrinsics.areEqual((blockBelow = world.func_180495_p(pos.func_177979_c(yOffset = n3++))).func_177230_c(), this)) {
                        int n4 = currentHeight;
                        currentHeight = n4 + 1;
                        continue;
                    }
                    if (!Intrinsics.areEqual(blockBelow.func_177230_c(), this)) break;
                } while (n3 < 3);
                if (currentHeight == 3) {
                    world.func_175656_a(pos.func_177984_a(), ModBlocks.INSTANCE.getIMBUED_CACTUS_BLOSSOM().func_176223_P());
                } else {
                    world.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                }
            }
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)age));
        }
    }

    @NotNull
    public VoxelShape func_220071_b(@NotNull BlockState blockState, @NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull ISelectionContext context) {
        Intrinsics.checkNotNullParameter(blockState, "blockState");
        Intrinsics.checkNotNullParameter(worldIn, "worldIn");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(context, "context");
        VoxelShape voxelShape = CACTUS_COLLISION_SHAPE;
        Intrinsics.checkNotNullExpressionValue(voxelShape, "CACTUS_COLLISION_SHAPE");
        return voxelShape;
    }

    @NotNull
    public VoxelShape func_220053_a(@NotNull BlockState blockState, @NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull ISelectionContext context) {
        Intrinsics.checkNotNullParameter(blockState, "blockState");
        Intrinsics.checkNotNullParameter(worldIn, "worldIn");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(context, "context");
        VoxelShape voxelShape = CACTUS_SHAPE;
        Intrinsics.checkNotNullExpressionValue(voxelShape, "CACTUS_SHAPE");
        return voxelShape;
    }

    @Nullable
    public BlockState func_196271_a(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull IWorld world, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(facing, "facing");
        Intrinsics.checkNotNullParameter(facingState, "facingState");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(currentPos, "currentPos");
        Intrinsics.checkNotNullParameter(facingPos, "facingPos");
        if (!state.func_196955_c((IWorldReader)world, currentPos)) {
            world.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_196260_a(@NotNull BlockState state, @NotNull IWorldReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        BlockState blockStateBelow = world.func_180495_p(pos.func_177977_b());
        return blockStateBelow.func_177230_c().canSustainPlant(blockStateBelow, (IBlockReader)world, pos.func_177977_b(), Direction.UP, (IPlantable)this) && !world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76224_d();
    }

    public boolean canSustainPlant(@NotNull BlockState iBlockState, @NotNull IBlockReader world, @NotNull BlockPos blockPos, @NotNull Direction facing, @NotNull IPlantable iPlantable) {
        Intrinsics.checkNotNullParameter(iBlockState, "iBlockState");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(blockPos, "blockPos");
        Intrinsics.checkNotNullParameter(facing, "facing");
        Intrinsics.checkNotNullParameter(iPlantable, "iPlantable");
        BlockState plantStateToPlace = iPlantable.getPlant(world, blockPos.func_177972_a(facing));
        return Intrinsics.areEqual(plantStateToPlace.func_177230_c(), this) || Intrinsics.areEqual(plantStateToPlace.func_177230_c(), ModBlocks.INSTANCE.getIMBUED_CACTUS_BLOSSOM());
    }

    public void func_196262_a(@NotNull BlockState state, @NotNull World world, @NotNull BlockPos blockPos, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(blockPos, "blockPos");
        Intrinsics.checkNotNullParameter(entity, "entity");
        if (!(entity instanceof ItemEntity) || !Intrinsics.areEqual(((ItemEntity)entity).func_92059_d().func_77973_b(), (Object)ModItems.INSTANCE.getDESERT_FRUIT())) {
            entity.func_70097_a(DamageSource.field_76367_g, 2.0f);
        }
    }

    protected void func_206840_a(@NotNull StateContainer.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        IProperty[] iPropertyArray = new IProperty[]{(IProperty)AGE};
        builder.func_206894_a(iPropertyArray);
    }

    public boolean func_196266_a(@NotNull BlockState state, @NotNull IBlockReader world, @NotNull BlockPos blockPos, @NotNull PathType pathType) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(blockPos, "blockPos");
        Intrinsics.checkNotNullParameter(pathType, "pathType");
        return false;
    }

    @NotNull
    public PlantType getPlantType(@Nullable IBlockReader world, @Nullable BlockPos pos) {
        return PlantType.Desert;
    }

    @NotNull
    public BlockState getPlant(@Nullable IBlockReader world, @Nullable BlockPos pos) {
        BlockState blockState = this.func_176223_P();
        Intrinsics.checkNotNullExpressionValue(blockState, "defaultState");
        return blockState;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/davidm1a2/afraidofthedark/common/block/ImbuedCactusBlock$Companion;", "", "()V", "AGE", "Lnet/minecraft/state/IntegerProperty;", "kotlin.jvm.PlatformType", "CACTUS_COLLISION_SHAPE", "Lnet/minecraft/util/math/shapes/VoxelShape;", "CACTUS_SHAPE", "MAX_AGE", "", "MAX_HEIGHT", "afraidofthedark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

