/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.client.gui.standardControls;

import com.davidm1a2.afraidofthedark.client.gui.layout.Gravity;
import com.davidm1a2.afraidofthedark.client.gui.layout.Spacing;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.AOTDGuiComponent;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.AOTDPane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.StackPane;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\tB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/HChainPane;", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/StackPane;", "layout", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/HChainPane$Layout;", "(Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/HChainPane$Layout;)V", "getLayout", "()Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/HChainPane$Layout;", "calcChildrenBounds", "", "Layout", "afraidofthedark"})
public class HChainPane
extends StackPane {
    @NotNull
    private final Layout layout;

    public HChainPane(@NotNull Layout layout) {
        Intrinsics.checkNotNullParameter((Object)layout, "layout");
        super(null, null, null, null, null, null, false, 127, null);
        this.layout = layout;
    }

    public /* synthetic */ HChainPane(Layout layout, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            layout = Layout.SPREAD;
        }
        this(layout);
    }

    @NotNull
    public final Layout getLayout() {
        return this.layout;
    }

    @Override
    public void calcChildrenBounds() {
        double d;
        Spacing calcMargins;
        Spacing calcPadding = this.getPadding().getAbsoluteInner(this);
        double internalWidth = this.getInternalWidth();
        double internalHeight = this.getInternalHeight();
        double initSpace = internalWidth / (double)this.getChildren().size();
        double extraSpace = 0.0;
        for (AOTDGuiComponent aOTDGuiComponent : this.getChildren()) {
            calcMargins = aOTDGuiComponent.getMargins().getAbsoluteOuter(aOTDGuiComponent);
            double marginWidth = calcMargins.getWidth();
            double marginHeight = calcMargins.getHeight();
            aOTDGuiComponent.negotiateDimensions(internalWidth - marginWidth, internalHeight - marginHeight);
        }
        for (AOTDGuiComponent aOTDGuiComponent : this.getChildren()) {
            calcMargins = aOTDGuiComponent.getMargins().getAbsoluteOuter(aOTDGuiComponent);
            double childWidthWithMargins2 = (double)aOTDGuiComponent.getWidth() + calcMargins.getWidth();
            if (!(childWidthWithMargins2 < initSpace)) continue;
            extraSpace += initSpace - childWidthWithMargins2;
        }
        int requesterCount = 0;
        for (AOTDGuiComponent child : this.getChildren()) {
            Spacing calcMargins2 = child.getMargins().getAbsoluteOuter(child);
            double childWidthWithMargins = (double)child.getWidth() + calcMargins2.getWidth();
            if (!(childWidthWithMargins > initSpace)) continue;
            int n = requesterCount;
            requesterCount = n + 1;
        }
        for (AOTDGuiComponent child : this.getChildren()) {
            Spacing calcMargins3 = child.getMargins().getAbsoluteOuter(child);
            double childWidthWithMargins3 = (double)child.getWidth() + calcMargins3.getWidth();
            if (!(childWidthWithMargins3 > initSpace)) continue;
            double requestedSpace = childWidthWithMargins3 - initSpace;
            double extraSpaceAllowed = extraSpace / (double)requesterCount;
            if (requestedSpace > extraSpaceAllowed) {
                child.negotiateDimensions(initSpace + extraSpaceAllowed - calcMargins3.getWidth(), internalHeight);
                extraSpace -= extraSpaceAllowed;
            } else {
                extraSpace -= requestedSpace;
            }
            int n = requesterCount;
            requesterCount = n + -1;
        }
        Layout layout = this.layout;
        int childWidthWithMargins3 = WhenMappings.$EnumSwitchMapping$0[layout.ordinal()];
        switch (childWidthWithMargins3) {
            case 1: {
                d = 0.0;
                break;
            }
            case 2: {
                d = extraSpace / (double)(this.getChildren().size() + 1);
                break;
            }
            case 3: {
                d = extraSpace / 2.0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double d2 = d;
        for (AOTDGuiComponent child : this.getChildren()) {
            double d3;
            double d4;
            Spacing calcMargins4 = child.getMargins().getAbsoluteOuter(child);
            double marginHeight = calcMargins4.getHeight();
            double marginWidth = calcMargins4.getWidth();
            double gravityXOffset = 0.0;
            Gravity gravity = child.getGravity();
            int n = WhenMappings.$EnumSwitchMapping$1[gravity.ordinal()];
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    d4 = calcPadding.getTop();
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    d4 = (double)(this.getHeight() / 2) - ((double)child.getHeight() + marginHeight) / (double)2;
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    d4 = (double)this.getHeight() - ((double)child.getHeight() + marginHeight) - calcPadding.getBot();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            double gravityYOffset = d4;
            double yOffset = 0.0;
            child.setX((int)((double)this.getX() + this.getGuiOffsetX() + gravityXOffset + d2 + calcMargins4.getLeft()));
            child.setY((int)((double)this.getY() + this.getGuiOffsetY() + gravityYOffset + yOffset + calcMargins4.getTop()));
            Layout layout2 = this.layout;
            int n2 = WhenMappings.$EnumSwitchMapping$0[layout2.ordinal()];
            switch (n2) {
                case 1: {
                    if (this.getChildren().size() == 1) {
                        d3 = 0.0;
                        break;
                    }
                    d3 = extraSpace / (double)(this.getChildren().size() - 1);
                    break;
                }
                case 2: {
                    d3 = extraSpace / (double)(this.getChildren().size() + 1);
                    break;
                }
                case 3: {
                    d3 = 0.0;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            double layoutOffset = d3;
            d2 += (double)child.getWidth() + marginWidth + layoutOffset;
            if (child instanceof AOTDPane) {
                ((AOTDPane)child).calcChildrenBounds();
            }
            this.determineInBounds(child);
        }
    }

    public HChainPane() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/HChainPane$Layout;", "", "(Ljava/lang/String;I)V", "SPREAD", "SPREAD_INSIDE", "CLOSE", "afraidofthedark"})
    public static final class Layout
    extends Enum<Layout> {
        public static final /* enum */ Layout SPREAD = new Layout();
        public static final /* enum */ Layout SPREAD_INSIDE = new Layout();
        public static final /* enum */ Layout CLOSE = new Layout();
        private static final /* synthetic */ Layout[] $VALUES;

        public static Layout[] values() {
            Layout[] layoutArray = $VALUES;
            return Arrays.copyOf(layoutArray, layoutArray.length);
        }

        public static Layout valueOf(String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            return Enum.valueOf(Layout.class, value);
        }

        static {
            $VALUES = layoutArray = new Layout[]{Layout.SPREAD, Layout.SPREAD_INSIDE, Layout.CLOSE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Layout.values().length];
            nArray[Layout.SPREAD.ordinal()] = 1;
            nArray[Layout.SPREAD_INSIDE.ordinal()] = 2;
            nArray[Layout.CLOSE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Gravity.values().length];
            nArray[Gravity.TOP_LEFT.ordinal()] = 1;
            nArray[Gravity.TOP_CENTER.ordinal()] = 2;
            nArray[Gravity.TOP_RIGHT.ordinal()] = 3;
            nArray[Gravity.CENTER_LEFT.ordinal()] = 4;
            nArray[Gravity.CENTER.ordinal()] = 5;
            nArray[Gravity.CENTER_RIGHT.ordinal()] = 6;
            nArray[Gravity.BOTTOM_LEFT.ordinal()] = 7;
            nArray[Gravity.BOTTOM_CENTER.ordinal()] = 8;
            nArray[Gravity.BOTTOM_RIGHT.ordinal()] = 9;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

