/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.client.gui.standardControls;

import com.davidm1a2.afraidofthedark.client.gui.AOTDGuiUtility;
import com.davidm1a2.afraidofthedark.client.gui.events.KeyEvent;
import com.davidm1a2.afraidofthedark.client.gui.events.MouseDragEvent;
import com.davidm1a2.afraidofthedark.client.gui.events.MouseEvent;
import com.davidm1a2.afraidofthedark.client.gui.events.MouseMoveEvent;
import com.davidm1a2.afraidofthedark.client.gui.events.MouseScrollEvent;
import com.davidm1a2.afraidofthedark.client.gui.layout.Dimensions;
import com.davidm1a2.afraidofthedark.client.gui.layout.Gravity;
import com.davidm1a2.afraidofthedark.client.gui.layout.Position;
import com.davidm1a2.afraidofthedark.client.gui.layout.Spacing;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.AOTDGuiComponent;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.AOTDGuiComponentWithEvents;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.OverlayPane;
import java.awt.Color;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001BQ\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020%H\u0016J\b\u0010)\u001a\u00020'H\u0016J\u000e\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020%J\b\u0010,\u001a\u00020'H\u0016J\b\u0010-\u001a\u00020'H\u0016J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020%0/J\b\u00100\u001a\u00020\u0012H\u0016J\b\u00101\u001a\u00020\u0012H\u0016J\b\u00102\u001a\u00020'H\u0016J\u0010\u00103\u001a\u00020'2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020'2\u0006\u00104\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020'2\u0006\u00104\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020'2\u0006\u00104\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020'2\u0006\u00104\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020'2\u0006\u0010(\u001a\u00020%H\u0016R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\r\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/AOTDPane;", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/AOTDGuiComponentWithEvents;", "offset", "Lcom/davidm1a2/afraidofthedark/client/gui/layout/Position;", "prefSize", "Lcom/davidm1a2/afraidofthedark/client/gui/layout/Dimensions;", "margins", "Lcom/davidm1a2/afraidofthedark/client/gui/layout/Spacing;", "gravity", "Lcom/davidm1a2/afraidofthedark/client/gui/layout/Gravity;", "hoverTexts", "", "", "padding", "color", "Ljava/awt/Color;", "(Lcom/davidm1a2/afraidofthedark/client/gui/layout/Position;Lcom/davidm1a2/afraidofthedark/client/gui/layout/Dimensions;Lcom/davidm1a2/afraidofthedark/client/gui/layout/Spacing;Lcom/davidm1a2/afraidofthedark/client/gui/layout/Gravity;[Ljava/lang/String;Lcom/davidm1a2/afraidofthedark/client/gui/layout/Spacing;Ljava/awt/Color;)V", "guiOffsetX", "", "getGuiOffsetX", "()D", "setGuiOffsetX", "(D)V", "guiOffsetY", "getGuiOffsetY", "setGuiOffsetY", "isVisible", "", "()Z", "setVisible", "(Z)V", "getPadding", "()Lcom/davidm1a2/afraidofthedark/client/gui/layout/Spacing;", "setPadding", "(Lcom/davidm1a2/afraidofthedark/client/gui/layout/Spacing;)V", "subComponents", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/AOTDGuiComponent;", "add", "", "container", "calcChildrenBounds", "determineInBounds", "component", "draw", "drawOverlay", "getChildren", "", "getInternalHeight", "getInternalWidth", "invalidate", "processKeyInput", "event", "Lcom/davidm1a2/afraidofthedark/client/gui/events/KeyEvent;", "processMouseDragInput", "Lcom/davidm1a2/afraidofthedark/client/gui/events/MouseDragEvent;", "processMouseInput", "Lcom/davidm1a2/afraidofthedark/client/gui/events/MouseEvent;", "processMouseMoveInput", "Lcom/davidm1a2/afraidofthedark/client/gui/events/MouseMoveEvent;", "processMouseScrollInput", "Lcom/davidm1a2/afraidofthedark/client/gui/events/MouseScrollEvent;", "remove", "afraidofthedark"})
public abstract class AOTDPane
extends AOTDGuiComponentWithEvents {
    @NotNull
    private Spacing padding;
    @NotNull
    private final CopyOnWriteArrayList<AOTDGuiComponent> subComponents;
    private double guiOffsetX;
    private double guiOffsetY;

    public AOTDPane(@NotNull Position offset, @NotNull Dimensions prefSize, @NotNull Spacing margins, @NotNull Gravity gravity, @NotNull String[] hoverTexts, @NotNull Spacing padding, @NotNull Color color) {
        Intrinsics.checkNotNullParameter(offset, "offset");
        Intrinsics.checkNotNullParameter(prefSize, "prefSize");
        Intrinsics.checkNotNullParameter(margins, "margins");
        Intrinsics.checkNotNullParameter((Object)gravity, "gravity");
        Intrinsics.checkNotNullParameter(hoverTexts, "hoverTexts");
        Intrinsics.checkNotNullParameter(padding, "padding");
        Intrinsics.checkNotNullParameter(color, "color");
        super(offset, prefSize, margins, gravity, hoverTexts, color);
        this.padding = padding;
        this.subComponents = new CopyOnWriteArrayList();
    }

    public /* synthetic */ AOTDPane(Position position, Dimensions dimensions, Spacing spacing, Gravity gravity, String[] stringArray, Spacing spacing2, Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            position = new Position(0.0, 0.0, false, 4, null);
        }
        if ((n & 2) != 0) {
            dimensions = new Dimensions(1.0, 1.0, false, 4, null);
        }
        if ((n & 4) != 0) {
            spacing = new Spacing();
        }
        if ((n & 8) != 0) {
            gravity = Gravity.TOP_LEFT;
        }
        if ((n & 0x10) != 0) {
            stringArray = new String[]{};
        }
        if ((n & 0x20) != 0) {
            spacing2 = new Spacing();
        }
        if ((n & 0x40) != 0) {
            color = new Color(255, 255, 255, 255);
        }
        this(position, dimensions, spacing, gravity, stringArray, spacing2, color);
    }

    @NotNull
    public final Spacing getPadding() {
        return this.padding;
    }

    public final void setPadding(@NotNull Spacing spacing) {
        Intrinsics.checkNotNullParameter(spacing, "<set-?>");
        this.padding = spacing;
    }

    public final double getGuiOffsetX() {
        return this.guiOffsetX;
    }

    public final void setGuiOffsetX(double d) {
        this.guiOffsetX = d;
    }

    public final double getGuiOffsetY() {
        return this.guiOffsetY;
    }

    public final void setGuiOffsetY(double d) {
        this.guiOffsetY = d;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible();
    }

    @Override
    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        Iterable $this$forEach$iv = this.subComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AOTDGuiComponent subContainer = (AOTDGuiComponent)element$iv;
            boolean bl = false;
            subContainer.setVisible(isVisible);
        }
    }

    public void add(@NotNull AOTDGuiComponent container) {
        Intrinsics.checkNotNullParameter(container, "container");
        this.subComponents.add(container);
    }

    public void remove(@NotNull AOTDGuiComponent container) {
        Intrinsics.checkNotNullParameter(container, "container");
        if (!this.subComponents.contains(container)) {
            return;
        }
        this.subComponents.remove(container);
    }

    public double getInternalWidth() {
        return (double)this.getWidth() - this.padding.getAbsoluteOuter(this).getWidth();
    }

    public double getInternalHeight() {
        return (double)this.getHeight() - this.padding.getAbsoluteOuter(this).getHeight();
    }

    public void calcChildrenBounds() {
        Spacing calcPadding = this.padding.getAbsoluteOuter(this);
        double internalWidth = this.getInternalWidth();
        double internalHeight = this.getInternalHeight();
        for (AOTDGuiComponent child : this.subComponents) {
            double d;
            double d2;
            Spacing spacing = child.getMargins();
            Intrinsics.checkNotNullExpressionValue(child, "child");
            Spacing calcMargins = spacing.getAbsoluteOuter(child);
            double marginWidth = calcMargins.getWidth();
            double marginHeight = calcMargins.getHeight();
            child.negotiateDimensions(internalWidth - marginWidth, internalHeight - marginHeight);
            Gravity gravity = child.getGravity();
            int n = WhenMappings.$EnumSwitchMapping$0[gravity.ordinal()];
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    d2 = calcMargins.getLeft();
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    d2 = internalWidth / (double)2 - ((double)child.getWidth() + calcMargins.getWidth()) / (double)2 + calcMargins.getLeft();
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    d2 = internalWidth - (double)child.getWidth() - calcMargins.getRight();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            double gravityXOffset = d2;
            Gravity gravity2 = child.getGravity();
            int n2 = WhenMappings.$EnumSwitchMapping$0[gravity2.ordinal()];
            switch (n2) {
                case 1: 
                case 4: 
                case 7: {
                    d = calcMargins.getTop();
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    d = internalHeight / (double)2 - ((double)child.getHeight() + calcMargins.getHeight()) / (double)2 + calcMargins.getTop();
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    d = internalHeight - (double)child.getHeight() - calcMargins.getBot();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            double gravityYOffset = d;
            Position offset = child.getOffset().getAbsolute(this);
            child.setX(MathKt.roundToInt((double)this.getX() + this.guiOffsetX + calcPadding.getLeft() + gravityXOffset + offset.getX()));
            child.setY(MathKt.roundToInt((double)this.getY() + this.guiOffsetY + calcPadding.getTop() + gravityYOffset + offset.getY()));
            if (child instanceof AOTDPane) {
                ((AOTDPane)child).calcChildrenBounds();
            }
            this.determineInBounds(child);
        }
    }

    public final void determineInBounds(@NotNull AOTDGuiComponent component) {
        Intrinsics.checkNotNullParameter(component, "component");
        if (component instanceof OverlayPane) {
            return;
        }
        if (!component.intersects(this.getBoundingBox())) {
            component.setInBounds(false);
        }
        if (component instanceof AOTDPane) {
            for (AOTDGuiComponent child : ((AOTDPane)component).getChildren()) {
                this.determineInBounds(child);
            }
        }
    }

    @NotNull
    public final List<AOTDGuiComponent> getChildren() {
        return CollectionsKt.toList((Iterable)this.subComponents);
    }

    @Override
    public void draw() {
        super.draw();
        Iterable $this$forEach$iv = this.subComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AOTDGuiComponent it = (AOTDGuiComponent)element$iv;
            boolean bl = false;
            it.draw();
        }
    }

    @Override
    public void drawOverlay() {
        super.drawOverlay();
        Iterable $this$forEach$iv = this.subComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AOTDGuiComponent it = (AOTDGuiComponent)element$iv;
            boolean bl = false;
            it.drawOverlay();
        }
    }

    @Override
    public void processMouseInput(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Iterable $this$forEach$iv = this.subComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AOTDGuiComponent it = (AOTDGuiComponent)element$iv;
            boolean bl = false;
            if (!(it instanceof AOTDGuiComponentWithEvents)) continue;
            ((AOTDGuiComponentWithEvents)it).processMouseInput(event);
        }
        super.processMouseInput(event);
    }

    @Override
    public void processMouseMoveInput(@NotNull MouseMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Iterable $this$forEach$iv = this.subComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AOTDGuiComponent it = (AOTDGuiComponent)element$iv;
            boolean bl = false;
            if (!(it instanceof AOTDGuiComponentWithEvents)) continue;
            ((AOTDGuiComponentWithEvents)it).processMouseMoveInput(event);
        }
        super.processMouseMoveInput(event);
    }

    @Override
    public void processMouseDragInput(@NotNull MouseDragEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Iterable $this$forEach$iv = this.subComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AOTDGuiComponent it = (AOTDGuiComponent)element$iv;
            boolean bl = false;
            if (!(it instanceof AOTDGuiComponentWithEvents)) continue;
            ((AOTDGuiComponentWithEvents)it).processMouseDragInput(event);
        }
        super.processMouseDragInput(event);
    }

    @Override
    public void processMouseScrollInput(@NotNull MouseScrollEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Iterable $this$forEach$iv = this.subComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AOTDGuiComponent it = (AOTDGuiComponent)element$iv;
            boolean bl = false;
            if (!(it instanceof AOTDGuiComponentWithEvents)) continue;
            ((AOTDGuiComponentWithEvents)it).processMouseScrollInput(event);
        }
        super.processMouseScrollInput(event);
    }

    @Override
    public void processKeyInput(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Iterable $this$forEach$iv = this.subComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AOTDGuiComponent it = (AOTDGuiComponent)element$iv;
            boolean bl = false;
            if (!(it instanceof AOTDGuiComponentWithEvents)) continue;
            ((AOTDGuiComponentWithEvents)it).processKeyInput(event);
        }
        super.processKeyInput(event);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.setHovered(this.getBoundingBox().contains(AOTDGuiUtility.INSTANCE.getMouseXInMCCoord(), AOTDGuiUtility.INSTANCE.getMouseYInMCCoord()));
        this.calcChildrenBounds();
        Iterable $this$forEach$iv = this.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AOTDGuiComponent it = (AOTDGuiComponent)element$iv;
            boolean bl = false;
            it.invalidate();
        }
    }

    public AOTDPane() {
        this(null, null, null, null, null, null, null, 127, null);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Gravity.values().length];
            nArray[Gravity.TOP_LEFT.ordinal()] = 1;
            nArray[Gravity.CENTER_LEFT.ordinal()] = 2;
            nArray[Gravity.BOTTOM_LEFT.ordinal()] = 3;
            nArray[Gravity.TOP_CENTER.ordinal()] = 4;
            nArray[Gravity.CENTER.ordinal()] = 5;
            nArray[Gravity.BOTTOM_CENTER.ordinal()] = 6;
            nArray[Gravity.TOP_RIGHT.ordinal()] = 7;
            nArray[Gravity.CENTER_RIGHT.ordinal()] = 8;
            nArray[Gravity.BOTTOM_RIGHT.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

