/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.client.gui.screens;

import com.davidm1a2.afraidofthedark.client.gui.customControls.SpellListItem;
import com.davidm1a2.afraidofthedark.client.gui.events.KeyEvent;
import com.davidm1a2.afraidofthedark.client.gui.events.MouseEvent;
import com.davidm1a2.afraidofthedark.client.gui.layout.Dimensions;
import com.davidm1a2.afraidofthedark.client.gui.layout.Gravity;
import com.davidm1a2.afraidofthedark.client.gui.layout.Spacing;
import com.davidm1a2.afraidofthedark.client.gui.screens.AOTDScreen;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ButtonPane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.HChainPane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ImagePane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ListPane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.VScrollBar;
import com.davidm1a2.afraidofthedark.client.keybindings.KeybindingUtils;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.IPlayerSpellManager;
import com.davidm1a2.afraidofthedark.common.spell.Spell;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\b\u0010\u0015\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/screens/SpellListScreen;", "Lcom/davidm1a2/afraidofthedark/client/gui/screens/AOTDScreen;", "()V", "btnCreateSpell", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/ButtonPane;", "guiSpells", "", "Lcom/davidm1a2/afraidofthedark/client/gui/customControls/SpellListItem;", "scrollPanel", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/ListPane;", "spellManager", "Lcom/davidm1a2/afraidofthedark/common/capabilities/player/spell/IPlayerSpellManager;", "spellWaitingOnKeybind", "addSpell", "", "spell", "Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "drawGradientBackground", "", "inventoryToCloseGuiScreen", "removeSpell", "removed", "afraidofthedark"})
public final class SpellListScreen
extends AOTDScreen {
    @NotNull
    private final ListPane scrollPanel;
    @NotNull
    private final ButtonPane btnCreateSpell;
    @NotNull
    private final List<SpellListItem> guiSpells;
    @NotNull
    private final IPlayerSpellManager spellManager;
    @Nullable
    private SpellListItem spellWaitingOnKeybind;

    public SpellListScreen() {
        super((ITextComponent)new TranslationTextComponent("screen.afraidofthedark.spell_list", new Object[0]), false, 2, null);
        boolean bl = false;
        this.guiSpells = new ArrayList();
        this.spellManager = CapabilityExtensionsKt.getSpellManager((PlayerEntity)this.getEntityPlayer());
        this.getContentPane().setPadding(new Spacing(0.1, false, 2, null));
        ImagePane mainGui = new ImagePane("afraidofthedark:textures/gui/spell_list/spell_list_background.png", ImagePane.DispMode.FIT_TO_PARENT);
        VScrollBar scrollBar = new VScrollBar(new Dimensions(0.1, 1.0, false, 4, null), "afraidofthedark:textures/gui/spell_list/scroll_bar.png", "afraidofthedark:textures/gui/spell_list/scroll_bar_handle.png", "afraidofthedark:textures/gui/spell_list/scroll_bar_handle_hovered.png");
        this.scrollPanel = new ListPane(ListPane.ExpandDirection.DOWN, scrollBar, 0.0, 4, null);
        this.scrollPanel.setGravity(Gravity.CENTER);
        this.scrollPanel.setPrefSize(new Dimensions(0.8, 0.8, false, 4, null));
        mainGui.add(this.scrollPanel);
        HChainPane layoutPane = new HChainPane(HChainPane.Layout.CLOSE);
        layoutPane.add(mainGui);
        layoutPane.add(scrollBar);
        this.getContentPane().add(layoutPane);
        this.getContentPane().addKeyListener((Function1<? super KeyEvent, Unit>)new Function1<KeyEvent, Unit>(){

            @Override
            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getEventType() == KeyEvent.KeyEventType.Press && spellWaitingOnKeybind != null && KeybindingUtils.INSTANCE.isKeyBindable(it.getKey())) {
                    String keybind = KeybindingUtils.INSTANCE.getCurrentlyHeldKeybind(it.getKey(), it.getScanCode());
                    IPlayerSpellManager iPlayerSpellManager = spellManager;
                    SpellListItem spellListItem = spellWaitingOnKeybind;
                    Intrinsics.checkNotNull(spellListItem);
                    iPlayerSpellManager.keybindSpell(keybind, spellListItem.getSpell());
                    Iterable $this$forEach$iv = guiSpells;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SpellListItem guiSpell = (SpellListItem)element$iv;
                        boolean bl = false;
                        guiSpell.refreshLabels();
                    }
                    spellWaitingOnKeybind = null;
                    this.invalidate();
                }
            }
        });
        this.btnCreateSpell = new ButtonPane(new ImagePane("afraidofthedark:textures/gui/spell_list/create_spell.png", null, 2, null), new ImagePane("afraidofthedark:textures/gui/spell_list/create_spell_hovered.png", null, 2, null), false, null, null, null, null, new Dimensions(0.2, 0.15, false, 4, null), null, null, 892, null);
        this.btnCreateSpell.setMargins(new Spacing(0.01, 0.1, 0.0, 0.0, false, 16, null));
        this.btnCreateSpell.setHoverText("Create a new spell");
        this.btnCreateSpell.addMouseListener((Function1<? super MouseEvent, Unit>)new Function1<MouseEvent, Unit>(){

            @Override
            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getEventType() == MouseEvent.EventType.Click && it.getSource().isVisible() && it.getSource().isHovered() && it.getClickedButton() == 0) {
                    Spell spell = new Spell();
                    spell.setName("Untitled");
                    spellManager.addOrUpdateSpell(spell);
                    this.addSpell(spell);
                    this.invalidate();
                }
            }
        });
        this.scrollPanel.add(this.btnCreateSpell);
        Iterable $this$forEach$iv = this.spellManager.getSpells();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Spell it = (Spell)element$iv;
            boolean bl2 = false;
            this.addSpell(it);
        }
    }

    private final void addSpell(Spell spell) {
        SpellListItem guiSpell = new SpellListItem(new Dimensions(1.0, 0.2, false, 4, null), spell);
        guiSpell.setDeleteCallback(new Function0<Unit>(this, guiSpell){
            final /* synthetic */ SpellListScreen this$0;
            final /* synthetic */ SpellListItem $guiSpell;
            {
                this.this$0 = $receiver;
                this.$guiSpell = $guiSpell;
                super(0);
            }

            public final void invoke() {
                SpellListScreen.access$removeSpell(this.this$0, this.$guiSpell);
            }
        });
        guiSpell.setKeybindCallback(new Function0<Unit>(this, spell, guiSpell){
            final /* synthetic */ SpellListScreen this$0;
            final /* synthetic */ Spell $spell;
            final /* synthetic */ SpellListItem $guiSpell;
            {
                this.this$0 = $receiver;
                this.$spell = $spell;
                this.$guiSpell = $guiSpell;
                super(0);
            }

            public final void invoke() {
                if (SpellListScreen.access$getSpellManager$p(this.this$0).getKeybindingForSpell(this.$spell) == null) {
                    SpellListScreen.access$setSpellWaitingOnKeybind$p(this.this$0, this.$guiSpell);
                } else {
                    SpellListScreen.access$getSpellManager$p(this.this$0).unbindSpell(this.$spell);
                    this.$guiSpell.refreshLabels();
                }
            }
        });
        this.scrollPanel.remove(this.btnCreateSpell);
        this.scrollPanel.add(guiSpell);
        this.scrollPanel.add(this.btnCreateSpell);
        this.guiSpells.add(guiSpell);
    }

    private final void removeSpell(SpellListItem spell) {
        int index = this.guiSpells.indexOf(spell);
        this.guiSpells.remove(index);
        this.scrollPanel.remove(spell);
        this.spellManager.deleteSpell(spell.getSpell());
        this.invalidate();
    }

    public void removed() {
        this.spellManager.syncAll((PlayerEntity)this.getEntityPlayer());
        super.removed();
    }

    @Override
    public boolean inventoryToCloseGuiScreen() {
        return true;
    }

    @Override
    public boolean drawGradientBackground() {
        return true;
    }

    public static final /* synthetic */ void access$removeSpell(SpellListScreen $this, SpellListItem spell) {
        $this.removeSpell(spell);
    }
}

