/*
 * Decompiled with CFR 0.152.
 */
package com.davidm1a2.afraidofthedark.client.gui.customControls;

import com.davidm1a2.afraidofthedark.client.gui.customControls.GuiSpellStage;
import com.davidm1a2.afraidofthedark.client.gui.customControls.SpellComponentSlot;
import com.davidm1a2.afraidofthedark.client.gui.customControls.SpellPowerSourceSlot;
import com.davidm1a2.afraidofthedark.client.gui.events.KeyEvent;
import com.davidm1a2.afraidofthedark.client.gui.events.MouseEvent;
import com.davidm1a2.afraidofthedark.client.gui.layout.Dimensions;
import com.davidm1a2.afraidofthedark.client.gui.layout.Position;
import com.davidm1a2.afraidofthedark.client.gui.layout.Spacing;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.AOTDGuiComponent;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ButtonPane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.HChainPane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ImagePane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.LabelComponent;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.ListPane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.StackPane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.TextFieldPane;
import com.davidm1a2.afraidofthedark.client.gui.standardControls.VScrollBar;
import com.davidm1a2.afraidofthedark.client.settings.ClientData;
import com.davidm1a2.afraidofthedark.common.capabilities.CapabilityExtensionsKt;
import com.davidm1a2.afraidofthedark.common.capabilities.player.spell.IPlayerSpellManager;
import com.davidm1a2.afraidofthedark.common.spell.Spell;
import com.davidm1a2.afraidofthedark.common.spell.SpellStage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020\fH\u0016J\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u00020\fH\u0002J\b\u00100\u001a\u00020\fH\u0002J\b\u00101\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RH\u0010\r\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n2\u0018\u0010\t\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/davidm1a2/afraidofthedark/client/gui/customControls/SpellTablet;", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/ImagePane;", "spell", "Lcom/davidm1a2/afraidofthedark/common/spell/Spell;", "(Lcom/davidm1a2/afraidofthedark/common/spell/Spell;)V", "addButton", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/ButtonPane;", "buttonLayout", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/HChainPane;", "value", "Lkotlin/Function1;", "Lcom/davidm1a2/afraidofthedark/client/gui/customControls/SpellComponentSlot;", "", "componentEditCallback", "getComponentEditCallback", "()Lkotlin/jvm/functions/Function1;", "setComponentEditCallback", "(Lkotlin/jvm/functions/Function1;)V", "onHelp", "Lkotlin/Function0;", "getOnHelp", "()Lkotlin/jvm/functions/Function0;", "setOnHelp", "(Lkotlin/jvm/functions/Function0;)V", "removeButton", "scrollBar", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/VScrollBar;", "spellCost", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/LabelComponent;", "spellName", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/TextFieldPane;", "spellStageBackground", "spellStageList", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/ListPane;", "spellStagePanel", "Lcom/davidm1a2/afraidofthedark/client/gui/standardControls/StackPane;", "uiPowerSource", "Lcom/davidm1a2/afraidofthedark/client/gui/customControls/SpellPowerSourceSlot;", "uiSpellStages", "", "Lcom/davidm1a2/afraidofthedark/client/gui/customControls/GuiSpellStage;", "addGuiSpellStage", "spellStage", "Lcom/davidm1a2/afraidofthedark/common/spell/SpellStage;", "calcChildrenBounds", "inventoryKeyClosesUI", "", "refresh", "refreshCost", "removeLastGuiSpellStage", "afraidofthedark"})
public final class SpellTablet
extends ImagePane {
    @NotNull
    private final Spell spell;
    @NotNull
    private final TextFieldPane spellName;
    @NotNull
    private final StackPane spellStagePanel;
    @NotNull
    private final ListPane spellStageList;
    @NotNull
    private final ImagePane spellStageBackground;
    @NotNull
    private final List<GuiSpellStage> uiSpellStages;
    @NotNull
    private final SpellPowerSourceSlot uiPowerSource;
    @NotNull
    private final LabelComponent spellCost;
    @NotNull
    private final VScrollBar scrollBar;
    @NotNull
    private final ButtonPane addButton;
    @NotNull
    private final ButtonPane removeButton;
    @NotNull
    private final HChainPane buttonLayout;
    @Nullable
    private Function0<Unit> onHelp;
    @Nullable
    private Function1<? super SpellComponentSlot<?>, Unit> componentEditCallback;

    public SpellTablet(@NotNull Spell spell) {
        Intrinsics.checkNotNullParameter(spell, "spell");
        super("afraidofthedark:textures/gui/spell_editor/tablet_background.png", ImagePane.DispMode.FIT_TO_PARENT);
        this.spell = spell;
        boolean bl = false;
        this.uiSpellStages = new ArrayList();
        this.spellName = new TextFieldPane(new Position(0.2, 0.18, false, 4, null), new Dimensions(0.5, 0.1, false, 4, null), ClientData.INSTANCE.getOrCreate(36.0f));
        this.spellName.setGhostText("Spell Name");
        this.spellName.addKeyListener((Function1<? super KeyEvent, Unit>)new Function1<KeyEvent, Unit>(){

            @Override
            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getEventType() == KeyEvent.KeyEventType.Release) {
                    spell.setName(spellName.getText());
                }
            }
        });
        this.add(this.spellName);
        this.scrollBar = new VScrollBar(new Dimensions(0.08, 0.6, false, 4, null), null, null, null, 14, null);
        this.scrollBar.setOffset(new Position(0.05, 0.3, false, 4, null));
        this.add(this.scrollBar);
        this.spellStagePanel = new StackPane(new Dimensions(0.6, 0.6, false, 4, null), null, null, null, null, null, false, 126, null);
        this.spellStagePanel.setOffset(new Position(0.15, 0.3, false, 4, null));
        this.add(this.spellStagePanel);
        this.spellStageBackground = new ImagePane("afraidofthedark:textures/gui/spell_editor/spell_stage_panel_background.png", ImagePane.DispMode.STRETCH);
        this.spellStageBackground.setPrefSize(new Dimensions(1.0, 1.0, false, 4, null));
        this.spellStagePanel.add(this.spellStageBackground);
        this.spellStageList = new ListPane(ListPane.ExpandDirection.DOWN, this.scrollBar, 0.0, 4, null);
        this.spellStageList.setPadding(new Spacing(0.02, false, 2, null));
        this.spellStagePanel.add(this.spellStageList);
        this.addButton = new ButtonPane(new ImagePane("afraidofthedark:textures/gui/spell_editor/add.png", null, 2, null), new ImagePane("afraidofthedark:textures/gui/spell_editor/add_hovered.png", null, 2, null), false, null, null, null, null, new Dimensions(0.45, 1.0, false, 4, null), null, null, 892, null);
        this.addButton.addOnClick((Function1<? super MouseEvent, Unit>)new Function1<MouseEvent, Unit>(){

            @Override
            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                SpellStage newStage = new SpellStage();
                spell.getSpellStages().add(newStage);
                this.addGuiSpellStage(newStage);
                this.invalidate();
                addButton.setHovered(false);
            }
        });
        this.removeButton = new ButtonPane(new ImagePane("afraidofthedark:textures/gui/spell_editor/delete.png", null, 2, null), new ImagePane("afraidofthedark:textures/gui/spell_editor/delete_hovered.png", null, 2, null), false, null, null, null, null, new Dimensions(0.45, 1.0, false, 4, null), null, null, 892, null);
        this.removeButton.addOnClick((Function1<? super MouseEvent, Unit>)new Function1<MouseEvent, Unit>(){

            @Override
            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (spell.getSpellStages().size() > 1) {
                    CollectionsKt.removeLast(spell.getSpellStages());
                }
                this.removeLastGuiSpellStage();
                this.invalidate();
                removeButton.setHovered(false);
            }
        });
        this.buttonLayout = new HChainPane(null, 1, null);
        this.buttonLayout.setPrefSize(new Dimensions(0.25, 0.08, false, 4, null));
        this.buttonLayout.add(this.addButton);
        this.buttonLayout.add(this.removeButton);
        this.spellStageList.add(this.buttonLayout);
        ButtonPane saveButton = new ButtonPane(new ImagePane("afraidofthedark:textures/gui/spell_editor/save.png", null, 2, null), new ImagePane("afraidofthedark:textures/gui/spell_editor/save_hovered.png", null, 2, null), false, null, null, null, null, new Dimensions(0.13, 0.1, false, 4, null), new Position(0.76, 0.4, false, 4, null), null, 636, null);
        saveButton.setHoverText("Save Spell");
        saveButton.addOnClick((Function1<? super MouseEvent, Unit>)new Function1<MouseEvent, Unit>(){

            @Override
            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                IPlayerSpellManager spellManager = CapabilityExtensionsKt.getSpellManager((PlayerEntity)AOTDGuiComponent.Companion.getEntityPlayer());
                Spell spellClone = new Spell(spell.serializeNBT());
                spellManager.addOrUpdateSpell(spellClone);
                spellManager.sync((PlayerEntity)AOTDGuiComponent.Companion.getEntityPlayer(), spellClone);
                Object[] objectArray = new Object[]{spellClone.getName()};
                AOTDGuiComponent.Companion.getEntityPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("message.afraidofthedark.spell.save_successful", objectArray));
            }
        });
        this.add(saveButton);
        ButtonPane closeButton = new ButtonPane(new ImagePane("afraidofthedark:textures/gui/spell_editor/delete.png", null, 2, null), new ImagePane("afraidofthedark:textures/gui/spell_editor/delete_hovered.png", null, 2, null), false, null, null, null, null, new Dimensions(0.13, 0.1, false, 4, null), new Position(0.76, 0.52, false, 4, null), null, 636, null);
        closeButton.setHoverText("Exit (Without Saving)");
        closeButton.addOnClick(5.INSTANCE);
        this.add(closeButton);
        ButtonPane helpButton = new ButtonPane(new ImagePane("afraidofthedark:textures/gui/spell_editor/question.png", null, 2, null), new ImagePane("afraidofthedark:textures/gui/spell_editor/question_hovered.png", null, 2, null), false, null, null, null, null, new Dimensions(0.13, 0.1, false, 4, null), new Position(0.76, 0.64, false, 4, null), null, 636, null);
        helpButton.setHoverText("Help");
        helpButton.addOnClick((Function1<? super MouseEvent, Unit>)new Function1<MouseEvent, Unit>(){

            @Override
            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Function0<Unit> function0 = this.getOnHelp();
                if (function0 != null) {
                    function0.invoke();
                }
            }
        });
        this.add(helpButton);
        this.uiPowerSource = new SpellPowerSourceSlot(new Position(0.57, 0.07, false, 4, null), new Dimensions(0.13, 0.1, false, 4, null), this.spell);
        this.uiPowerSource.setSpellComponent(this.spell.getPowerSource());
        this.add(this.uiPowerSource);
        this.spellCost = new LabelComponent(ClientData.INSTANCE.getOrCreate(36.0f), new Dimensions(0.7, 0.13, false, 4, null), null, 4, null);
        this.spellCost.setOffset(new Position(0.15, 0.87, false, 4, null));
        this.add(this.spellCost);
        this.refresh();
    }

    @Nullable
    public final Function0<Unit> getOnHelp() {
        return this.onHelp;
    }

    public final void setOnHelp(@Nullable Function0<Unit> function0) {
        this.onHelp = function0;
    }

    @Nullable
    public final Function1<SpellComponentSlot<?>, Unit> getComponentEditCallback() {
        return this.componentEditCallback;
    }

    public final void setComponentEditCallback(@Nullable Function1<? super SpellComponentSlot<?>, Unit> value) {
        this.componentEditCallback = value;
        Iterable $this$forEach$iv = this.uiSpellStages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GuiSpellStage it = (GuiSpellStage)element$iv;
            boolean bl = false;
            it.setComponentEditCallback(this.componentEditCallback);
        }
    }

    private final void refresh() {
        Object it;
        this.uiPowerSource.setSpellComponent(this.spell.getPowerSource());
        this.spellName.setText(this.spell.getName());
        while (true) {
            Collection collection = this.uiSpellStages;
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            this.removeLastGuiSpellStage();
        }
        Iterable $this$forEach$iv = this.spell.getSpellStages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SpellStage)element$iv;
            boolean bl = false;
            this.addGuiSpellStage((SpellStage)it);
        }
        $this$forEach$iv = this.uiSpellStages;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GuiSpellStage)element$iv;
            boolean bl = false;
            ((GuiSpellStage)it).refresh();
        }
        this.refreshCost();
    }

    private final void refreshCost() {
        this.spellCost.setText(Intrinsics.stringPlus("Cost: ", MathKt.roundToInt(this.spell.getCost())));
    }

    private final void addGuiSpellStage(SpellStage spellStage) {
        GuiSpellStage spellStageGui = new GuiSpellStage(spellStage, this.spell, this.componentEditCallback);
        this.spellStageList.remove(this.buttonLayout);
        this.spellStageList.add(spellStageGui);
        this.spellStageList.add(this.buttonLayout);
        this.uiSpellStages.add(spellStageGui);
        this.removeButton.setVisible(this.uiSpellStages.size() > 1);
    }

    private final void removeLastGuiSpellStage() {
        Collection collection = this.uiSpellStages;
        boolean bl = false;
        if (!collection.isEmpty()) {
            GuiSpellStage lastStage = this.uiSpellStages.get(this.uiSpellStages.size() - 1);
            this.spellStageList.remove(lastStage);
            this.uiSpellStages.remove(lastStage);
            this.removeButton.setVisible(this.uiSpellStages.size() > 1);
        }
    }

    @Override
    public void calcChildrenBounds() {
        super.calcChildrenBounds();
        LabelComponent labelComponent = this.spellCost;
        if (labelComponent != null) {
            LabelComponent labelComponent2 = labelComponent;
            boolean bl = false;
            boolean bl2 = false;
            LabelComponent it = labelComponent2;
            boolean bl3 = false;
            this.refreshCost();
        }
    }

    public final boolean inventoryKeyClosesUI() {
        return !this.spellName.isFocused();
    }
}

