/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lava_monster;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="lava_monster", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LavaMonsterConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ServerConfig SERVER;
    public static float monsterHealth;
    public static double monsterArmor;
    public static double monsterRange;
    public static int attackCooldown;
    public static int attackShots;
    public static int attackSpacing;
    public static int attackWindup;
    public static String dimensionWhitelist;
    public static boolean shouldUseVanillaSpawning;
    public static boolean depthHazard;
    public static boolean flowingLava;
    public static boolean shallowLava;
    public static double spawnChance;
    public static int spawnFrequency;

    @SubscribeEvent
    public static void onLoadConfig(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == CLIENT_SPEC) {
            ConfigBakery.bakeClient(config);
        } else if (config.getSpec() == SERVER_SPEC) {
            ConfigBakery.bakeServer(config);
        }
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)pair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        pair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER = (ServerConfig)pair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    private static class ConfigBakery {
        private static ModConfig clientConfig;
        private static ModConfig serverConfig;

        private ConfigBakery() {
        }

        public static void bakeClient(ModConfig config) {
            clientConfig = config;
        }

        public static void bakeServer(ModConfig config) {
            serverConfig = config;
            monsterHealth = ((Double)LavaMonsterConfig.SERVER.monsterHealth.get()).floatValue();
            monsterArmor = (Double)LavaMonsterConfig.SERVER.monsterArmor.get();
            monsterRange = (Double)LavaMonsterConfig.SERVER.monsterRange.get();
            attackCooldown = (Integer)LavaMonsterConfig.SERVER.attackCooldown.get();
            attackShots = (Integer)LavaMonsterConfig.SERVER.attackShots.get();
            attackSpacing = (Integer)LavaMonsterConfig.SERVER.attackSpacing.get();
            attackWindup = (Integer)LavaMonsterConfig.SERVER.attackWindup.get();
            depthHazard = (Boolean)LavaMonsterConfig.SERVER.depthHazard.get();
            flowingLava = (Boolean)LavaMonsterConfig.SERVER.flowingLava.get();
            shallowLava = (Boolean)LavaMonsterConfig.SERVER.shallowLava.get();
            spawnChance = (Double)LavaMonsterConfig.SERVER.spawnChance.get();
            spawnFrequency = (Integer)LavaMonsterConfig.SERVER.spawnFrequency.get();
            dimensionWhitelist = (String)LavaMonsterConfig.SERVER.dimensionWhitelist.get();
            shouldUseVanillaSpawning = (Boolean)LavaMonsterConfig.SERVER.shouldUseVanillaSpawning.get();
        }
    }

    private static class ClientConfig {
        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Client side changes.").push("client");
            builder.pop();
        }
    }

    private static class ServerConfig {
        public final ForgeConfigSpec.ConfigValue<Double> monsterHealth;
        public final ForgeConfigSpec.ConfigValue<Double> monsterArmor;
        public final ForgeConfigSpec.ConfigValue<Double> monsterRange;
        public final ForgeConfigSpec.ConfigValue<Integer> attackCooldown;
        public final ForgeConfigSpec.ConfigValue<Integer> attackShots;
        public final ForgeConfigSpec.ConfigValue<Integer> attackSpacing;
        public final ForgeConfigSpec.ConfigValue<Integer> attackWindup;
        public final ForgeConfigSpec.ConfigValue<Boolean> depthHazard;
        public final ForgeConfigSpec.ConfigValue<Boolean> flowingLava;
        public final ForgeConfigSpec.ConfigValue<Boolean> shallowLava;
        public final ForgeConfigSpec.ConfigValue<String> dimensionWhitelist;
        public final ForgeConfigSpec.ConfigValue<Double> spawnChance;
        public final ForgeConfigSpec.ConfigValue<Integer> spawnFrequency;
        public final ForgeConfigSpec.ConfigValue<Boolean> shouldUseVanillaSpawning;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Common changes").push("common");
            this.monsterHealth = builder.translation("monsterHealth").comment("Lava monsters' maximum health.").define("monsterHealth", (Object)16.0);
            this.monsterArmor = builder.translation("monsterArmor").comment("The amount of armor lava monsters have.").define("monsterArmor", (Object)0.0);
            this.monsterRange = builder.translation("monsterRange").comment("The distance a lava monster will begin attacking. (maximum of 35)").define("monsterRange", (Object)17.0);
            this.attackCooldown = builder.translation("attackCooldown").comment("Ticks a monster must wait after attacking before it can start winding up again.").define("attackCooldown", (Object)80);
            this.attackShots = builder.translation("attackShots").comment("Number of fireballs shot with each attack.").define("attackShots", (Object)3);
            this.attackSpacing = builder.translation("attackSpacing").comment("Ticks between each fireball shot in an attack.").define("attackSpacing", (Object)6);
            this.attackWindup = builder.translation("attackWindup").comment("Ticks it takes before a monster can start an attack.").define("attackWindup", (Object)60);
            builder.comment("Spawning").push("spawning");
            this.dimensionWhitelist = builder.translation("dimensionWhitelist").comment("Allows you to choose which dimensions the Lava Monster spawns in. Add dimensions by their registry name/id, and separate them with commas, no spaces.").define("dimensionWhitelist", (Object)"minecraft:overworld,minecraft:the_nether,good_nights_sleep:nightmare");
            this.shouldUseVanillaSpawning = builder.translation("shouldUseVanillaSpawning").worldRestart().comment("If enabled, the Lava Monster will instead use traditional vanilla spawning. \nThis means the Lava Monster will attempt to spawn in groups, and less frequently, spawning significantly less frequently outside of lava-filled places like the Nether. \nThis will remove any negative effects the classic Lava Monster spawning might have on server performance. \nHowever, due to the lack of spawns outside of places such as the Nether, and lack of configuration, this is disabled by default.").define("shouldUseVanillaSpawning", false);
            builder.comment("Classic Spawning Options (Used when shouldUseVanillaSpawning is disabled)").push("classic_spawning");
            this.depthHazard = builder.translation("depthHazard").comment("If true, lava monsters will not spawn above layer 16. \nThis will not take effect if the shouldUseVanillaSpawning option is enabled.").define("depthHazard", false);
            this.flowingLava = builder.translation("flowingLava").comment("If true, lava monsters do not require a source block to spawn. \nThis will not take effect if the shouldUseVanillaSpawning option is enabled.").define("flowingLava", false);
            this.shallowLava = builder.translation("shallowLava").comment("If true, lava monsters will be able to spawn in lava one block deep. \nThis will not take effect if the shouldUseVanillaSpawning option is enabled.").define("shallowLava", false);
            this.spawnChance = builder.translation("spawnChance").comment("The percentage chance for a lava monster spawn attempt to be successful. 1.0 means 100%. \nThis will not take effect if the shouldUseVanillaSpawning option is enabled.").define("spawnChance", (Object)0.05);
            this.spawnFrequency = builder.translation("spawnFrequency").comment("The number of ticks between each lava monster spawn attempt. \nThis will not take effect if the shouldUseVanillaSpawning option is enabled.").define("spawnFrequency", (Object)10);
            builder.pop();
        }
    }
}

