/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.player;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftcapes.MinecraftCapes;
import org.apache.commons.codec.binary.Base64;

public class PlayerHandler {
    private static HashMap<UUID, PlayerHandler> instances = new HashMap();
    private boolean hasStaticCape = false;
    private boolean hasEars = false;
    private boolean hasAnimatedCape = false;
    private Boolean showCape = true;
    private Boolean hasCapeGlint = false;
    private boolean upsideDown = false;
    private Boolean hasInfo = false;
    private UUID playerUUID;
    private Int2ObjectMap<NativeImage> animatedCape;
    private long lastFrameTime = 0L;
    private int lastFrame = 0;
    private int capeInterval = 100;

    public PlayerHandler(Player player) {
        this.playerUUID = player.m_142081_();
        instances.put(this.playerUUID, this);
    }

    public static PlayerHandler getFromPlayer(Player player) {
        PlayerHandler playerHandler = instances.get(player.m_142081_());
        return playerHandler == null ? new PlayerHandler(player) : playerHandler;
    }

    private NativeImage readTexture(String textureBase64) {
        try {
            byte[] imgBytes = Base64.decodeBase64((String)textureBase64);
            ByteArrayInputStream bias = new ByteArrayInputStream(imgBytes);
            return NativeImage.m_85058_((InputStream)bias);
        }
        catch (IOException e) {
            MinecraftCapes.getLogger().error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public void applyCape(String cape) {
        NativeImage capeImage = this.readTexture(cape);
        if (capeImage.m_85084_() != capeImage.m_84982_() / 2) {
            Int2ObjectOpenHashMap animatedCape = new Int2ObjectOpenHashMap();
            int totalFrames = capeImage.m_85084_() / (capeImage.m_84982_() / 2);
            for (int currentFrame = 0; currentFrame < totalFrames; ++currentFrame) {
                NativeImage frame = new NativeImage(capeImage.m_84982_(), capeImage.m_84982_() / 2, true);
                for (int x = 0; x < frame.m_84982_(); ++x) {
                    for (int y = 0; y < frame.m_85084_(); ++y) {
                        frame.m_84988_(x, y, capeImage.m_84985_(x, y + currentFrame * (capeImage.m_84982_() / 2)));
                    }
                }
                animatedCape.put(currentFrame, (Object)frame);
            }
            this.setAnimatedCape((Int2ObjectMap<NativeImage>)animatedCape);
            MinecraftCapes.getLogger().debug("Animated cape loaded for {}", (Object)this.playerUUID);
        } else {
            int imageHeight;
            int imageWidth = 64;
            int srcWidth = capeImage.m_84982_();
            int srcHeight = capeImage.m_85084_();
            for (imageHeight = 32; imageWidth < srcWidth || imageHeight < srcHeight; imageWidth *= 2, imageHeight *= 2) {
            }
            NativeImage imgNew = new NativeImage(imageWidth, imageHeight, true);
            for (int x = 0; x < capeImage.m_84982_(); ++x) {
                for (int y = 0; y < capeImage.m_85084_(); ++y) {
                    imgNew.m_84988_(x, y, capeImage.m_84985_(x, y));
                }
            }
            capeImage.close();
            this.applyTexture(new ResourceLocation("minecraftcapes", "capes/" + this.playerUUID), imgNew);
            this.setHasStaticCape(true);
            MinecraftCapes.getLogger().debug("Static cape loaded for {}", (Object)this.playerUUID);
        }
    }

    public void applyEars(String ears) {
        NativeImage earImage = this.readTexture(ears);
        this.applyTexture(new ResourceLocation("minecraftcapes", "ears/" + this.playerUUID), earImage);
        this.setHasEars(true);
    }

    public void setAnimatedCape(Int2ObjectMap<NativeImage> animatedCape) {
        MinecraftCapes.getLogger().debug("Setting animated cape for {}", (Object)this.playerUUID);
        this.animatedCape = animatedCape;
        this.setHasAnimatedCape(true);
        this.loadFramesToResource();
    }

    private void loadFramesToResource() {
        MinecraftCapes.getLogger().debug("Loading resources to memory for {}", (Object)this.playerUUID);
        this.getAnimatedCape().forEach((integer, nativeImage) -> {
            ResourceLocation currentResource = new ResourceLocation("minecraftcapes", String.format("capes/%s/%d", this.playerUUID, integer));
            this.applyTexture(currentResource, (NativeImage)nativeImage);
        });
    }

    private ResourceLocation getFrame() {
        long time = System.currentTimeMillis();
        if (time > this.lastFrameTime + (long)this.capeInterval) {
            int currentFrameNo;
            this.lastFrame = currentFrameNo = this.lastFrame + 1 > this.getAnimatedCape().size() - 1 ? 0 : this.lastFrame + 1;
            this.lastFrameTime = time;
            return new ResourceLocation("minecraftcapes", String.format("capes/%s/%d", this.playerUUID, currentFrameNo));
        }
        return new ResourceLocation("minecraftcapes", String.format("capes/%s/%d", this.playerUUID, this.lastFrame));
    }

    public ResourceLocation getCapeLocation() {
        return this.hasStaticCape ? new ResourceLocation("minecraftcapes", "capes/" + this.playerUUID) : (this.hasAnimatedCape ? this.getFrame() : null);
    }

    public ResourceLocation getEarLocation() {
        return this.hasEars ? new ResourceLocation("minecraftcapes", "ears/" + this.playerUUID) : null;
    }

    private void applyTexture(ResourceLocation resourceLocation, NativeImage nativeImage) {
        Minecraft.m_91087_().execute(() -> Minecraft.m_91087_().m_91097_().m_118495_(resourceLocation, (AbstractTexture)new DynamicTexture(nativeImage)));
    }

    public String toString() {
        return "PlayerHandler{hasStaticCape=" + this.hasStaticCape + ", hasEars=" + this.hasEars + ", hasAnimatedCape=" + this.hasAnimatedCape + ", hasCapeGlint=" + this.hasCapeGlint + ", upsideDown=" + this.upsideDown + ", hasInfo=" + this.hasInfo + ", playerUUID=" + this.playerUUID + ", animatedCape=" + this.animatedCape + ", lastFrameTime=" + this.lastFrameTime + ", lastFrame=" + this.lastFrame + ", capeInterval=" + this.capeInterval + "}";
    }

    public void setHasStaticCape(boolean hasStaticCape) {
        this.hasStaticCape = hasStaticCape;
    }

    public void setHasEars(boolean hasEars) {
        this.hasEars = hasEars;
    }

    public void setHasAnimatedCape(boolean hasAnimatedCape) {
        this.hasAnimatedCape = hasAnimatedCape;
    }

    public Boolean getShowCape() {
        return this.showCape;
    }

    public void setShowCape(Boolean showCape) {
        this.showCape = showCape;
    }

    public Boolean getHasCapeGlint() {
        return this.hasCapeGlint;
    }

    public void setHasCapeGlint(Boolean hasCapeGlint) {
        this.hasCapeGlint = hasCapeGlint;
    }

    public boolean isUpsideDown() {
        return this.upsideDown;
    }

    public void setUpsideDown(boolean upsideDown) {
        this.upsideDown = upsideDown;
    }

    public Boolean getHasInfo() {
        return this.hasInfo;
    }

    public void setHasInfo(Boolean hasInfo) {
        this.hasInfo = hasInfo;
    }

    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public Int2ObjectMap<NativeImage> getAnimatedCape() {
        return this.animatedCape;
    }
}

