/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.config;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.client.Minecraft;

public class MinecraftCapesConfig {
    private static File runDirectory = Minecraft.m_91087_().f_91069_;
    private static Path configFile = Paths.get(runDirectory + "/config/minecraftcapes.json", new String[0]);
    private static ConfigValues config = null;

    public static void setCapeVisible(boolean enabled) {
        MinecraftCapesConfig.config.capeVisible = enabled;
        MinecraftCapesConfig.saveConfig();
    }

    public static void setEarsVisible(boolean enabled) {
        MinecraftCapesConfig.config.earsVisible = enabled;
        MinecraftCapesConfig.saveConfig();
    }

    public static boolean isCapeVisible() {
        return MinecraftCapesConfig.config.capeVisible;
    }

    public static boolean isEarsVisible() {
        return MinecraftCapesConfig.config.earsVisible;
    }

    public static void loadConfig() {
        try {
            if (!configFile.toFile().exists()) {
                InputStream defaultConfigFile = MinecraftCapesConfig.class.getResourceAsStream("/assets/minecraftcapes/config.json");
                Files.copy(defaultConfigFile, configFile, new CopyOption[0]);
            }
            FileReader reader = new FileReader(configFile.toFile());
            config = (ConfigValues)new Gson().fromJson((Reader)reader, ConfigValues.class);
            ((Reader)reader).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void saveConfig() {
        try {
            FileWriter writer = new FileWriter(configFile.toFile());
            new Gson().toJson((Object)config, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ConfigValues getConfig() {
        return config;
    }

    class ConfigValues {
        private boolean capeVisible = true;
        private boolean earsVisible = true;

        ConfigValues() {
        }
    }
}

