/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes;

import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraftcapes.compatibility.CaelusHook;
import net.minecraftcapes.config.MinecraftCapesConfig;
import net.minecraftcapes.events.AddLayersEvent;
import net.minecraftcapes.events.KeyHandlerEvent;
import net.minecraftcapes.events.PlayerEventHandler;
import net.minecraftcapes.events.PlayerRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmlclient.registry.ClientRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="minecraftcapes")
public class MinecraftCapes {
    public static final String MODID = "minecraftcapes";
    private static final Logger logger = LogManager.getFormatterLogger((String)"MinecraftCapes");
    public static KeyMapping menuKey;

    public MinecraftCapes() {
        MinecraftCapes.getLogger().info("Initialising");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverSetup);
        MinecraftCapes.getLogger().info("Initialised");
    }

    public void clientSetup(FMLClientSetupEvent event) {
        MinecraftCapesConfig.loadConfig();
        if (this.doesClassExist("top.theillusivec4.caelus.api.CaelusApi")) {
            new CaelusHook();
        }
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerRenderEvent());
        MinecraftForge.EVENT_BUS.register((Object)new KeyHandlerEvent());
        MinecraftForge.EVENT_BUS.register((Object)new AddLayersEvent());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(AddLayersEvent::construct);
        Minecraft.m_91087_().f_91066_.m_168418_(PlayerModelPart.CAPE, true);
        menuKey = new KeyMapping("key.minecraftcapes.gui", 74, "category.minecraftcapes.gui");
        ClientRegistry.registerKeyBinding((KeyMapping)menuKey);
    }

    public void serverSetup(FMLDedicatedServerSetupEvent event) {
        MinecraftCapes.getLogger().error("MinecraftCapes has been loaded on server side. MinecraftCapes is a client only mod. No need to worry about this. You can delete the mod if you wish!");
    }

    private boolean doesClassExist(String name) {
        try {
            Class<?> c = Class.forName(name);
            System.out.println(c);
            if (c != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static Logger getLogger() {
        return logger;
    }
}

